/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.actorapi.event.HumanTaskEvent;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class HumanTaskCreated
extends HumanTaskEvent {
    private final Instant createdOn;
    private final String createdBy;

    @Deprecated
    public HumanTaskCreated(HumanTask humanTask) {
        super(humanTask);
        this.createdOn = humanTask.getCaseInstance().getTransactionTimestamp();
        this.createdBy = humanTask.getCaseInstance().getCurrentUser().id();
        throw new IllegalArgumentException("This code is no longer in use");
    }

    public HumanTaskCreated(ValueMap valueMap) {
        super(valueMap);
        this.createdOn = valueMap.readInstant((Object)Fields.createdOn);
        this.createdBy = valueMap.readString((Object)Fields.createdBy, new String[0]);
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public String toString() {
        return "HumanTask[" + this.getTaskId() + "] is active";
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeHumanTaskEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.createdOn, this.createdOn);
        this.writeField(jsonGenerator, (Object)Fields.createdBy, this.createdBy);
    }
}

