/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.serialization;

import java.lang.reflect.InvocationTargetException;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.infrastructure.serialization.Migrator;
import org.cafienne.infrastructure.serialization.TargetVersion;
import org.cafienne.infrastructure.serialization.ValueMapDeserializer;
import org.cafienne.json.ValueMap;

public class ManifestWrapper {
    private static final String VERSION_SEPARATOR = ";";
    public final Manifest manifest;
    public final Class<?> eventClass;
    public final ValueMapDeserializer<?> deserializer;
    public final String string;
    public final int version;
    public final String current;
    final Migrator[] migrators;
    public final String[] manifestsByVersion;

    public ManifestWrapper(Class<?> clazz, ValueMapDeserializer<?> valueMapDeserializer) {
        if (clazz == null) {
            throw new NullPointerException("Cannot create a ManifestWrapper without an event class");
        }
        if (valueMapDeserializer == null) {
            throw new NullPointerException("The ManifestWrapper for " + clazz.getName() + " must provide a ValueMapDeserializer");
        }
        this.eventClass = clazz;
        this.deserializer = valueMapDeserializer;
        this.manifest = clazz.getAnnotation(Manifest.class);
        if (this.manifest == null) {
            throw new RuntimeException("The ManifestWrapper for " + clazz.getName() + " must have an annotation of type " + Manifest.class.getName());
        }
        this.string = this.manifest.value().isEmpty() ? clazz.getSimpleName() : this.manifest.value();
        this.version = this.manifest.version();
        this.current = this.version == 0 ? this.string : this.string + VERSION_SEPARATOR + this.version;
        this.migrators = new Migrator[this.manifest.version()];
        this.manifestsByVersion = new String[this.manifest.version() + 1];
        this.analyzeMigrators();
        this.determineManifestStrings();
    }

    private void analyzeMigrators() {
        Class<? extends Migrator>[] classArray = this.manifest.migrators();
        for (int i = 0; i < classArray.length; ++i) {
            Class<? extends Migrator> clazz = classArray[i];
            try {
                Migrator migrator = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                TargetVersion targetVersion = migrator.getClass().getAnnotation(TargetVersion.class);
                if (targetVersion == null) {
                    throw new RuntimeException("Migrator " + clazz.getName() + " misses a TargetVersion annotation");
                }
                if (targetVersion.value() <= 0) {
                    throw new RuntimeException("Migrator " + clazz.getName() + " has an invalid TargetVersion (" + targetVersion.value() + "). TargetVersions must be 1 or higher.");
                }
                int n = targetVersion.value() - 1;
                this.migrators[n] = migrator;
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException("Migrator class " + clazz.getName() + " in ManifestWrapper of " + this.eventClass.getName() + " cannot be instantiated", reflectiveOperationException.fillInStackTrace());
            }
        }
    }

    private void determineManifestStrings() {
        for (int i = this.version; i > 0; --i) {
            this.manifestsByVersion[i] = this.string + VERSION_SEPARATOR + i;
        }
        this.manifestsByVersion[0] = this.string;
    }

    public ValueMap migrate(ValueMap valueMap, String string) {
        if (this.current.equals(string)) {
            return valueMap;
        }
        int n = 0;
        int n2 = string.lastIndexOf(VERSION_SEPARATOR);
        if (n2 > 0) {
            n = Integer.parseInt(string.substring(n2 + 1));
        }
        for (int i = n; i < this.version; ++i) {
            valueMap = this.migrators[i].traverse(valueMap);
        }
        return valueMap;
    }

    public String toString() {
        return this.current;
    }
}

