/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.cmmn.expression.spel.SpelReadable;
import org.cafienne.json.PrimitiveValue;
import org.cafienne.json.Value;

class NullValue
extends PrimitiveValue<Object>
implements SpelReadable,
List<Object> {
    NullValue() {
        super(null);
    }

    @Override
    public void print(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeNull();
    }

    public NullValue cloneValueNode() {
        return this;
    }

    @Override
    public boolean matches(PropertyDefinition.PropertyType propertyType) {
        return true;
    }

    @Override
    public boolean isSupersetOf(Value<?> value) {
        return value == null || value.value == null;
    }

    @Override
    public String toString() {
        return "null";
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public Value<?> read(String string) {
        return this;
    }

    @Override
    public boolean canRead(String string) {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public Iterator<Object> iterator() {
        final NullValue nullValue = this;
        return new Iterator(){

            public Object next() {
                return nullValue;
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return TArray;
    }

    @Override
    public boolean add(Object object) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Object> collection) {
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends Object> collection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public Object get(int n) {
        return this;
    }

    @Override
    public Object set(int n, Object object) {
        return null;
    }

    @Override
    public void add(int n, Object object) {
    }

    @Override
    public Object remove(int n) {
        return null;
    }

    @Override
    public int indexOf(Object object) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object object) {
        return -1;
    }

    @Override
    public ListIterator<Object> listIterator() {
        final NullValue nullValue = this;
        return new ListIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                return nullValue;
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            public Object previous() {
                return nullValue;
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return 0;
            }

            @Override
            public void remove() {
            }

            public void set(Object object) {
            }

            public void add(Object object) {
            }
        };
    }

    @Override
    public ListIterator<Object> listIterator(int n) {
        return this.listIterator();
    }

    @Override
    public List<Object> subList(int n, int n2) {
        return this;
    }
}

