/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.json.PrimitiveValue;

public class StringValue
extends PrimitiveValue<String> {
    private static DatatypeFactory instance;

    public StringValue(String string) {
        super(string);
    }

    @Override
    public void print(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeString((String)this.value);
    }

    public StringValue cloneValueNode() {
        return new StringValue((String)this.value);
    }

    @Override
    public boolean matches(PropertyDefinition.PropertyType propertyType) throws IllegalArgumentException {
        switch (propertyType) {
            case String: 
            case Unspecified: {
                return true;
            }
            case Date: {
                return this.matchDate();
            }
            case Duration: {
                return this.matchDuration();
            }
            case DateTime: {
                return this.matchDateTime();
            }
            case Time: {
                return this.matchTime();
            }
            case GDay: {
                return this.matchGDay();
            }
            case GMonth: {
                return this.matchGMonth();
            }
            case GMonthDay: {
                return this.matchGMonthDay();
            }
            case GYear: {
                return this.matchGYear();
            }
            case GYearMonth: {
                return this.matchGYearMonth();
            }
            case QName: {
                return this.matchQName();
            }
            case AnyURI: {
                return this.matchAnyURI();
            }
        }
        return false;
    }

    private boolean matchDateTime() {
        DatatypeConverter.parseDateTime((String)((String)this.value));
        return true;
    }

    private boolean matchDate() {
        DatatypeConverter.parseDate((String)((String)this.value));
        return true;
    }

    private boolean matchDuration() {
        StringValue.getDatatypeFactory().newDuration((String)this.value);
        return true;
    }

    private boolean matchTime() {
        DatatypeConverter.parseTime((String)((String)this.value));
        return true;
    }

    private boolean matchGDay() {
        int n = this.getCalendar().getDay();
        return n != Integer.MIN_VALUE;
    }

    private boolean matchGMonthDay() {
        XMLGregorianCalendar xMLGregorianCalendar = this.getCalendar();
        int n = xMLGregorianCalendar.getMonth();
        int n2 = xMLGregorianCalendar.getDay();
        return n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE;
    }

    private boolean matchGMonth() {
        XMLGregorianCalendar xMLGregorianCalendar = this.getCalendar();
        int n = xMLGregorianCalendar.getMonth();
        return n != Integer.MIN_VALUE;
    }

    private boolean matchGYear() {
        int n = this.getCalendar().getYear();
        return n != Integer.MIN_VALUE;
    }

    private boolean matchGYearMonth() {
        XMLGregorianCalendar xMLGregorianCalendar = this.getCalendar();
        int n = xMLGregorianCalendar.getMonth();
        int n2 = xMLGregorianCalendar.getYear();
        return n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE;
    }

    private boolean matchQName() {
        DatatypeConverter.parseQName((String)((String)this.value), (NamespaceContext)new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String string) {
                return new Vector().iterator();
            }

            @Override
            public String getPrefix(String string) {
                return "";
            }

            @Override
            public String getNamespaceURI(String string) {
                return "";
            }
        });
        return true;
    }

    private boolean matchAnyURI() {
        return true;
    }

    private XMLGregorianCalendar getCalendar() {
        return StringValue.getDatatypeFactory().newXMLGregorianCalendar((String)this.value);
    }

    private static DatatypeFactory getDatatypeFactory() {
        if (instance == null) {
            try {
                instance = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException("Cannot find a proper data type factory instance", datatypeConfigurationException);
            }
        }
        return instance;
    }
}

