/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.infrastructure.serialization.CafienneSerializable;
import org.cafienne.json.BooleanValue;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.CafienneSerializableValue;
import org.cafienne.json.DoubleValue;
import org.cafienne.json.InstantValue;
import org.cafienne.json.LongValue;
import org.cafienne.json.NonSerializableValue;
import org.cafienne.json.NullValue;
import org.cafienne.json.SerializableValue;
import org.cafienne.json.StringValue;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import scala.collection.Iterable;
import scala.collection.Map;

public abstract class Value<T>
implements Serializable {
    public static final Value<?> NULL = new NullValue();
    protected final T value;
    private transient CaseFileItem owner;

    protected Value(T t) {
        this.value = t;
    }

    public CaseFileItem getOwner() {
        return this.owner;
    }

    public void setOwner(CaseFileItem caseFileItem) {
        this.owner = caseFileItem;
    }

    public void clearOwner() {
        this.setOwner(null);
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.print(jsonGenerator);
            jsonGenerator.close();
        }
        catch (IOException iOException) {
            stringWriter.write("Could not print the value because of error");
            iOException.printStackTrace(new PrintWriter(stringWriter));
        }
        return stringWriter.toString();
    }

    public boolean isSupersetOf(Value<?> value) {
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return this.value == null || this == NULL;
        }
        if (object instanceof Value) {
            Value value = (Value)object;
            if (this.value == null) {
                return value.value == null;
            }
            return this.value.equals(value.value);
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(object);
    }

    public abstract boolean isPrimitive();

    public boolean isList() {
        return false;
    }

    public ValueList asList() {
        return (ValueList)this;
    }

    public boolean isMap() {
        return false;
    }

    public ValueMap asMap() {
        return (ValueMap)this;
    }

    public void print(JsonGenerator jsonGenerator) throws IOException {
    }

    public boolean matches(PropertyDefinition.PropertyType propertyType) {
        return propertyType == PropertyDefinition.PropertyType.Unspecified;
    }

    protected boolean baseMatch(PropertyDefinition.PropertyType propertyType) {
        return propertyType == PropertyDefinition.PropertyType.Unspecified;
    }

    public abstract <V extends Value<?>> V merge(V var1);

    public static Value<?> convert(Object object2) {
        if (object2 == null) {
            return NULL;
        }
        if (object2 instanceof Value) {
            return (Value)object2;
        }
        if (object2 instanceof String) {
            return new StringValue((String)object2);
        }
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            ValueMap valueMap = new ValueMap();
            map.foreach(tuple2 -> valueMap.put(String.valueOf(tuple2._1()), Value.convert(tuple2._2())));
            return valueMap;
        }
        if (object2 instanceof Iterable) {
            Iterable iterable = (Iterable)object2;
            ValueList valueList = new ValueList(new Object[0]);
            iterable.foreach(object -> valueList.add(Value.convert(object)));
            return valueList;
        }
        if (object2 instanceof Object[] || object2.getClass().isArray()) {
            ValueList valueList = new ValueList(new Object[0]);
            for (int i = 0; i < Array.getLength(object2); ++i) {
                Object object3 = Array.get(object2, i);
                valueList.add(Value.convert(Array.get(object2, i)));
            }
            return valueList;
        }
        if (object2 instanceof CafienneJson) {
            return ((CafienneJson)object2).toValue();
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            ValueList valueList = new ValueList(new Object[0]);
            for (Object e : list) {
                valueList.add(Value.convert(e));
            }
            return valueList;
        }
        if (object2 instanceof Boolean) {
            return new BooleanValue((Boolean)object2);
        }
        if (object2 instanceof Double || object2 instanceof Float) {
            return new DoubleValue((Double)object2);
        }
        if (object2 instanceof Long) {
            return new LongValue((Long)object2);
        }
        if (object2 instanceof Integer) {
            return new LongValue(((Integer)object2).intValue());
        }
        if (object2 instanceof Short) {
            return new LongValue(((Short)object2).shortValue());
        }
        if (object2 instanceof Instant) {
            return new InstantValue((Instant)object2);
        }
        if (object2 instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object2;
            ValueMap valueMap = new ValueMap();
            for (Map.Entry entry : map.entrySet()) {
                valueMap.put(String.valueOf(entry.getKey()), Value.convert(entry.getValue()));
            }
            return valueMap;
        }
        if (object2 instanceof Set) {
            Set set = (Set)object2;
            ValueList valueList = new ValueList(new Object[0]);
            for (Object e : set) {
                valueList.add(Value.convert(e));
            }
            return valueList;
        }
        if (object2 instanceof Throwable) {
            return Value.convertThrowable((Throwable)object2);
        }
        if (object2 instanceof CafienneSerializable) {
            return new CafienneSerializableValue((CafienneSerializable)object2);
        }
        if (object2 instanceof Serializable) {
            return new SerializableValue(object2);
        }
        return new NonSerializableValue(object2);
    }

    public static ValueMap convertThrowable(Throwable throwable) {
        ValueMap valueMap = new ValueMap();
        valueMap.put("className", new StringValue(throwable.getClass().getName()));
        valueMap.put("message", new StringValue(throwable.getLocalizedMessage()));
        ValueList valueList = valueMap.withArray("lines");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            valueList.add(new StringValue(stackTraceElement.toString()));
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            valueMap.put("cause", Value.convertThrowable(throwable2));
        }
        return valueMap;
    }

    public abstract Value<?> cloneValueNode();

    public void dumpMemoryStateToXML(Element element) {
        String string = this.toString();
        Text text = element.getOwnerDocument().createTextNode(string);
        element.appendChild(text);
    }
}

