/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.calculation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.instance.task.process.ProcessTask;
import org.cafienne.processtask.definition.InlineSubProcessDefinition;
import org.cafienne.processtask.implementation.calculation.Calculation;
import org.cafienne.processtask.implementation.calculation.definition.FilterStepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.MapStepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.MultiStepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.StepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.InputParameterSourceDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.SourceDefinition;
import org.w3c.dom.Element;

public class CalculationDefinition
extends InlineSubProcessDefinition {
    private final Collection<StepDefinition> steps = new ArrayList<StepDefinition>();
    private final Map<String, SourceDefinition> sources = new HashMap<String, SourceDefinition>();

    public CalculationDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parse("step", StepDefinition.class, this.steps);
        this.parse("filter", FilterStepDefinition.class, this.steps);
        this.parse("map", MapStepDefinition.class, this.steps);
        this.getProcessDefinition().getInputParameters().forEach((string, inputParameterDefinition) -> this.sources.put((String)string, new InputParameterSourceDefinition((InputParameterDefinition)inputParameterDefinition)));
        Set<String> set = this.steps.stream().map(StepDefinition::getIdentifier).collect(Collectors.toSet());
        set.forEach(string -> {
            List<StepDefinition> list = this.steps.stream().filter(stepDefinition -> stepDefinition.getIdentifier().equals(string)).collect(Collectors.toList());
            if (list.size() > 1) {
                this.sources.put((String)string, new MultiStepDefinition(this, (String)string, list));
            } else if (list.size() == 1) {
                this.sources.put((String)string, list.get(0));
            }
        });
        this.getProcessDefinition().getOutputParameters().forEach((string, outputParameterDefinition) -> {
            if (!this.sources.containsKey(string)) {
                modelDefinition.addDefinitionError("Calculation Task '" + modelDefinition.getName() + "' has an output parameter '" + string + "' but no mapping to fill it.");
            }
        });
    }

    public SourceDefinition getSource(String string) {
        return this.sources.get(string);
    }

    public SourceDefinition getTarget(String string) {
        return this.sources.get(string);
    }

    public Calculation createInstance(ProcessTask processTask) {
        return new Calculation(processTask, this);
    }

    @Override
    protected Set<String> getRawOutputParameterNames() {
        return super.getExceptionParameterNames();
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

