/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import java.util.Base64;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.mail.InvalidMailException;
import org.cafienne.processtask.implementation.mail.definition.AttachmentDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class Attachment {
    private final ProcessTaskActor task;
    private final String fileName;
    private final String content;
    private final String mimeType;

    public Attachment(ValueMap valueMap, ProcessTaskActor processTaskActor) {
        this.task = processTaskActor;
        this.content = valueMap.readString((Object)Fields.content, "");
        this.fileName = valueMap.readString((Object)Fields.fileName, "");
        this.mimeType = valueMap.readString((Object)Fields.mimeType, "application/octet-stream");
        if (this.content.isBlank()) {
            processTaskActor.addDebugInfo(() -> "Attachment must be a json object with 'content' (base64 coded) and optional 'fileName' and 'mimeType'; skipping attachment, because 'content' is missing.", new Object[0]);
        }
    }

    public Attachment(AttachmentDefinition attachmentDefinition, ProcessTaskActor processTaskActor) {
        this.task = processTaskActor;
        this.content = attachmentDefinition.getContentResolver().getValue(processTaskActor, "");
        this.fileName = attachmentDefinition.getFileNameResolver().getValue(processTaskActor, "");
        this.mimeType = attachmentDefinition.getMimeTypeResolver().getValue(processTaskActor, "application/octet-stream");
        if (this.content.isBlank()) {
            processTaskActor.addDebugInfo(() -> "Attachment must be a json object with 'content' (base64 coded) and optional 'fileName' and 'mimeType'; skipping attachment, because 'content' is missing.", new Object[0]);
        }
    }

    public boolean hasContent() {
        return !this.content.isBlank();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getContent() {
        return this.content;
    }

    public BodyPart getBodyPart() {
        if (this.content.isBlank()) {
            return null;
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(Base64.getDecoder().decode(this.content), this.mimeType);
        try {
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
            mimeBodyPart.setFileName(this.fileName);
            String string = this.fileName;
            this.task.addDebugInfo(() -> "Added attachment '" + string + "' of length " + this.content.length() + " bytes", new Object[0]);
            return mimeBodyPart;
        }
        catch (MessagingException messagingException) {
            throw new InvalidMailException("Cannot add attachment with file name '" + this.fileName + "'", messagingException);
        }
    }
}

