/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.mail.MailDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class MailPart {
    private final String body;
    private final String type;

    public MailPart(ProcessTaskActor processTaskActor, MailDefinition mailDefinition) {
        if (mailDefinition.getBody() == null) {
            ValueMap valueMap = processTaskActor.getMappedInputParameters();
            this.body = valueMap.has("body") ? valueMap.get("body").getValue().toString() : "";
            this.type = "text/html";
        } else {
            this.body = mailDefinition.getBody().getBody(processTaskActor);
            this.type = mailDefinition.getBody().getBodyType(processTaskActor);
        }
    }

    public MimeBodyPart asPart() throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)this.body, this.type);
        return mimeBodyPart;
    }

    public String toString() {
        return this.body;
    }
}

