/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.processtask.implementation.report.MissingParameterException;
import org.cafienne.processtask.implementation.report.PDFReport;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Element;

public class JasperDefinition
extends CMMNElementDefinition {
    static final String JASPER_XML_TAG = "jasperReport";
    private final boolean isStatic;
    private final String name = this.parseAttribute("name", false, new String[0]);
    private String jasperDefinition = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><jasperReport xmlns=\"http://jasperreports.sourceforge.net/jasperreports\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://jasperreports.sourceforge.net/jasperreports http://jasperreports.sourceforge.net/xsd/jasperreport.xsd\" name=\"EmptyReportDefinition\" pageWidth=\"500\" pageHeight=\"842\" columnWidth=\"500\" leftMargin=\"0\" rightMargin=\"0\" topMargin=\"0\" bottomMargin=\"0\" uuid=\"5a62986f-c97c-4e2f-b4ed-d9f38960dab4\" />";
    private JasperReport preCompiledReport = null;

    public JasperDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.isStatic = this.name.isEmpty();
        if (this.isStatic) {
            Element element2 = XMLHelper.getElement(element, JASPER_XML_TAG);
            if (element2 != null) {
                this.jasperDefinition = XMLHelper.printXMLNode(element2);
            }
            try {
                this.preCompiledReport = this.compile(this.jasperDefinition);
            }
            catch (JRException jRException) {
                this.getModelDefinition().fatalError("Cannot compile the Jasper report definition", jRException);
            }
        }
    }

    public JasperReport createInstance(PDFReport pDFReport) throws JRException, MissingParameterException {
        if (this.isStatic) {
            return this.preCompiledReport;
        }
        Value<?> value = pDFReport.getInputParameters().get(this.name);
        if (value instanceof StringValue) {
            return this.compile((String)((StringValue)value).getValue());
        }
        throw new MissingParameterException(this + " cannot be found in the task input parameters");
    }

    @Override
    public String toString() {
        return "Report definition '" + this.name + "'";
    }

    private JasperReport compile(String string) throws JRException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        return JasperCompileManager.compileReport((InputStream)byteArrayInputStream);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

