/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.CaseEvent;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.file.CaseFileEvent;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamEvent;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.batch.EventBatch;
import org.cafienne.infrastructure.cqrs.offset.OffsetRecord;
import org.cafienne.infrastructure.cqrs.offset.OffsetRecord$;
import org.cafienne.querydb.materializer.QueryDBEventBatch;
import org.cafienne.querydb.materializer.QueryDBStorage;
import org.cafienne.querydb.materializer.cases.CaseEventSink;
import org.cafienne.querydb.materializer.cases.CaseEventSink$;
import org.cafienne.querydb.materializer.cases.CaseProjection;
import org.cafienne.querydb.materializer.cases.CaseReader$;
import org.cafienne.querydb.materializer.cases.CaseStorageTransaction;
import org.cafienne.querydb.materializer.cases.file.CaseFileProjection;
import org.cafienne.querydb.materializer.cases.plan.CasePlanProjection;
import org.cafienne.querydb.materializer.cases.team.CaseTeamProjection;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u000e\u001c\u0001\u0019B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{!A!\t\u0001BC\u0002\u0013\u00053\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003E\u0011!\u0001\u0006A!b\u0001\n\u0003\t\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u000bY\u0003A\u0011A,\t\u000fq\u0003!\u0019!C\u0001\u0007\"1Q\f\u0001Q\u0001\n\u0011C\u0001B\u0018\u0001\t\u0006\u0004%\ta\u0011\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u0019!\u0007\u0001)A\u0005C\"9Q\r\u0001b\u0001\n\u00131\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011B8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\bA1A\u0005\naDaa \u0001!\u0002\u0013I\b\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u0015\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002\u0016\u0002!I!a&\u0003\u001d\r\u000b7/Z#wK:$()\u0019;dQ*\u0011A$H\u0001\u0006G\u0006\u001cXm\u001d\u0006\u0003=}\tA\"\\1uKJL\u0017\r\\5{KJT!\u0001I\u0011\u0002\u000fE,XM]=eE*\u0011!eI\u0001\tG\u00064\u0017.\u001a8oK*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001O5\n\u0004C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/_5\tQ$\u0003\u00021;\t\t\u0012+^3ss\u0012\u0013UI^3oi\n\u000bGo\u00195\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001c8\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001d\u0002\u0007\r|W.\u0003\u0002;g\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0011\u0019\u0018N\\6\u0016\u0003u\u0002\"AP \u000e\u0003mI!\u0001Q\u000e\u0003\u001b\r\u000b7/Z#wK:$8+\u001b8l\u0003\u0015\u0019\u0018N\\6!\u00035\u0001XM]:jgR,gnY3JIV\tA\t\u0005\u0002F\u0019:\u0011aI\u0013\t\u0003\u000f&j\u0011\u0001\u0013\u0006\u0003\u0013\u0016\na\u0001\u0010:p_Rt\u0014BA&*\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-K\u0013A\u00049feNL7\u000f^3oG\u0016LE\rI\u0001\bgR|'/Y4f+\u0005\u0011\u0006C\u0001\u0018T\u0013\t!VD\u0001\bRk\u0016\u0014\u0018\u0010\u0012\"Ti>\u0014\u0018mZ3\u0002\u0011M$xN]1hK\u0002\na\u0001P5oSRtD\u0003\u0002-Z5n\u0003\"A\u0010\u0001\t\u000bm:\u0001\u0019A\u001f\t\u000b\t;\u0001\u0019\u0001#\t\u000bA;\u0001\u0019\u0001*\u0002\u001d\r\f7/Z%ogR\fgnY3JI\u0006y1-Y:f\u0013:\u001cH/\u00198dK&#\u0007%\u0001\u0004uK:\fg\u000e^\u0001\u000eI\n#&/\u00198tC\u000e$\u0018n\u001c8\u0016\u0003\u0005\u0004\"A\u00102\n\u0005\r\\\"AF\"bg\u0016\u001cFo\u001c:bO\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0002\u001d\u0011\u0014EK]1og\u0006\u001cG/[8oA\u0005\u00112-Y:f)\u0016\fW\u000e\u0015:pU\u0016\u001cG/[8o+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016\u001c\u0003\u0011!X-Y7\n\u00051L'AE\"bg\u0016$V-Y7Qe>TWm\u0019;j_:\f1cY1tKR+\u0017-\u001c)s_*,7\r^5p]\u0002\n!cY1tK\u001aKG.\u001a)s_*,7\r^5p]V\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t7\u0005!a-\u001b7f\u0013\t)(O\u0001\nDCN,g)\u001b7f!J|'.Z2uS>t\u0017aE2bg\u00164\u0015\u000e\\3Qe>TWm\u0019;j_:\u0004\u0013AE2bg\u0016\u0004F.\u00198Qe>TWm\u0019;j_:,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003yn\tA\u0001\u001d7b]&\u0011ap\u001f\u0002\u0013\u0007\u0006\u001cX\r\u00157b]B\u0013xN[3di&|g.A\ndCN,\u0007\u000b\\1o!J|'.Z2uS>t\u0007%\u0001\bdCN,\u0007K]8kK\u000e$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0001c\u0001 \u0002\b%\u0019\u0011\u0011B\u000e\u0003\u001d\r\u000b7/\u001a)s_*,7\r^5p]\u0006y1-Y:f!J|'.Z2uS>t\u0007%\u0001\nde\u0016\fG/Z(gMN,GOU3d_J$G\u0003BA\t\u0003K\u0001B!a\u0005\u0002\"5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0004pM\u001a\u001cX\r\u001e\u0006\u0005\u00037\ti\"\u0001\u0003dcJ\u001c(bAA\u0010C\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017\u0002BA\u0012\u0003+\u0011Ab\u00144gg\u0016$(+Z2pe\u0012Dq!a\u0006\u0016\u0001\u0004\t9\u0003\u0005\u0003\u0002*\u0005]RBAA\u0016\u0015\u0011\ti#a\f\u0002\u000bE,XM]=\u000b\t\u0005E\u00121G\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u00026\u0005!\u0011m[6b\u0013\u0011\tI$a\u000b\u0003\r=3gm]3u\u0003-A\u0017M\u001c3mK\u00163XM\u001c;\u0015\t\u0005}\u00121\u000b\t\u0007\u0003\u0003\n9%a\u0013\u000e\u0005\u0005\r#bAA#S\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005%\u00131\t\u0002\u0007\rV$XO]3\u0011\t\u00055\u0013qJ\u0007\u0003\u0003gIA!!\u0015\u00024\t!Ai\u001c8f\u0011\u001d\t)F\u0006a\u0001\u0003/\n\u0001\"\u001a8wK2|\u0007/\u001a\t\u0005\u00033\nY&\u0004\u0002\u0002\u001a%!\u0011QLA\r\u0005Iiu\u000eZ3m\u000bZ,g\u000e^#om\u0016dw\u000e]3\u0002\r\r|W.\\5u)\u0019\ty$a\u0019\u0002f!9\u0011QK\fA\u0002\u0005]\u0003bBA4/\u0001\u0007\u0011\u0011N\u0001\u0011iJ\fgn]1di&|g.\u0012<f]R\u0004B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0003fm\u0016tGOC\u0002\u0002t\u0005\n!\"Y2u_Jlw\u000eZ3m\u0013\u0011\t9(!\u001c\u0003\u0017\r{W.\\5u\u000bZ,g\u000e^\u0001\u0012G>lW.\u001b;DCN,'+Z2pe\u0012\u001cHCBA \u0003{\ny\bC\u0004\u0002Va\u0001\r!a\u0016\t\u000f\u0005\u0005\u0005\u00041\u0001\u0002\u0004\u0006a1-Y:f\u001b>$\u0017NZ5fIB!\u0011QQAI\u001b\t\t9I\u0003\u0003\u0002p\u0005%%\u0002BAF\u0003\u001b\u000b\u0001\"Y2u_J\f\u0007/\u001b\u0006\u0004\u0003\u001f\u000b\u0013\u0001B2n[:LA!a%\u0002\b\na1)Y:f\u001b>$\u0017NZ5fI\u0006iQ\u000f\u001d3bi\u0016,6/\u001a:JIN$b!a\u0010\u0002\u001a\u0006\u0005\u0006bBA83\u0001\u0007\u00111\u0014\t\u0005\u0003\u000b\u000bi*\u0003\u0003\u0002 \u0006\u001d%!G\"bg\u0016\f\u0005\u000f\u001d7jK\u0012\u0004F.\u0019;g_JlW\u000b\u001d3bi\u0016Dq!!\u0016\u001a\u0001\u0004\t9\u0006")
public class CaseEventBatch
implements QueryDBEventBatch,
LazyLogging {
    private String tenant;
    private final CaseEventSink sink;
    private final String persistenceId;
    private final QueryDBStorage storage;
    private final String caseInstanceId;
    private final CaseStorageTransaction dBTransaction;
    private final CaseTeamProjection caseTeamProjection;
    private final CaseFileProjection caseFileProjection;
    private final CasePlanProjection casePlanProjection;
    private final CaseProjection caseProjection;
    private transient Logger logger;
    private ListBuffer<ModelEventEnvelope> events;
    private CommitEvent commitEvent;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Future<Done> consume() {
        return QueryDBEventBatch.consume$(this);
    }

    @Override
    public void addEvent(ModelEventEnvelope envelope) {
        EventBatch.addEvent$(this, envelope);
    }

    private Logger logger$lzycompute() {
        CaseEventBatch caseEventBatch = this;
        synchronized (caseEventBatch) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public ListBuffer<ModelEventEnvelope> events() {
        return this.events;
    }

    private CommitEvent commitEvent$lzycompute() {
        CaseEventBatch caseEventBatch = this;
        synchronized (caseEventBatch) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.commitEvent = EventBatch.commitEvent$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commitEvent;
    }

    @Override
    public CommitEvent commitEvent() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.commitEvent$lzycompute() : this.commitEvent;
    }

    @Override
    public void org$cafienne$infrastructure$cqrs$batch$EventBatch$_setter_$events_$eq(ListBuffer<ModelEventEnvelope> x$1) {
        this.events = x$1;
    }

    public CaseEventSink sink() {
        return this.sink;
    }

    @Override
    public String persistenceId() {
        return this.persistenceId;
    }

    public QueryDBStorage storage() {
        return this.storage;
    }

    public String caseInstanceId() {
        return this.caseInstanceId;
    }

    private String tenant$lzycompute() {
        CaseEventBatch caseEventBatch = this;
        synchronized (caseEventBatch) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tenant = ((ModelEventEnvelope)this.events().head()).event().tenant();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tenant;
    }

    public String tenant() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tenant$lzycompute() : this.tenant;
    }

    public CaseStorageTransaction dBTransaction() {
        return this.dBTransaction;
    }

    private CaseTeamProjection caseTeamProjection() {
        return this.caseTeamProjection;
    }

    private CaseFileProjection caseFileProjection() {
        return this.caseFileProjection;
    }

    private CasePlanProjection casePlanProjection() {
        return this.casePlanProjection;
    }

    private CaseProjection caseProjection() {
        return this.caseProjection;
    }

    public OffsetRecord createOffsetRecord(Offset offset) {
        return OffsetRecord$.MODULE$.apply(CaseEventSink$.MODULE$.offsetName(), offset);
    }

    @Override
    public Future<Done> handleEvent(ModelEventEnvelope envelope) {
        Future<Done> future;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Handling event of type " + envelope.event().getClass().getSimpleName() + " in case " + this.caseInstanceId());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ModelEvent modelEvent = envelope.event();
        if (modelEvent instanceof CasePlanEvent) {
            CasePlanEvent casePlanEvent = (CasePlanEvent)modelEvent;
            future = this.casePlanProjection().handleCasePlanEvent(casePlanEvent);
        } else if (modelEvent instanceof CaseFileEvent) {
            CaseFileEvent caseFileEvent = (CaseFileEvent)modelEvent;
            future = this.caseFileProjection().handleCaseFileEvent(caseFileEvent);
        } else if (modelEvent instanceof CaseTeamEvent) {
            CaseTeamEvent caseTeamEvent = (CaseTeamEvent)modelEvent;
            future = this.caseTeamProjection().handleCaseTeamEvent(caseTeamEvent);
        } else if (modelEvent instanceof CaseEvent) {
            CaseEvent caseEvent = (CaseEvent)modelEvent;
            future = this.caseProjection().handleCaseEvent(caseEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    @Override
    public Future<Done> commit(ModelEventEnvelope envelope, CommitEvent transactionEvent) {
        Future future;
        CommitEvent commitEvent = transactionEvent;
        if (commitEvent instanceof CaseModified) {
            CaseModified caseModified = (CaseModified)commitEvent;
            future = this.commitCaseRecords(envelope, caseModified);
        } else if (commitEvent instanceof CaseAppliedPlatformUpdate) {
            CaseAppliedPlatformUpdate caseAppliedPlatformUpdate = (CaseAppliedPlatformUpdate)commitEvent;
            future = this.updateUserIds(caseAppliedPlatformUpdate, envelope);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("CaseTransaction unexpectedly receives a commit event of type {}. This event is ignored.", (Object)transactionEvent.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> commitCaseRecords(ModelEventEnvelope envelope, CaseModified caseModified) {
        this.caseProjection().prepareCommit();
        this.caseTeamProjection().prepareCommit();
        this.caseFileProjection().prepareCommit();
        this.casePlanProjection().prepareCommit(caseModified);
        this.dBTransaction().upsert(this.createOffsetRecord(envelope.offset()));
        return this.dBTransaction().commit().andThen((PartialFunction)new Serializable(null, caseModified){
            private static final long serialVersionUID = 0L;
            private final CaseModified caseModified$1;

            public final <A1 extends Try<Done>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                A1 A1 = x$1;
                CaseReader$.MODULE$.lastModifiedRegistration().handle(this.caseModified$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Try<Done> x$1) {
                Try<Done> try_ = x$1;
                boolean bl = true;
                return bl;
            }
            {
                this.caseModified$1 = caseModified$1;
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Done> updateUserIds(CaseAppliedPlatformUpdate event, ModelEventEnvelope envelope) {
        return this.dBTransaction().updateCaseUserInformation(event.getCaseInstanceId(), event.newUserInformation.info(), this.createOffsetRecord(envelope.offset()));
    }

    public CaseEventBatch(CaseEventSink sink, String persistenceId, QueryDBStorage storage) {
        this.sink = sink;
        this.persistenceId = persistenceId;
        this.storage = storage;
        EventBatch.$init$(this);
        QueryDBEventBatch.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.caseInstanceId = persistenceId;
        this.dBTransaction = storage.createCaseTransaction(persistenceId);
        this.caseTeamProjection = new CaseTeamProjection(this, ExecutionContext.Implicits$.MODULE$.global());
        this.caseFileProjection = new CaseFileProjection(this, ExecutionContext.Implicits$.MODULE$.global());
        this.casePlanProjection = new CasePlanProjection(this, ExecutionContext.Implicits$.MODULE$.global());
        this.caseProjection = new CaseProjection(this, this.caseFileProjection(), ExecutionContext.Implicits$.MODULE$.global());
        Statics.releaseFence();
    }
}

