/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.plan;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemMigrated;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.actorapi.event.plan.RepetitionRuleEvaluated;
import org.cafienne.cmmn.actorapi.event.plan.RequiredRuleEvaluated;
import org.cafienne.humantask.actorapi.event.HumanTaskActivated;
import org.cafienne.humantask.actorapi.event.HumanTaskAssigned;
import org.cafienne.humantask.actorapi.event.HumanTaskCompleted;
import org.cafienne.humantask.actorapi.event.HumanTaskCreated;
import org.cafienne.humantask.actorapi.event.HumanTaskDueDateFilled;
import org.cafienne.humantask.actorapi.event.HumanTaskEvent;
import org.cafienne.humantask.actorapi.event.HumanTaskInputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOutputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOwnerChanged;
import org.cafienne.humantask.actorapi.event.HumanTaskTerminated;
import org.cafienne.humantask.actorapi.event.HumanTaskTransitioned;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskDropped;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskMigrated;
import org.cafienne.querydb.materializer.cases.CaseEventBatch;
import org.cafienne.querydb.materializer.cases.CaseEventMaterializer;
import org.cafienne.querydb.materializer.cases.CaseStorageTransaction;
import org.cafienne.querydb.materializer.cases.plan.PlanItemHistoryMerger$;
import org.cafienne.querydb.materializer.cases.plan.PlanItemMerger$;
import org.cafienne.querydb.materializer.cases.plan.TaskMerger$;
import org.cafienne.querydb.record.PlanItemHistoryRecord;
import org.cafienne.querydb.record.PlanItemRecord;
import org.cafienne.querydb.record.TaskRecord;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u000b\u0016\u0001\tB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0005\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001BC\u0002\u0013\ra\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003@\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001di\u0005A1A\u0005\n9Ca\u0001\u001b\u0001!\u0002\u0013y\u0005bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B6\t\u000fI\u0004!\u0019!C\u0005g\"1\u0001\u0010\u0001Q\u0001\nQDQ!\u001f\u0001\u0005\u0002iDq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\t\t\n\u0001C\u0001\u0003'\u0013!cQ1tKBc\u0017M\u001c)s_*,7\r^5p]*\u0011acF\u0001\u0005a2\fgN\u0003\u0002\u00193\u0005)1-Y:fg*\u0011!dG\u0001\r[\u0006$XM]5bY&TXM\u001d\u0006\u00039u\tq!];fef$'M\u0003\u0002\u001f?\u0005A1-\u00194jK:tWMC\u0001!\u0003\ry'oZ\u0002\u0001'\u0011\u00011%K\u0017\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQ3&D\u0001\u0018\u0013\tasCA\u000bDCN,WI^3oi6\u000bG/\u001a:jC2L'0\u001a:\u0011\u00059*T\"A\u0018\u000b\u0005A\n\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001a4\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001b\u0002\u0007\r|W.\u0003\u00027_\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0015\u0011\u0017\r^2i+\u0005I\u0004C\u0001\u0016;\u0013\tYtC\u0001\bDCN,WI^3oi\n\u000bGo\u00195\u0002\r\t\fGo\u00195!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011U%\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001R!\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u00051A(\u001b8jiz\"\"\u0001\u0013'\u0015\u0005%[\u0005C\u0001&\u0001\u001b\u0005)\u0002\"B\u001f\u0006\u0001\by\u0004\"B\u001c\u0006\u0001\u0004I\u0014!\u00039mC:LE/Z7t+\u0005y\u0005\u0003\u0002)V/\nl\u0011!\u0015\u0006\u0003%N\u000bq!\\;uC\ndWM\u0003\u0002UK\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u000b&a\u0002%bg\"l\u0015\r\u001d\t\u00031~s!!W/\u0011\u0005i+S\"A.\u000b\u0005q\u000b\u0013A\u0002\u001fs_>$h(\u0003\u0002_K\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tqV\u0005\u0005\u0002dM6\tAM\u0003\u0002f7\u00051!/Z2pe\u0012L!a\u001a3\u0003\u001dAc\u0017M\\%uK6\u0014VmY8sI\u0006Q\u0001\u000f\\1o\u0013R,Wn\u001d\u0011\u0002!Ad\u0017M\\%uK6\u001c\b*[:u_JLX#A6\u0011\u0007Acg.\u0003\u0002n#\n1!)\u001e4gKJ\u0004\"aY8\n\u0005A$'!\u0006)mC:LE/Z7ISN$xN]=SK\u000e|'\u000fZ\u0001\u0012a2\fg.\u0013;f[ND\u0015n\u001d;pef\u0004\u0013!\u0002;bg.\u001cX#\u0001;\u0011\tA+v+\u001e\t\u0003GZL!a\u001e3\u0003\u0015Q\u000b7o\u001b*fG>\u0014H-\u0001\u0004uCN\\7\u000fI\u0001\u0014Q\u0006tG\r\\3DCN,\u0007\u000b\\1o\u000bZ,g\u000e\u001e\u000b\u0004w\u0006%\u0001c\u0001!}}&\u0011Q0\u0011\u0002\u0007\rV$XO]3\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0011\u00111A\u0001\u0005C.\\\u0017-\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0002#p]\u0016Dq!a\u0003\r\u0001\u0004\ti!A\u0003fm\u0016tG\u000f\r\u0003\u0002\u0010\u0005\u001d\u0002CBA\t\u0003?\t\u0019#\u0004\u0002\u0002\u0014)\u0019a#!\u0006\u000b\t\u0005-\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0005bGR|'/\u00199j\u0015\r\ti\"H\u0001\u0005G6lg.\u0003\u0003\u0002\"\u0005M!!D\"bg\u0016\u0004F.\u00198Fm\u0016tG\u000f\u0005\u0003\u0002&\u0005\u001dB\u0002\u0001\u0003\r\u0003S\tI!!A\u0001\u0002\u000b\u0005\u00111\u0006\u0002\u0004?\u0012\n\u0014\u0003BA\u0017\u0003g\u00012\u0001JA\u0018\u0013\r\t\t$\n\u0002\b\u001d>$\b.\u001b8h!\r!\u0013QG\u0005\u0004\u0003o)#aA!os\u0006\u0019\u0002.\u00198eY\u0016\u0004F.\u00198Ji\u0016lWI^3oiR\u001910!\u0010\t\u000f\u0005-Q\u00021\u0001\u0002@A!\u0011\u0011CA!\u0013\u0011\t\u0019%a\u0005\u0003\u001bAc\u0017M\\%uK6,e/\u001a8u\u0003-9W\r\u001e)mC:LE/Z7\u0015\t\u0005%\u0013\u0011\u000b\t\u0005\u0001r\fY\u0005\u0005\u0003%\u0003\u001b\u0012\u0017bAA(K\t1q\n\u001d;j_:Da!a\u0015\u000f\u0001\u00049\u0016A\u00039mC:LE/Z7JI\u0006Q1M]3bi\u0016$\u0016m]6\u0015\u0007m\fI\u0006C\u0004\u0002\\=\u0001\r!!\u0018\u0002\u0007\u00154H\u000f\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\tY!a\u0019\u000b\t\u0005e\u0011Q\r\u0006\u0004\u0003Oj\u0012!\u00035v[\u0006tG/Y:l\u0013\u0011\tY'!\u0019\u0003%!+X.\u00198UCN\\\u0017i\u0019;jm\u0006$X\rZ\u0001\u0015I\u0016\u0004(/Z2bi\u0016$7I]3bi\u0016$\u0016m]6\u0015\u0007m\f\t\bC\u0004\u0002\\A\u0001\r!a\u001d\u0011\t\u0005}\u0013QO\u0005\u0005\u0003o\n\tG\u0001\tIk6\fg\u000eV1tW\u000e\u0013X-\u0019;fI\u0006!\u0002.\u00198eY\u0016DU/\\1o)\u0006\u001c8.\u0012<f]R$2a_A?\u0011\u001d\tY!\u0005a\u0001\u0003\u007f\u0002B!a\u0018\u0002\u0002&!\u00111QA1\u00059AU/\\1o)\u0006\u001c8.\u0012<f]R\f\u0011BZ3uG\"$\u0016m]6\u0015\t\u0005%\u0015Q\u0012\t\u0005\u0001r\fY\t\u0005\u0003%\u0003\u001b*\bBBAH%\u0001\u0007q+\u0001\u0004uCN\\\u0017\nZ\u0001\u000eaJ,\u0007/\u0019:f\u0007>lW.\u001b;\u0015\t\u0005U\u00151\u0014\t\u0004I\u0005]\u0015bAAMK\t!QK\\5u\u0011\u001d\tij\u0005a\u0001\u0003?\u000bAbY1tK6{G-\u001b4jK\u0012\u0004B!!)\u0002$6\u0011\u0011QC\u0005\u0005\u0003K\u000b)B\u0001\u0007DCN,Wj\u001c3jM&,G\r")
public class CasePlanProjection
implements CaseEventMaterializer,
LazyLogging {
    private final CaseEventBatch batch;
    private final ExecutionContext executionContext;
    private final HashMap<String, PlanItemRecord> planItems;
    private final Buffer<PlanItemHistoryRecord> planItemsHistory;
    private final HashMap<String, TaskRecord> tasks;
    private transient Logger logger;
    private String caseInstanceId;
    private CaseStorageTransaction dBTransaction;
    private String tenant;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String caseInstanceId$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.caseInstanceId = CaseEventMaterializer.caseInstanceId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.caseInstanceId;
    }

    @Override
    public String caseInstanceId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.caseInstanceId$lzycompute() : this.caseInstanceId;
    }

    private CaseStorageTransaction dBTransaction$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dBTransaction = CaseEventMaterializer.dBTransaction$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dBTransaction;
    }

    @Override
    public CaseStorageTransaction dBTransaction() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dBTransaction$lzycompute() : this.dBTransaction;
    }

    private String tenant$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tenant = CaseEventMaterializer.tenant$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.tenant;
    }

    @Override
    public String tenant() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tenant$lzycompute() : this.tenant;
    }

    @Override
    public CaseEventBatch batch() {
        return this.batch;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private HashMap<String, PlanItemRecord> planItems() {
        return this.planItems;
    }

    private Buffer<PlanItemHistoryRecord> planItemsHistory() {
        return this.planItemsHistory;
    }

    private HashMap<String, TaskRecord> tasks() {
        return this.tasks;
    }

    public Future<Done> handleCasePlanEvent(CasePlanEvent<?> event) {
        Future<Done> future;
        CasePlanEvent<?> casePlanEvent = event;
        if (casePlanEvent instanceof PlanItemEvent) {
            PlanItemEvent planItemEvent = (PlanItemEvent)casePlanEvent;
            future = this.handlePlanItemEvent(planItemEvent);
        } else if (casePlanEvent instanceof HumanTaskCreated) {
            HumanTaskCreated humanTaskCreated = (HumanTaskCreated)casePlanEvent;
            future = this.deprecatedCreateTask(humanTaskCreated);
        } else if (casePlanEvent instanceof HumanTaskActivated) {
            HumanTaskActivated humanTaskActivated = (HumanTaskActivated)casePlanEvent;
            future = this.createTask(humanTaskActivated);
        } else if (casePlanEvent instanceof HumanTaskEvent) {
            HumanTaskEvent humanTaskEvent = (HumanTaskEvent)casePlanEvent;
            future = this.handleHumanTaskEvent(humanTaskEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> handlePlanItemEvent(PlanItemEvent event) {
        Future future;
        PlanItemEvent planItemEvent = event;
        if (planItemEvent instanceof PlanItemDropped) {
            PlanItemDropped planItemDropped = (PlanItemDropped)planItemEvent;
            this.dBTransaction().deletePlanItemRecordAndHistory(planItemDropped.getPlanItemId());
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        } else {
            Future future2;
            PlanItemHistoryMerger$.MODULE$.mapEventToHistory(event).foreach((Function1 & Serializable)item -> (Buffer)this.planItemsHistory().$plus$eq(item));
            PlanItemEvent planItemEvent2 = event;
            if (planItemEvent2 instanceof PlanItemCreated) {
                PlanItemCreated planItemCreated = (PlanItemCreated)planItemEvent2;
                PlanItemRecord planItem = PlanItemMerger$.MODULE$.merge(planItemCreated);
                this.planItems().put((Object)planItem.id(), (Object)planItem);
                future2 = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else if (planItemEvent2 != null) {
                PlanItemEvent planItemEvent3 = planItemEvent2;
                future2 = this.getPlanItem(event.getPlanItemId()).map((Function1 & Serializable)x0$1 -> {
                    Done$ done$;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Option option2;
                        Some some = (Some)option;
                        PlanItemRecord planItem = (PlanItemRecord)some.value();
                        PlanItemEvent planItemEvent = planItemEvent3;
                        if (planItemEvent instanceof PlanItemTransitioned) {
                            PlanItemTransitioned planItemTransitioned = (PlanItemTransitioned)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemTransitioned, planItem));
                        } else if (planItemEvent instanceof RepetitionRuleEvaluated) {
                            RepetitionRuleEvaluated repetitionRuleEvaluated = (RepetitionRuleEvaluated)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(repetitionRuleEvaluated, planItem));
                        } else if (planItemEvent instanceof RequiredRuleEvaluated) {
                            RequiredRuleEvaluated requiredRuleEvaluated = (RequiredRuleEvaluated)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(requiredRuleEvaluated, planItem));
                        } else if (planItemEvent instanceof PlanItemMigrated) {
                            PlanItemMigrated planItemMigrated = (PlanItemMigrated)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemMigrated, planItem));
                        } else {
                            option2 = BoxedUnit.UNIT;
                        }
                        done$ = Done$.MODULE$;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Expected PlanItem " + event.getPlanItemId() + " in " + event.getCaseInstanceId() + ", but not found in the database on event type " + event.getClass().getSimpleName());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        done$ = Done$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return done$;
                }, this.executionContext());
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Apparently we have a new type of PlanItemEvent that is not being handled by this Projection. The type is " + planItemEvent2.getClass().getName());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future2 = Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            future = future2;
        }
        return future;
    }

    private Future<Option<PlanItemRecord>> getPlanItem(String planItemId) {
        Future future;
        Option option = this.planItems().get((Object)planItemId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            PlanItemRecord item = (PlanItemRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Found plan item {} in current transaction cache", (Object)planItemId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)new Some((Object)item));
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving plan item {} from database", (Object)planItemId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.dBTransaction().getPlanItem(planItemId);
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<Done> createTask(HumanTaskActivated evt) {
        TaskRecord taskRecord;
        Option option = this.tasks().get((Object)evt.taskId);
        if (None$.MODULE$.equals(option)) {
            taskRecord = TaskMerger$.MODULE$.create(evt);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            taskRecord = TaskMerger$.MODULE$.apply(evt, task);
        } else {
            throw new MatchError((Object)option);
        }
        TaskRecord updatedTask = taskRecord;
        this.tasks().put((Object)evt.taskId, (Object)updatedTask);
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> deprecatedCreateTask(HumanTaskCreated evt) {
        this.tasks().put((Object)evt.taskId, (Object)TaskMerger$.MODULE$.create(evt));
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleHumanTaskEvent(HumanTaskEvent event) {
        Future future;
        HumanTaskEvent humanTaskEvent = event;
        if (humanTaskEvent instanceof HumanTaskDropped) {
            HumanTaskDropped humanTaskDropped = (HumanTaskDropped)humanTaskEvent;
            this.dBTransaction().deleteTaskRecord(humanTaskDropped.taskId);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        HumanTaskEvent humanTaskEvent2 = event;
        if (humanTaskEvent2 instanceof HumanTaskInputSaved) {
            HumanTaskInputSaved humanTaskInputSaved = (HumanTaskInputSaved)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskInputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskOutputSaved) {
            HumanTaskOutputSaved humanTaskOutputSaved = (HumanTaskOutputSaved)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOutputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskOwnerChanged) {
            HumanTaskOwnerChanged humanTaskOwnerChanged = (HumanTaskOwnerChanged)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOwnerChanged, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskDueDateFilled) {
            HumanTaskDueDateFilled humanTaskDueDateFilled = (HumanTaskDueDateFilled)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskDueDateFilled, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskTransitioned) {
            HumanTaskTransitioned humanTaskTransitioned = (HumanTaskTransitioned)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)task -> task.map((Function1 & Serializable)t -> {
                TaskRecord taskRecord;
                TaskRecord copy = TaskMerger$.MODULE$.apply(humanTaskTransitioned, (TaskRecord)t);
                HumanTaskTransitioned humanTaskTransitioned = humanTaskTransitioned;
                if (humanTaskTransitioned instanceof HumanTaskAssigned) {
                    HumanTaskAssigned humanTaskAssigned = (HumanTaskAssigned)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskAssigned, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskActivated) {
                    HumanTaskActivated humanTaskActivated = (HumanTaskActivated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskActivated, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskCompleted) {
                    HumanTaskCompleted humanTaskCompleted = (HumanTaskCompleted)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskCompleted, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskTerminated) {
                    HumanTaskTerminated humanTaskTerminated = (HumanTaskTerminated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskTerminated, copy);
                } else {
                    taskRecord = copy;
                }
                return taskRecord;
            }), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskMigrated) {
            HumanTaskMigrated humanTaskMigrated = (HumanTaskMigrated)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskMigrated, (TaskRecord)task)), this.executionContext());
        } else {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        Future fTask = future;
        return fTask.map((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskRecord task = (TaskRecord)some.value();
                boxedUnit = this.tasks().put((Object)task.id(), (Object)task);
            } else {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Could not find task '{}' with id {} in the current database. This may lead to problems. Ignoring event of type {}", new Object[]{event.getTaskName(), event$2.taskId, event.getClass().getName()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            }
            return boxedUnit;
        }, this.executionContext()).flatMap((Function1 & Serializable)x$1 -> Future$.MODULE$.successful((Object)Done$.MODULE$), this.executionContext());
    }

    private Future<Option<TaskRecord>> fetchTask(String taskId) {
        Future future;
        Option option = this.tasks().get((Object)taskId);
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving task " + taskId + " from database");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.dBTransaction().getTask(taskId);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            future = Future$.MODULE$.successful((Object)new Some((Object)task));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public void prepareCommit(CaseModified caseModified) {
        ((IterableOnceOps)this.planItems().values().map((Function1 & Serializable)item -> PlanItemMerger$.MODULE$.merge(caseModified, (PlanItemRecord)item))).foreach((Function1 & Serializable)item -> {
            CasePlanProjection.$anonfun$prepareCommit$2(this, item);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.planItemsHistory().map((Function1 & Serializable)item -> PlanItemHistoryMerger$.MODULE$.merge(caseModified, (PlanItemHistoryRecord)item))).foreach((Function1 & Serializable)item -> {
            CasePlanProjection.$anonfun$prepareCommit$4(this, item);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.tasks().values().map((Function1 & Serializable)current -> TaskMerger$.MODULE$.apply(caseModified, (TaskRecord)current))).foreach((Function1 & Serializable)item -> {
            CasePlanProjection.$anonfun$prepareCommit$6(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$2(CasePlanProjection $this, PlanItemRecord item) {
        $this.dBTransaction().upsert(item);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$4(CasePlanProjection $this, PlanItemHistoryRecord item) {
        $this.dBTransaction().upsert(item);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$6(CasePlanProjection $this, TaskRecord item) {
        $this.dBTransaction().upsert(item);
    }

    public CasePlanProjection(CaseEventBatch batch, ExecutionContext executionContext) {
        this.batch = batch;
        this.executionContext = executionContext;
        CaseEventMaterializer.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.planItems = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.planItemsHistory = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tasks = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

