/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.team;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamGroup;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamUser;
import org.cafienne.cmmn.actorapi.command.team.GroupRoleMapping;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberEvent;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberRemoved;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupAdded;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupChanged;
import org.cafienne.cmmn.instance.team.MemberType;
import org.cafienne.querydb.materializer.cases.CaseStorageTransaction;
import org.cafienne.querydb.materializer.cases.team.CaseTeamMemberKey;
import org.cafienne.querydb.record.CaseTeamGroupRecord;
import org.cafienne.querydb.record.CaseTeamTenantRoleRecord;
import org.cafienne.querydb.record.CaseTeamUserRecord;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011)\u0019!C\u0002w!A!\t\u0001B\u0001B\u0003%A\bC\u0003D\u0001\u0011\u0005A\tC\u0004K\u0001\t\u0007I\u0011B&\t\ri\u0003\u0001\u0015!\u0003M\u0011\u001dY\u0006A1A\u0005\n-Ca\u0001\u0018\u0001!\u0002\u0013a\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B0\t\u000f\u0011\u0004!\u0019!C\u0005=\"1Q\r\u0001Q\u0001\n}CqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004m\u0001\u0001\u0006I\u0001\u001b\u0005\b[\u0002\u0011\r\u0011\"\u0003h\u0011\u0019q\u0007\u0001)A\u0005Q\"9q\u000e\u0001b\u0001\n\u0013\u0001\bBB<\u0001A\u0003%\u0011\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\tA2)Y:f)\u0016\fW.T3nE\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8\u000b\u0005aI\u0012\u0001\u0002;fC6T!AG\u000e\u0002\u000b\r\f7/Z:\u000b\u0005qi\u0012\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0010 \u0003\u001d\tX/\u001a:zI\nT!\u0001I\u0011\u0002\u0011\r\fg-[3o]\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-g5\tQF\u0003\u0002/_\u0005a1oY1mC2|wmZ5oO*\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001N\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u000eI\n#&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005]BT\"A\r\n\u0005eJ\"AF\"bg\u0016\u001cFo\u001c:bO\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}:\u0013AC2p]\u000e,(O]3oi&\u0011\u0011I\u0010\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q\u0011Q)\u0013\u000b\u0003\r\"\u0003\"a\u0012\u0001\u000e\u0003]AQA\u000f\u0003A\u0004qBQ!\u000e\u0003A\u0002Y\nAC\\3x\u0007\u0006\u001cX\rV3b[V\u001bXM\u001d*pY\u0016\u001cX#\u0001'\u0011\u00075\u0013F+D\u0001O\u0015\ty\u0005+A\u0004nkR\f'\r\\3\u000b\u0005E;\u0013AC2pY2,7\r^5p]&\u00111K\u0014\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA+Y\u001b\u00051&BA,\u001e\u0003\u0019\u0011XmY8sI&\u0011\u0011L\u0016\u0002\u0013\u0007\u0006\u001cX\rV3b[V\u001bXM\u001d*fG>\u0014H-A\u000boK^\u001c\u0015m]3UK\u0006lWk]3s%>dWm\u001d\u0011\u00021I,Wn\u001c<fI\u000e\u000b7/\u001a+fC6,6/\u001a:S_2,7/A\rsK6|g/\u001a3DCN,G+Z1n+N,'OU8mKN\u0004\u0013A\u00078fo\u000e\u000b7/\u001a+fC6$VM\\1oiJ{G.\u001a*pY\u0016\u001cX#A0\u0011\u00075\u0013\u0006\r\u0005\u0002VC&\u0011!M\u0016\u0002\u0019\u0007\u0006\u001cX\rV3b[R+g.\u00198u%>dWMU3d_J$\u0017a\u00078fo\u000e\u000b7/\u001a+fC6$VM\\1oiJ{G.\u001a*pY\u0016\u001c\b%\u0001\u0010sK6|g/\u001a3DCN,G+Z1n)\u0016t\u0017M\u001c;S_2,'k\u001c7fg\u0006y\"/Z7pm\u0016$7)Y:f)\u0016\fW\u000eV3oC:$(k\u001c7f%>dWm\u001d\u0011\u000219,woQ1tKR+\u0017-\\$s_V\u0004X*\u00199qS:<7/F\u0001i!\ri%+\u001b\t\u0003+*L!a\u001b,\u0003'\r\u000b7/\u001a+fC6<%o\\;q%\u0016\u001cwN\u001d3\u000239,woQ1tKR+\u0017-\\$s_V\u0004X*\u00199qS:<7\u000fI\u0001\u0015e\u0016lwN^3e\u000fJ|W\u000f]'baBLgnZ:\u0002+I,Wn\u001c<fI\u001e\u0013x.\u001e9NCB\u0004\u0018N\\4tA\u0005qA-\u001a7fi\u0016$W*Z7cKJ\u001cX#A9\u0011\u00075\u0013H/\u0003\u0002t\u001d\n\u00191+\u001a;\u0011\u0005\u001d+\u0018B\u0001<\u0018\u0005E\u0019\u0015m]3UK\u0006lW*Z7cKJ\\U-_\u0001\u0010I\u0016dW\r^3e\u001b\u0016l'-\u001a:tA\u0005Y\u0001.\u00198eY\u0016,e/\u001a8u)\tQX\u0010\u0005\u0002'w&\u0011Ap\n\u0002\u0005+:LG\u000fC\u0003\u007f'\u0001\u0007q0A\u0003fm\u0016tG\u000f\r\u0003\u0002\u0002\u0005e\u0001CBA\u0002\u0003#\t)\"\u0004\u0002\u0002\u0006)\u0019\u0001$a\u0002\u000b\u0007y\fIA\u0003\u0003\u0002\f\u00055\u0011\u0001C1di>\u0014\u0018\r]5\u000b\u0007\u0005=q$\u0001\u0003d[6t\u0017\u0002BA\n\u0003\u000b\u00111cQ1tKR+\u0017-\\'f[\n,'/\u0012<f]R\u0004B!a\u0006\u0002\u001a1\u0001AaCA\u000e{\u0006\u0005\t\u0011!B\u0001\u0003;\u00111a\u0018\u00132#\u0011\ty\"!\n\u0011\u0007\u0019\n\t#C\u0002\u0002$\u001d\u0012qAT8uQ&tw\rE\u0002'\u0003OI1!!\u000b(\u0005\r\te._\u0001\u0011Q\u0006tG\r\\3He>,\b/\u0012<f]R$2A_A\u0018\u0011\u0019qH\u00031\u0001\u00022A\"\u00111GA\u001c!\u0019\t\u0019!!\u0005\u00026A!\u0011qCA\u001c\t1\tI$a\f\u0002\u0002\u0003\u0005)\u0011AA\u000f\u0005\ryFeM\u0001\u000eaJ,\u0007/\u0019:f\u0007>lW.\u001b;\u0015\u0003i\u0004")
public class CaseTeamMemberProjection
implements LazyLogging {
    private final CaseStorageTransaction dBTransaction;
    private final ExecutionContext executionContext;
    private final ListBuffer<CaseTeamUserRecord> newCaseTeamUserRoles;
    private final ListBuffer<CaseTeamUserRecord> removedCaseTeamUserRoles;
    private final ListBuffer<CaseTeamTenantRoleRecord> newCaseTeamTenantRoleRoles;
    private final ListBuffer<CaseTeamTenantRoleRecord> removedCaseTeamTenantRoleRoles;
    private final ListBuffer<CaseTeamGroupRecord> newCaseTeamGroupMappings;
    private final ListBuffer<CaseTeamGroupRecord> removedGroupMappings;
    private final Set<CaseTeamMemberKey> deletedMembers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseTeamMemberProjection caseTeamMemberProjection = this;
        synchronized (caseTeamMemberProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private ListBuffer<CaseTeamUserRecord> newCaseTeamUserRoles() {
        return this.newCaseTeamUserRoles;
    }

    private ListBuffer<CaseTeamUserRecord> removedCaseTeamUserRoles() {
        return this.removedCaseTeamUserRoles;
    }

    private ListBuffer<CaseTeamTenantRoleRecord> newCaseTeamTenantRoleRoles() {
        return this.newCaseTeamTenantRoleRoles;
    }

    private ListBuffer<CaseTeamTenantRoleRecord> removedCaseTeamTenantRoleRoles() {
        return this.removedCaseTeamTenantRoleRoles;
    }

    private ListBuffer<CaseTeamGroupRecord> newCaseTeamGroupMappings() {
        return this.newCaseTeamGroupMappings;
    }

    private ListBuffer<CaseTeamGroupRecord> removedGroupMappings() {
        return this.removedGroupMappings;
    }

    private Set<CaseTeamMemberKey> deletedMembers() {
        return this.deletedMembers;
    }

    public void handleEvent(CaseTeamMemberEvent<?> event) {
        Object member = event.member;
        if (event instanceof CaseTeamMemberRemoved) {
            this.deletedMembers().$plus$eq((Object)new CaseTeamMemberKey(event.getActorId(), member.memberId(), member.memberType()));
        } else if (event.member instanceof CaseTeamGroup) {
            this.handleGroupEvent(event);
        } else {
            String caseInstanceId = event.getActorId();
            String memberId = member.memberId();
            boolean isOwner = member.isOwner();
            scala.collection.immutable.Set caseRoles = (scala.collection.immutable.Set)member.caseRoles().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})));
            scala.collection.immutable.Set<String> removedRoles = member.rolesRemoved();
            MemberType memberType = member.memberType();
            if (((Object)((Object)MemberType.User)).equals((Object)memberType)) {
                String origin = ((CaseTeamUser)member).origin().toString();
                this.newCaseTeamUserRoles().addAll((IterableOnce)caseRoles.map((Function1 & Serializable)caseRole -> new CaseTeamUserRecord(caseInstanceId, event$1.tenant, memberId, origin, (String)caseRole, isOwner)));
                this.removedCaseTeamUserRoles().addAll((IterableOnce)removedRoles.map((Function1 & Serializable)caseRole -> new CaseTeamUserRecord(caseInstanceId, event$1.tenant, memberId, origin, (String)caseRole, isOwner)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)MemberType.TenantRole)).equals((Object)memberType)) {
                this.newCaseTeamTenantRoleRoles().addAll((IterableOnce)caseRoles.map((Function1 & Serializable)caseRole -> {
                    String x$1 = caseInstanceId;
                    String x$2 = memberId;
                    String x$3 = event$1.tenant;
                    String x$4 = caseRole;
                    boolean x$5 = isOwner;
                    return new CaseTeamTenantRoleRecord(x$1, x$3, x$2, x$4, x$5);
                }));
                this.removedCaseTeamTenantRoleRoles().addAll((IterableOnce)removedRoles.map((Function1 & Serializable)caseRole -> {
                    String x$6 = caseInstanceId;
                    String x$7 = memberId;
                    String x$8 = event$1.tenant;
                    String x$9 = caseRole;
                    boolean x$10 = isOwner;
                    return new CaseTeamTenantRoleRecord(x$6, x$8, x$7, x$9, x$10);
                }));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void handleGroupEvent(CaseTeamMemberEvent<?> event) {
        CaseTeamGroup group = (CaseTeamGroup)event.member;
        CaseTeamMemberEvent<?> caseTeamMemberEvent = event;
        if (caseTeamMemberEvent instanceof CaseTeamGroupAdded) {
            this.newCaseTeamGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecords$1(mapping, event, group)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (caseTeamMemberEvent instanceof CaseTeamGroupChanged) {
            this.newCaseTeamGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecords$1(mapping, event, group)));
            this.removedGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> (scala.collection.immutable.Set)mapping.rolesRemoved().map((Function1 & Serializable)x$2 -> CaseTeamMemberProjection.asRecord$1(mapping, x$2, event, group))));
            this.removedGroupMappings().addAll((IterableOnce)group.removedMappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecords$1(mapping, event, group)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void prepareCommit() {
        this.removedCaseTeamUserRoles().foreach((Function1 & Serializable)roleRemoved -> {
            this.dBTransaction.delete(roleRemoved);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamUserRoles().foreach((Function1 & Serializable)roleUpdate -> {
            this.dBTransaction.upsert(roleUpdate);
            return BoxedUnit.UNIT;
        });
        this.removedCaseTeamTenantRoleRoles().foreach((Function1 & Serializable)roleRemoval -> {
            this.dBTransaction.delete(roleRemoval);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamTenantRoleRoles().foreach((Function1 & Serializable)roleUpdate -> {
            this.dBTransaction.upsert(roleUpdate);
            return BoxedUnit.UNIT;
        });
        this.removedGroupMappings().foreach((Function1 & Serializable)groupMapping -> {
            this.dBTransaction.delete(groupMapping);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamGroupMappings().foreach((Function1 & Serializable)groupMapping -> {
            this.dBTransaction.upsert(groupMapping);
            return BoxedUnit.UNIT;
        });
        this.deletedMembers().foreach((Function1 & Serializable)key -> {
            this.dBTransaction.deleteCaseTeamMember(key);
            return BoxedUnit.UNIT;
        });
    }

    private static final scala.collection.immutable.Set asRecords$1(GroupRoleMapping mapping, CaseTeamMemberEvent event$2, CaseTeamGroup group$1) {
        return (scala.collection.immutable.Set)mapping.caseRoles().map((Function1 & Serializable)x$1 -> CaseTeamMemberProjection.asRecord$1(mapping, x$1, event$2, group$1));
    }

    private static final CaseTeamGroupRecord asRecord$1(GroupRoleMapping mapping, String caseRole, CaseTeamMemberEvent event$2, CaseTeamGroup group$1) {
        String x$1 = event$2.getActorId();
        String x$2 = event$2.tenant;
        String x$3 = group$1.groupId();
        String x$4 = caseRole;
        String x$5 = mapping.groupRole();
        boolean x$6 = mapping.isOwner();
        return new CaseTeamGroupRecord(x$1, x$2, x$3, x$5, x$4, x$6);
    }

    public CaseTeamMemberProjection(CaseStorageTransaction dBTransaction, ExecutionContext executionContext) {
        this.dBTransaction = dBTransaction;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.newCaseTeamUserRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedCaseTeamUserRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newCaseTeamTenantRoleRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedCaseTeamTenantRoleRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newCaseTeamGroupMappings = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedGroupMappings = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deletedMembers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

