/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.tenant;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.querydb.materializer.tenant.TenantEventBatch;
import org.cafienne.querydb.materializer.tenant.TenantEventMaterializer;
import org.cafienne.querydb.materializer.tenant.TenantStorageTransaction;
import org.cafienne.querydb.record.UserRoleKey;
import org.cafienne.querydb.record.UserRoleKey$;
import org.cafienne.querydb.record.UserRoleRecord;
import org.cafienne.tenant.actorapi.event.deprecated.DeprecatedTenantUserEvent;
import org.cafienne.tenant.actorapi.event.deprecated.OwnerAdded;
import org.cafienne.tenant.actorapi.event.deprecated.OwnerRemoved;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserCreated;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserDisabled;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserEnabled;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserRoleAdded;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserRoleRemoved;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserUpdated;
import org.cafienne.tenant.actorapi.event.user.TenantMemberEvent;
import org.cafienne.tenant.actorapi.event.user.TenantUserAdded;
import org.cafienne.tenant.actorapi.event.user.TenantUserChanged;
import org.cafienne.tenant.actorapi.event.user.TenantUserRemoved;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\n\u0015\u0001}A\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013\r1\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u001dI\u0005A1A\u0005\n)Ca\u0001\u0018\u0001!\u0002\u0013Y\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B0\t\u000f\r\u0004!\u0019!C\u0005=\"1A\r\u0001Q\u0001\n}Cq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004s\u0001\u0001\u0006Ia\u001a\u0005\u0006g\u0002!\t\u0001\u001e\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002P\u0001!\t!!\u0015\u0003)Q+g.\u00198u+N,'\u000f\u0015:pU\u0016\u001cG/[8o\u0015\t)b#\u0001\u0004uK:\fg\u000e\u001e\u0006\u0003/a\tA\"\\1uKJL\u0017\r\\5{KJT!!\u0007\u000e\u0002\u000fE,XM]=eE*\u00111\u0004H\u0001\tG\u00064\u0017.\u001a8oK*\tQ$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001A\u0019R\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\tA#\u0003\u0002*)\t9B+\u001a8b]R,e/\u001a8u\u001b\u0006$XM]5bY&TXM\u001d\t\u0003WIj\u0011\u0001\f\u0006\u0003[9\nAb]2bY\u0006dwnZ4j]\u001eT!a\f\u0019\u0002\u0011QL\b/Z:bM\u0016T\u0011!M\u0001\u0004G>l\u0017BA\u001a-\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u000b\t\fGo\u00195\u0016\u0003Y\u0002\"aJ\u001c\n\u0005a\"\"\u0001\u0005+f]\u0006tG/\u0012<f]R\u0014\u0015\r^2i\u0003\u0019\u0011\u0017\r^2iA\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011qHI\u0001\u000bG>t7-\u001e:sK:$\u0018BA!?\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\na\u0001P5oSRtDCA#I)\t1u\t\u0005\u0002(\u0001!)!(\u0002a\u0002y!)A'\u0002a\u0001m\u0005QB-\u001a9sK\u000e\fG/\u001a3Vg\u0016\u0014XI^3oiJ+7m\u001c:egV\t1\n\u0005\u0003M#NKV\"A'\u000b\u00059{\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003!\n\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011VJA\u0004ICNDW*\u00199\u0011\u0005Q;V\"A+\u000b\u0005YC\u0012A\u0002:fG>\u0014H-\u0003\u0002Y+\nYQk]3s%>dWmS3z!\t!&,\u0003\u0002\\+\nqQk]3s%>dWMU3d_J$\u0017a\u00073faJ,7-\u0019;fIV\u001bXM]#wK:$(+Z2pe\u0012\u001c\b%\u0001\bvg\u0016\u0014(k\u001c7fg\u0006#G-\u001a3\u0016\u0003}\u00032\u0001\u00141Z\u0013\t\tWJ\u0001\u0006MSN$()\u001e4gKJ\fq\"^:feJ{G.Z:BI\u0012,G\rI\u0001\u0011kN,'OU8mKN\u0014V-\\8wK\u0012\f\u0011#^:feJ{G.Z:SK6|g/\u001a3!\u00031)8/\u001a:t%\u0016lwN^3e+\u00059\u0007c\u0001'iU&\u0011\u0011.\u0014\u0002\u0004'\u0016$\bCA6q\u001b\u0005a'BA7o\u0003!IG-\u001a8uSRL(BA8\u001b\u0003)\t7\r^8s[>$W\r\\\u0005\u0003c2\u0014!\u0002V3oC:$Xk]3s\u00035)8/\u001a:t%\u0016lwN^3eA\u0005I\u0002.\u00198eY\u0016$U\r\u001d:fG\u0006$X\rZ+tKJ,e/\u001a8u)\t)h\u0010E\u0002>mbL!a\u001e \u0003\r\u0019+H/\u001e:f!\tIH0D\u0001{\u0015\u0005Y\u0018\u0001B1lW\u0006L!! >\u0003\t\u0011{g.\u001a\u0005\u0007\u007f:\u0001\r!!\u0001\u0002\u000b\u00154XM\u001c;\u0011\t\u0005\r\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005QA-\u001a9sK\u000e\fG/\u001a3\u000b\u0007}\fYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001C1di>\u0014\u0018\r]5\u000b\u0005UQ\u0012\u0002BA\n\u0003\u000b\u0011\u0011\u0004R3qe\u0016\u001c\u0017\r^3e)\u0016t\u0017M\u001c;Vg\u0016\u0014XI^3oi\u0006\tr-\u001a;Vg\u0016\u0014(k\u001c7f%\u0016\u001cwN\u001d3\u0015\t\u0005e\u00111\u0004\t\u0004{YL\u0006BBA\u000f\u001f\u0001\u00071+A\u0002lKf\fq\u0002[1oI2,Wk]3s\u000bZ,g\u000e\u001e\u000b\u0004k\u0006\r\u0002BB@\u0011\u0001\u0004\t)\u0003\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\u0011\tY#!\u0003\u0002\tU\u001cXM]\u0005\u0005\u0003_\tICA\tUK:\fg\u000e^'f[\n,'/\u0012<f]R\fq\"\u00194gK\u000e$X\rZ+tKJLEm]\u000b\u0003\u0003k\u0001b!a\u000e\u0002F\u0005%c\u0002BA\u001d\u0003\u0003\u00022!a\u000f#\u001b\t\tiDC\u0002\u0002@y\ta\u0001\u0010:p_Rt\u0014bAA\"E\u00051\u0001K]3eK\u001aL1![A$\u0015\r\t\u0019E\t\t\u0005\u0003o\tY%\u0003\u0003\u0002N\u0005\u001d#AB*ue&tw-A\u0007qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e\u000b\u0003\u0003'\u00022!IA+\u0013\r\t9F\t\u0002\u0005+:LG\u000f")
public class TenantUserProjection
implements TenantEventMaterializer,
LazyLogging {
    private final TenantEventBatch batch;
    private final ExecutionContext executionContext;
    private final HashMap<UserRoleKey, UserRoleRecord> deprecatedUserEventRecords;
    private final ListBuffer<UserRoleRecord> userRolesAdded;
    private final ListBuffer<UserRoleRecord> userRolesRemoved;
    private final Set<TenantUser> usersRemoved;
    private transient Logger logger;
    private String tenant;
    private TenantStorageTransaction dBTransaction;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        TenantUserProjection tenantUserProjection = this;
        synchronized (tenantUserProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String tenant$lzycompute() {
        TenantUserProjection tenantUserProjection = this;
        synchronized (tenantUserProjection) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tenant = TenantEventMaterializer.tenant$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tenant;
    }

    @Override
    public String tenant() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tenant$lzycompute() : this.tenant;
    }

    private TenantStorageTransaction dBTransaction$lzycompute() {
        TenantUserProjection tenantUserProjection = this;
        synchronized (tenantUserProjection) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dBTransaction = TenantEventMaterializer.dBTransaction$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dBTransaction;
    }

    @Override
    public TenantStorageTransaction dBTransaction() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dBTransaction$lzycompute() : this.dBTransaction;
    }

    @Override
    public TenantEventBatch batch() {
        return this.batch;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private HashMap<UserRoleKey, UserRoleRecord> deprecatedUserEventRecords() {
        return this.deprecatedUserEventRecords;
    }

    private ListBuffer<UserRoleRecord> userRolesAdded() {
        return this.userRolesAdded;
    }

    private ListBuffer<UserRoleRecord> userRolesRemoved() {
        return this.userRolesRemoved;
    }

    private Set<TenantUser> usersRemoved() {
        return this.usersRemoved;
    }

    public Future<Done> handleDeprecatedUserEvent(DeprecatedTenantUserEvent event) {
        UserRoleKey key = UserRoleKey$.MODULE$.apply(event);
        return this.getUserRoleRecord(key).map((Function1 & Serializable)user -> {
            BoxedUnit boxedUnit;
            DeprecatedTenantUserEvent deprecatedTenantUserEvent = event;
            if (deprecatedTenantUserEvent instanceof TenantUserCreated) {
                TenantUserCreated tenantUserCreated = (TenantUserCreated)deprecatedTenantUserEvent;
                String x$1 = tenantUserCreated.name;
                String x$2 = tenantUserCreated.email;
                boolean x$3 = true;
                String x$4 = user.copy$default$1();
                String x$5 = user.copy$default$2();
                String x$6 = user.copy$default$3();
                boolean x$7 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$4, x$5, x$6, x$1, x$2, x$7, true));
            } else if (deprecatedTenantUserEvent instanceof TenantUserUpdated) {
                TenantUserUpdated tenantUserUpdated = (TenantUserUpdated)deprecatedTenantUserEvent;
                String x$8 = tenantUserUpdated.name;
                String x$9 = tenantUserUpdated.email;
                boolean x$10 = true;
                String x$11 = user.copy$default$1();
                String x$12 = user.copy$default$2();
                String x$13 = user.copy$default$3();
                boolean x$14 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$11, x$12, x$13, x$8, x$9, x$14, true));
            } else if (deprecatedTenantUserEvent instanceof TenantUserRoleAdded) {
                boolean x$15 = true;
                String x$16 = user.copy$default$1();
                String x$17 = user.copy$default$2();
                String x$18 = user.copy$default$3();
                String x$19 = user.copy$default$4();
                String x$20 = user.copy$default$5();
                boolean x$21 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$16, x$17, x$18, x$19, x$20, x$21, true));
            } else if (deprecatedTenantUserEvent instanceof TenantUserRoleRemoved) {
                boolean x$22 = false;
                String x$23 = user.copy$default$1();
                String x$24 = user.copy$default$2();
                String x$25 = user.copy$default$3();
                String x$26 = user.copy$default$4();
                String x$27 = user.copy$default$5();
                boolean x$28 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$23, x$24, x$25, x$26, x$27, x$28, false));
            } else if (deprecatedTenantUserEvent instanceof OwnerAdded) {
                boolean x$29 = true;
                String x$30 = user.copy$default$1();
                String x$31 = user.copy$default$2();
                String x$32 = user.copy$default$3();
                String x$33 = user.copy$default$4();
                String x$34 = user.copy$default$5();
                boolean x$35 = user.copy$default$7();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$30, x$31, x$32, x$33, x$34, true, x$35));
            } else if (deprecatedTenantUserEvent instanceof OwnerRemoved) {
                boolean x$36 = false;
                String x$37 = user.copy$default$1();
                String x$38 = user.copy$default$2();
                String x$39 = user.copy$default$3();
                String x$40 = user.copy$default$4();
                String x$41 = user.copy$default$5();
                boolean x$42 = user.copy$default$7();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$37, x$38, x$39, x$40, x$41, false, x$42));
            } else if (deprecatedTenantUserEvent instanceof TenantUserDisabled) {
                boolean x$43 = false;
                String x$44 = user.copy$default$1();
                String x$45 = user.copy$default$2();
                String x$46 = user.copy$default$3();
                String x$47 = user.copy$default$4();
                String x$48 = user.copy$default$5();
                boolean x$49 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$44, x$45, x$46, x$47, x$48, x$49, false));
            } else if (deprecatedTenantUserEvent instanceof TenantUserEnabled) {
                boolean x$50 = true;
                String x$51 = user.copy$default$1();
                String x$52 = user.copy$default$2();
                String x$53 = user.copy$default$3();
                String x$54 = user.copy$default$4();
                String x$55 = user.copy$default$5();
                boolean x$56 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$51, x$52, x$53, x$54, x$55, x$56, true));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Done$.MODULE$;
        }, this.executionContext());
    }

    private Future<UserRoleRecord> getUserRoleRecord(UserRoleKey key) {
        Future future;
        Option option = this.deprecatedUserEventRecords().get((Object)key);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserRoleRecord value = (UserRoleRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieved user_role[{}] from current transaction cache", (Object)key);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieving user_role[{}] from database", (Object)key);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.dBTransaction().getUserRole(key).map((Function1 & Serializable)x0$1 -> {
                UserRoleRecord userRoleRecord;
                Option option = x0$1;
                if (option instanceof Some) {
                    UserRoleRecord value;
                    Some some = (Some)option;
                    userRoleRecord = value = (UserRoleRecord)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    userRoleRecord = new UserRoleRecord(key.userId(), key.tenant(), key.role_name(), "", "", false, true);
                } else {
                    throw new MatchError((Object)option);
                }
                return userRoleRecord;
            }, this.executionContext());
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public Future<Done> handleUserEvent(TenantMemberEvent event) {
        Growable growable;
        TenantUser user = event.member;
        TenantMemberEvent tenantMemberEvent = event;
        if (tenantMemberEvent instanceof TenantUserRemoved) {
            growable = this.usersRemoved().$plus$eq((Object)user);
        } else {
            this.userRolesAdded().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), "", user.name(), user.email(), user.isOwner(), user.enabled()));
            TenantMemberEvent tenantMemberEvent2 = tenantMemberEvent;
            if (tenantMemberEvent2 instanceof TenantUserAdded) {
                user.roles().foreach((Function1 & Serializable)role -> (ListBuffer)this.userRolesAdded().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), (String)role, "", "", false, true)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (tenantMemberEvent2 instanceof TenantUserChanged) {
                TenantUserChanged tenantUserChanged = (TenantUserChanged)tenantMemberEvent2;
                user.roles().foreach((Function1 & Serializable)role -> (ListBuffer)this.userRolesAdded().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), (String)role, "", "", false, true)));
                tenantUserChanged.rolesRemoved.forEach(role -> this.userRolesRemoved().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), (String)role, "", "", false, true)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            growable = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public scala.collection.immutable.Set<String> affectedUserIds() {
        return (scala.collection.immutable.Set)((IterableOnceOps)((IterableOps)((IterableOps)this.deprecatedUserEventRecords().values().$plus$plus(this.userRolesAdded())).$plus$plus(this.userRolesRemoved())).map((Function1 & Serializable)x$1 -> x$1.userId())).toSet().$plus$plus((IterableOnce)this.usersRemoved().map((Function1 & Serializable)x$2 -> x$2.id()));
    }

    public void prepareCommit() {
        this.deprecatedUserEventRecords().values().foreach((Function1 & Serializable)instance -> {
            TenantUserProjection.$anonfun$prepareCommit$1(this, instance);
            return BoxedUnit.UNIT;
        });
        this.userRolesAdded().foreach((Function1 & Serializable)record -> {
            TenantUserProjection.$anonfun$prepareCommit$2(this, record);
            return BoxedUnit.UNIT;
        });
        this.userRolesRemoved().foreach((Function1 & Serializable)record -> {
            TenantUserProjection.$anonfun$prepareCommit$3(this, record);
            return BoxedUnit.UNIT;
        });
        this.usersRemoved().foreach((Function1 & Serializable)user -> {
            TenantUserProjection.$anonfun$prepareCommit$4(this, user);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$1(TenantUserProjection $this, UserRoleRecord instance) {
        $this.dBTransaction().upsert(instance);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$2(TenantUserProjection $this, UserRoleRecord record) {
        $this.dBTransaction().upsert(record);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$3(TenantUserProjection $this, UserRoleRecord record) {
        $this.dBTransaction().delete(record);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$4(TenantUserProjection $this, TenantUser user) {
        $this.dBTransaction().deleteTenantUser(user);
    }

    public TenantUserProjection(TenantEventBatch batch, ExecutionContext executionContext) {
        this.batch = batch;
        this.executionContext = executionContext;
        TenantEventMaterializer.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.deprecatedUserEventRecords = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.userRolesAdded = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.userRolesRemoved = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.usersRemoved = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

