/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.infrastructure.jdbc.CafienneJDBCConfig;
import org.cafienne.infrastructure.jdbc.query.Area;
import org.cafienne.infrastructure.jdbc.query.Sort;
import org.cafienne.querydb.query.BaseQueryImpl;
import org.cafienne.querydb.query.BaseQueryImpl$FieldFilter$;
import org.cafienne.querydb.query.BaseQueryImpl$JoinedNotFilter$;
import org.cafienne.querydb.query.BaseQueryImpl$NoFilter$;
import org.cafienne.querydb.query.BaseQueryImpl$NotFieldFilter$;
import org.cafienne.querydb.query.BaseQueryImpl$NotValueFilter$;
import org.cafienne.querydb.query.BaseQueryImpl$OrFilter$;
import org.cafienne.querydb.query.BaseQueryImpl$ValueFilter$;
import org.cafienne.querydb.query.CaseMembership;
import org.cafienne.querydb.query.TaskCount;
import org.cafienne.querydb.query.TaskQueries;
import org.cafienne.querydb.query.exception.CaseSearchFailure;
import org.cafienne.querydb.query.exception.TaskSearchFailure;
import org.cafienne.querydb.query.exception.TaskSearchFailure$;
import org.cafienne.querydb.query.filter.TaskFilter;
import org.cafienne.querydb.record.CaseRecord;
import org.cafienne.querydb.record.TaskRecord;
import org.cafienne.querydb.schema.QueryDBSchema;
import org.cafienne.querydb.schema.table.CaseTables;
import org.cafienne.querydb.schema.table.ConsentGroupTables;
import org.cafienne.querydb.schema.table.TaskTables;
import org.cafienne.querydb.schema.table.TenantTables;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.ast.TypedType$;
import slick.basic.DatabaseConfig;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionColumnExtensionMethods;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.lifted.TableQuery$;
import slick.lifted.Tag;
import slick.migration.api.Dialect;
import slick.migration.api.MigrationSeq;
import slick.sql.SqlAction;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\t\u0012\u0001iAQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u0004@\u0001\u0001\u0006I!\f\u0005\u0006\u0001\u0002!\t%\u0011\u0005\u0006E\u0002!\te\u0019\u0005\u0006[\u0002!\tE\u001c\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\ti\r\u0001C\u0005\u0003\u001f\u0014q\u0002V1tWF+XM]5fg&k\u0007\u000f\u001c\u0006\u0003%M\tQ!];fefT!\u0001F\u000b\u0002\u000fE,XM]=eE*\u0011acF\u0001\tG\u00064\u0017.\u001a8oK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00017\u0005*\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\t\u0011#\u0003\u0002%#\tYA+Y:l#V,'/[3t!\t\u0011c%\u0003\u0002(#\ti!)Y:f#V,'/_%na2\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005\t\u0002\u0011A\u0003;bg.\u001c\u0018+^3ssV\tQ\u0006E\u0002/gUj\u0011a\f\u0006\u0003aE\na\u0001\\5gi\u0016$'\"\u0001\u001a\u0002\u000bMd\u0017nY6\n\u0005Qz#A\u0003+bE2,\u0017+^3ssB\u0011agN\u0007\u0002\u0001%\u0011\u0001(\u000f\u0002\n)\u0006\u001c8\u000eV1cY\u0016L!AO\u001e\u0003\u0015Q\u000b7o\u001b+bE2,7O\u0003\u0002={\u0005)A/\u00192mK*\u0011ahE\u0001\u0007g\u000eDW-\\1\u0002\u0017Q\f7o[:Rk\u0016\u0014\u0018\u0010I\u0001\u0012O\u0016$8)Y:f\u001b\u0016l'-\u001a:tQ&\u0004Hc\u0001\"L1B\u00191I\u0012%\u000e\u0003\u0011S!!R\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002H\t\n1a)\u001e;ve\u0016\u0004\"AI%\n\u0005)\u000b\"AD\"bg\u0016lU-\u001c2feND\u0017\u000e\u001d\u0005\u0006\u0019\u0012\u0001\r!T\u0001\u0007i\u0006\u001c8.\u00133\u0011\u00059+fBA(T!\t\u0001V$D\u0001R\u0015\t\u0011\u0016$\u0001\u0004=e>|GOP\u0005\u0003)v\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A+\b\u0005\u00063\u0012\u0001\rAW\u0001\u0005kN,'\u000f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006A\u0011\u000eZ3oi&$\u0018P\u0003\u0002`+\u0005Q\u0011m\u0019;pe6|G-\u001a7\n\u0005\u0005d&\u0001D+tKJLE-\u001a8uSRL\u0018aB4fiR\u000b7o\u001b\u000b\u0004I.d\u0007cA\"GKB\u0011a-[\u0007\u0002O*\u0011\u0001nE\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005)<'A\u0003+bg.\u0014VmY8sI\")A*\u0002a\u0001\u001b\")\u0011,\u0002a\u00015\u0006!r-\u001a;UCN\\7oV5uQ\u000e\u000b7/\u001a(b[\u0016$Ra\\=|\u0003\u0003\u00012a\u0011$q!\r\th/\u001a\b\u0003eRt!\u0001U:\n\u0003yI!!^\u000f\u0002\u000fA\f7m[1hK&\u0011q\u000f\u001f\u0002\u0004'\u0016\f(BA;\u001e\u0011\u0015Qh\u00011\u0001N\u0003!\u0019\u0017m]3OC6,\u0007\"\u0002?\u0007\u0001\u0004i\u0018A\u0002;f]\u0006tG\u000fE\u0002\u001d}6K!a`\u000f\u0003\r=\u0003H/[8o\u0011\u0015If\u00011\u0001[\u000319W\r^\"bg\u0016$\u0016m]6t)\u0015y\u0017qAA\u0006\u0011\u0019\tIa\u0002a\u0001\u001b\u0006q1-Y:f\u0013:\u001cH/\u00198dK&#\u0007\"B-\b\u0001\u0004Q\u0016aC4fi\u0006cG\u000eV1tWN$\u0012b\\A\t\u0003'\t\t#a\u000e\t\u000beC\u0001\u0019\u0001.\t\u0013\u0005U\u0001\u0002%AA\u0002\u0005]\u0011A\u00024jYR,'\u000f\u0005\u0003\u0002\u001a\u0005uQBAA\u000e\u0015\r\t)\"E\u0005\u0005\u0003?\tYB\u0001\u0006UCN\\g)\u001b7uKJD\u0011\"a\t\t!\u0003\u0005\r!!\n\u0002\t\u0005\u0014X-\u0019\t\u0005\u0003O\t\u0019$\u0004\u0002\u0002*)\u0019!#a\u000b\u000b\t\u00055\u0012qF\u0001\u0005U\u0012\u00147MC\u0002\u00022U\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u0003\u00026\u0005%\"\u0001B!sK\u0006D\u0011\"!\u000f\t!\u0003\u0005\r!a\u000f\u0002\tM|'\u000f\u001e\t\u0005\u0003O\ti$\u0003\u0003\u0002@\u0005%\"\u0001B*peR\fAbZ3u'R\f'\u000f\u001e#bi\u0016$b!!\u0012\u0002X\u0005m\u0003\u0003\u0002\u000f\u007f\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0003uS6,'BAA)\u0003\u0011Q\u0017M^1\n\t\u0005U\u00131\n\u0002\b\u0013:\u001cH/\u00198u\u0011\u0019\tI&\u0003a\u0001\u001b\u0006!A-\u0019;f\u0011\u0019\ti&\u0003a\u0001{\u0006AA/[7f5>tW-A\thKR$\u0016.\\3[_:,wJ\u001a4tKR$B!a\u0019\u0002jA!\u0011\u0011JA3\u0013\u0011\t9'a\u0013\u0003\u0015i{g.Z(gMN,G\u000f\u0003\u0004\u0002^)\u0001\r!`\u0001\u000bO\u0016$XI\u001c3ECR,GCBA#\u0003_\n\t\b\u0003\u0004\u0002Z-\u0001\r!\u0014\u0005\u0007\u0003;Z\u0001\u0019A?\u0002\u001f\u001d,GoQ8v]R4uN]+tKJ$b!a\u001e\u0002\u0000\u0005\u0005\u0005\u0003B\"G\u0003s\u00022AIA>\u0013\r\ti(\u0005\u0002\n)\u0006\u001c8nQ8v]RDQ!\u0017\u0007A\u0002iCQ\u0001 \u0007A\u0002u\fAdY8og\u0016tGo\u0012:pkB\u001cu.\u001e9mK\u0012\u001c\u0015m]3S_2,7\u000f\u0006\u0003\u0002\b\u0006\u0015\u0007CCAE\u0003[\u000b),!1\u0002D:!\u00111RAR\u001d\u0011\ti)a&\u000f\u0007Y\ny)\u0003\u0003\u0002\u0012\u0006M\u0015\u0001\u00033c\u0007>tg-[4\n\u0007\u0005UUHA\u0007Rk\u0016\u0014\u0018\u0010\u0012\"TG\",W.Y\u0005\u0005\u00033\u000bY*A\u0004qe>4\u0017\u000e\\3\n\t\u0005u\u0015q\u0014\u0002\u000f\t\u0006$\u0018MY1tK\u000e{gNZ5h\u0015\r\t\t+M\u0001\u0006E\u0006\u001c\u0018nY\u0005\u0005\u0003K\u000b9+A\u0002ba&LA!!+\u0002,\nY!\n\u001a2d!J|g-\u001b7f\u0015\r\ti#M\u0005\u0005\u0003_\u000b\tLA\u0003Rk\u0016\u0014\u00180C\u0002\u00024>\u0012q!\u00117jCN,7\u000fE\u0004\u001d\u0003o\u000bY,a/\n\u0007\u0005eVD\u0001\u0004UkBdWM\r\t\u0006\u0003\u0013\u000bi,T\u0005\u0005\u0003\u007f\u000b\tLA\u0002SKB\u0004R\u0001HA\\\u001b6\u0003\"!\u001d<\t\u000bek\u0001\u0019\u0001.\u00025Q,g.\u00198u%>dWmQ8va2,GmQ1tKJ{G.Z:\u0015\t\u0005\u001d\u00151\u001a\u0005\u00063:\u0001\rAW\u0001\u0015kN,'oQ8va2,GmQ1tKJ{G.Z:\u0015\t\u0005\u001d\u0015\u0011\u001b\u0005\u00063>\u0001\rA\u0017")
public class TaskQueriesImpl
implements TaskQueries,
BaseQueryImpl {
    private final TableQuery<TaskTables.TaskTable> tasksQuery;
    private ExecutionContext ec;
    private TableQuery<CaseTables.CaseInstanceTable> caseInstanceQuery;
    private TableQuery<CaseTables.CaseInstanceDefinitionTable> caseDefinitionQuery;
    private TableQuery<CaseTables.CaseFileTable> caseFileQuery;
    private TableQuery<CaseTables.CaseBusinessIdentifierTable> caseIdentifiersQuery;
    private TableQuery<CaseTables.PlanItemTable> planItemTableQuery;
    private volatile BaseQueryImpl$NotValueFilter$ NotValueFilter$module;
    private volatile BaseQueryImpl$ValueFilter$ ValueFilter$module;
    private volatile BaseQueryImpl$NoFilter$ NoFilter$module;
    private volatile BaseQueryImpl$NotFieldFilter$ NotFieldFilter$module;
    private volatile BaseQueryImpl$FieldFilter$ FieldFilter$module;
    private volatile BaseQueryImpl$JoinedNotFilter$ JoinedNotFilter$module;
    private volatile BaseQueryImpl$OrFilter$ OrFilter$module;
    private transient Logger logger;
    private DatabaseConfig<JdbcProfile> dbConfig;
    private JdbcBackend.DatabaseDef db;
    private boolean isSQLServer;
    private Dialect<? extends JdbcProfile> dialect;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Future<CaseMembership> getCaseMembership(String caseInstanceId, UserIdentity user, Function1<String, Exception> exception, String msg) {
        return BaseQueryImpl.getCaseMembership$(this, caseInstanceId, user, exception, msg);
    }

    @Override
    public Query<CaseTables.CaseInstanceTable, CaseRecord, Seq> membershipQuery(UserIdentity user, Rep<String> caseInstanceId) {
        return BaseQueryImpl.membershipQuery$(this, user, caseInstanceId);
    }

    @Override
    public Query<CaseTables.CaseInstanceTable, CaseRecord, Seq> membershipQuery(UserIdentity user, Rep<String> caseInstanceId, Option<String> identifiers) {
        return BaseQueryImpl.membershipQuery$(this, user, caseInstanceId, identifiers);
    }

    @Override
    public <CT extends CafienneJDBCConfig.CafienneTable<?>, E> CafienneJDBCConfig.QueryHelper<CT, E> QueryHelper(Query<CT, E, Seq> query) {
        return CafienneJDBCConfig.QueryHelper$(this, query);
    }

    @Override
    public <CTT extends CafienneJDBCConfig.CafienneTenantTable<?>, E> CafienneJDBCConfig.TenantQueryHelper<CTT, E> TenantQueryHelper(Query<CTT, E, Seq> query) {
        return CafienneJDBCConfig.TenantQueryHelper$(this, query);
    }

    @Override
    public MigrationSeq asSqlMigration(SqlAction<?, ?, ?> action) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, action);
    }

    @Override
    public MigrationSeq asSqlMigration(Seq<String> sql) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, sql);
    }

    @Override
    public TaskFilter getAllTasks$default$2() {
        return TaskQueries.getAllTasks$default$2$(this);
    }

    @Override
    public Area getAllTasks$default$3() {
        return TaskQueries.getAllTasks$default$3$(this);
    }

    @Override
    public Sort getAllTasks$default$4() {
        return TaskQueries.getAllTasks$default$4$(this);
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public TableQuery<CaseTables.CaseInstanceTable> caseInstanceQuery() {
        return this.caseInstanceQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseInstanceDefinitionTable> caseDefinitionQuery() {
        return this.caseDefinitionQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseFileTable> caseFileQuery() {
        return this.caseFileQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseBusinessIdentifierTable> caseIdentifiersQuery() {
        return this.caseIdentifiersQuery;
    }

    @Override
    public TableQuery<CaseTables.PlanItemTable> planItemTableQuery() {
        return this.planItemTableQuery;
    }

    @Override
    public BaseQueryImpl$NotValueFilter$ NotValueFilter() {
        if (this.NotValueFilter$module == null) {
            this.NotValueFilter$lzycompute$1();
        }
        return this.NotValueFilter$module;
    }

    @Override
    public BaseQueryImpl$ValueFilter$ ValueFilter() {
        if (this.ValueFilter$module == null) {
            this.ValueFilter$lzycompute$1();
        }
        return this.ValueFilter$module;
    }

    @Override
    public BaseQueryImpl$NoFilter$ NoFilter() {
        if (this.NoFilter$module == null) {
            this.NoFilter$lzycompute$1();
        }
        return this.NoFilter$module;
    }

    @Override
    public BaseQueryImpl$NotFieldFilter$ NotFieldFilter() {
        if (this.NotFieldFilter$module == null) {
            this.NotFieldFilter$lzycompute$1();
        }
        return this.NotFieldFilter$module;
    }

    @Override
    public BaseQueryImpl$FieldFilter$ FieldFilter() {
        if (this.FieldFilter$module == null) {
            this.FieldFilter$lzycompute$1();
        }
        return this.FieldFilter$module;
    }

    @Override
    public BaseQueryImpl$JoinedNotFilter$ JoinedNotFilter() {
        if (this.JoinedNotFilter$module == null) {
            this.JoinedNotFilter$lzycompute$1();
        }
        return this.JoinedNotFilter$module;
    }

    @Override
    public BaseQueryImpl$OrFilter$ OrFilter() {
        if (this.OrFilter$module == null) {
            this.OrFilter$lzycompute$1();
        }
        return this.OrFilter$module;
    }

    @Override
    public void org$cafienne$querydb$query$BaseQueryImpl$_setter_$ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    @Override
    public void org$cafienne$querydb$query$BaseQueryImpl$_setter_$caseInstanceQuery_$eq(TableQuery<CaseTables.CaseInstanceTable> x$1) {
        this.caseInstanceQuery = x$1;
    }

    @Override
    public void org$cafienne$querydb$query$BaseQueryImpl$_setter_$caseDefinitionQuery_$eq(TableQuery<CaseTables.CaseInstanceDefinitionTable> x$1) {
        this.caseDefinitionQuery = x$1;
    }

    @Override
    public void org$cafienne$querydb$query$BaseQueryImpl$_setter_$caseFileQuery_$eq(TableQuery<CaseTables.CaseFileTable> x$1) {
        this.caseFileQuery = x$1;
    }

    @Override
    public void org$cafienne$querydb$query$BaseQueryImpl$_setter_$caseIdentifiersQuery_$eq(TableQuery<CaseTables.CaseBusinessIdentifierTable> x$1) {
        this.caseIdentifiersQuery = x$1;
    }

    @Override
    public void org$cafienne$querydb$query$BaseQueryImpl$_setter_$planItemTableQuery_$eq(TableQuery<CaseTables.PlanItemTable> x$1) {
        this.planItemTableQuery = x$1;
    }

    private Logger logger$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private DatabaseConfig<JdbcProfile> dbConfig$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dbConfig = QueryDBSchema.dbConfig$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dbConfig;
    }

    @Override
    public DatabaseConfig<JdbcProfile> dbConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dbConfig$lzycompute() : this.dbConfig;
    }

    private JdbcBackend.DatabaseDef db$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.db = CafienneJDBCConfig.db$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    @Override
    public JdbcBackend.DatabaseDef db() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
    }

    private boolean isSQLServer$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isSQLServer = CafienneJDBCConfig.isSQLServer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isSQLServer;
    }

    @Override
    public boolean isSQLServer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isSQLServer$lzycompute() : this.isSQLServer;
    }

    private Dialect<? extends JdbcProfile> dialect$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dialect = CafienneJDBCConfig.dialect$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dialect;
    }

    @Override
    public Dialect<? extends JdbcProfile> dialect() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dialect$lzycompute() : this.dialect;
    }

    public TableQuery<TaskTables.TaskTable> tasksQuery() {
        return this.tasksQuery;
    }

    @Override
    public Future<CaseMembership> getCaseMembership(String taskId, UserIdentity user) {
        Future result2 = this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)x$1 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$1.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)taskId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$2 -> x$2.caseInstanceId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())))).result()).map((Function1 & Serializable)records -> {
            if (records.isEmpty()) {
                throw new TaskSearchFailure(taskId);
            }
            return (String)records.head();
        }, this.ec()).flatMap((Function1 & Serializable)caseId -> this.getCaseMembership((String)caseId, user, (Function1<String, Exception>)TaskSearchFailure$.MODULE$, taskId).map((Function1 & Serializable)membership -> new Tuple2(caseId, membership), this.ec()), this.ec());
        return result2.map((Function1 & Serializable)result -> (CaseMembership)result._2(), this.ec());
    }

    @Override
    public Future<TaskRecord> getTask(String taskId, UserIdentity user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)x$3 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$3.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)taskId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId()).map((Function1 & Serializable)x$4 -> {
            CaseTables.CaseInstanceTable caseInstanceTable = x$4;
            TaskTables.TaskTable taskTable = baseQuery;
            return taskTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            TaskRecord task;
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TaskSearchFailure(taskId);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            TaskRecord taskRecord = task = (TaskRecord)some.value();
            return taskRecord;
        }, this.ec());
    }

    @Override
    public Future<Seq<TaskRecord>> getTasksWithCaseName(String caseName, Option<String> tenant, UserIdentity user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new CaseTables.CaseInstanceTable(this, (Tag)tag))).on((Function2 & Serializable)(x$5, x$6) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$5.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(x$6.id(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(((CaseTables.CaseInstanceTable)((Object)((Object)x$7._2()))).caseName(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)caseName, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(tenant, (Function2 & Serializable)(x$8, x$9) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(((CafienneJDBCConfig.CafienneTenantTable)((Object)((Object)x$8._1()))).tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$9, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)baseQuery -> this.membershipQuery(user, ((TaskTables.TaskTable)((Object)((Object)baseQuery._1()))).caseInstanceId()).map((Function1 & Serializable)x$10 -> {
            CaseTables.CaseInstanceTable caseInstanceTable = x$10;
            TaskTables.TaskTable taskTable = (TaskTables.TaskTable)((Object)((Object)((Object)baseQuery._1())));
            return taskTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query.distinct())).result());
    }

    @Override
    public Future<Seq<TaskRecord>> getCaseTasks(String caseInstanceId, UserIdentity user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)x$11 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$11.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)caseInstanceId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId()).map((Function1 & Serializable)x$12 -> {
            CaseTables.CaseInstanceTable caseInstanceTable = x$12;
            TaskTables.TaskTable taskTable = baseQuery;
            return taskTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query.distinct())).result()).map((Function1 & Serializable)records -> {
            if (records.isEmpty()) {
                throw new CaseSearchFailure(caseInstanceId);
            }
            return records;
        }, this.ec());
    }

    @Override
    public Future<Seq<TaskRecord>> getAllTasks(UserIdentity user, TaskFilter filter, Area area, Sort sort) {
        Query query;
        Option<String> option = filter.assignee();
        if (option instanceof Some) {
            Some some = (Some)option;
            String assignee = (String)some.value();
            query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)x$13 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$13.assignee(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)assignee, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        } else if (None$.MODULE$.equals(option)) {
            query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)task -> BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(this.consentGroupCoupledCaseRoles(user).filter((Function1 & Serializable)x$14 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$14._1(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$15 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$15._2(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).exists()), this.tenantRoleCoupledCaseRoles(user).filter((Function1 & Serializable)x$16 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$16._1(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$17 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$17._2(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).exists(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), this.userCoupledCaseRoles(user).filter((Function1 & Serializable)x$18 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$18._1(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$19 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$19._2(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).exists(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        } else {
            throw new MatchError(option);
        }
        Query assignmentFilterQuery = query;
        Query query2 = this.caseInstanceQuery().filterOpt(filter.caseName(), (Function2 & Serializable)(x$20, x$21) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$20.caseName(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$21, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)caseNameFilter -> assignmentFilterQuery.filter((Function1 & Serializable)x$22 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$22.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(caseNameFilter.id(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.tenant(), (Function2 & Serializable)(x$23, x$24) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$23.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$24, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.taskName(), (Function2 & Serializable)(x$25, x$26) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$25.taskName(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$26, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.taskState(), (Function2 & Serializable)(x$27, x$28) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$27.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$28, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.owner(), (Function2 & Serializable)(x$29, x$30) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$29.owner(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$30, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.dueOn(), (Function2 & Serializable)(x$31, x$32) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$31.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$greater$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getStartDate((String)x$32, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).filterOpt(filter.dueOn(), (Function2 & Serializable)(x$33, x$34) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$33.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$less$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getEndDate((String)x$34, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).filterOpt(filter.dueBefore(), (Function2 & Serializable)(x$35, x$36) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$35.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$less((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getStartDate((String)x$36, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).filterOpt(filter.dueAfter(), (Function2 & Serializable)(x$37, x$38) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$37.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$greater((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getEndDate((String)x$38, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId(), filter.identifiers()).map((Function1 & Serializable)x$39 -> {
            CaseTables.CaseInstanceTable caseInstanceTable = x$39;
            TaskTables.TaskTable taskTable = baseQuery;
            return taskTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(this.QueryHelper(this.QueryHelper(query2.distinct()).only(area)).order(sort))).result());
    }

    private Option<Instant> getStartDate(String date, Option<String> timeZone) {
        return Option$.MODULE$.apply((Object)LocalDateTime.parse(date + "T00:00:00.000000000").toInstant(this.getTimeZoneOffset(timeZone)));
    }

    private ZoneOffset getTimeZoneOffset(Option<String> timeZone) {
        ZoneOffset zoneOffset;
        Option<String> option = timeZone;
        if (option instanceof Some) {
            Some some = (Some)option;
            String offsetId = (String)some.value();
            zoneOffset = ZoneOffset.of(offsetId);
        } else if (None$.MODULE$.equals(option)) {
            zoneOffset = ZoneOffset.UTC;
        } else {
            throw new MatchError(option);
        }
        return zoneOffset;
    }

    private Option<Instant> getEndDate(String date, Option<String> timeZone) {
        return Option$.MODULE$.apply((Object)LocalDateTime.parse(date + "T23:59:59.999999999").toInstant(this.getTimeZoneOffset(timeZone)));
    }

    @Override
    public Future<TaskCount> getCountForUser(UserIdentity user, Option<String> tenant) {
        Query claimedTasksQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)x$40 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$40.assignee(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$41 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$41.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"Completed", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$42 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$42.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"Terminated", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(tenant, (Function2 & Serializable)(x$43, x$44) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$43.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$44, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Query unclaimedTasksQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable)x$45 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$45.assignee(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(tenant, (Function2 & Serializable)(x$46, x$47) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$46.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$47, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$48 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$48.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"Completed", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$49 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$49.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"Terminated", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)task -> BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(this.consentGroupCoupledCaseRoles(user).filter((Function1 & Serializable)x$50 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$50._1(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$51 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$51._2(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).exists()), this.tenantRoleCoupledCaseRoles(user).filter((Function1 & Serializable)x$52 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$52._1(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$53 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$53._2(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).exists(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), this.userCoupledCaseRoles(user).filter((Function1 & Serializable)x$54 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$54._1(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$55 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(task.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)x$55._2(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).exists(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)unclaimedTasks -> unclaimedTasks, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Future count = this.db().run((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().recordQueryActionExtensionMethods((Object)claimedTasksQuery.distinct().length(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().intColumnType()))).result()).flatMap((Function1 & Serializable)claimedTasks -> TaskQueriesImpl.$anonfun$getCountForUser$19(this, unclaimedTasksQuery, BoxesRunTime.unboxToInt((Object)claimedTasks)), this.ec());
        return count.map((Function1 & Serializable)c -> {
            void var1_1;
            TaskCount tc = new TaskCount(c._1$mcI$sp(), c._2$mcI$sp());
            return var1_1;
        }, this.ec());
    }

    private Query<Tuple2<Rep<String>, Rep<String>>, Tuple2<String, String>, Seq> consentGroupCoupledCaseRoles(UserIdentity user) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$56 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$56.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new CaseTables.CaseInstanceTeamGroupTable(this, (Tag)tag))).on((Function2 & Serializable)(x$57, x$58) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$57.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(x$58.groupRole(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$59 -> (CaseTables.CaseInstanceTeamGroupTable)((Object)((Object)x$59._2())), Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)group -> new Tuple2(group.caseInstanceId(), group.caseRole()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())));
    }

    private Query<Tuple2<Rep<String>, Rep<String>>, Tuple2<String, String>, Seq> tenantRoleCoupledCaseRoles(UserIdentity user) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$60 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$60.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new CaseTables.CaseInstanceTeamTenantRoleTable(this, (Tag)tag))).on((Function2 & Serializable)(left, right) -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(left.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(right.tenantRole(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(left.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(right.tenant(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$61 -> (CaseTables.CaseInstanceTeamTenantRoleTable)((Object)((Object)x$61._2())), Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)tenantRole -> new Tuple2(tenantRole.caseInstanceId(), tenantRole.caseRole()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())));
    }

    private Query<Tuple2<Rep<String>, Rep<String>>, Tuple2<String, String>, Seq> userCoupledCaseRoles(UserIdentity user2) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new CaseTables.CaseInstanceTeamUserTable(this, (Tag)tag)).filter((Function1 & Serializable)x$62 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$62.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user2.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)user -> new Tuple2(user.caseInstanceId(), user.caseRole()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())));
    }

    private final void NotValueFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.NotValueFilter$module == null) {
                this.NotValueFilter$module = new BaseQueryImpl$NotValueFilter$(this);
            }
        }
    }

    private final void ValueFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.ValueFilter$module == null) {
                this.ValueFilter$module = new BaseQueryImpl$ValueFilter$(this);
            }
        }
    }

    private final void NoFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.NoFilter$module == null) {
                this.NoFilter$module = new BaseQueryImpl$NoFilter$(this);
            }
        }
    }

    private final void NotFieldFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.NotFieldFilter$module == null) {
                this.NotFieldFilter$module = new BaseQueryImpl$NotFieldFilter$(this);
            }
        }
    }

    private final void FieldFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.FieldFilter$module == null) {
                this.FieldFilter$module = new BaseQueryImpl$FieldFilter$(this);
            }
        }
    }

    private final void JoinedNotFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.JoinedNotFilter$module == null) {
                this.JoinedNotFilter$module = new BaseQueryImpl$JoinedNotFilter$(this);
            }
        }
    }

    private final void OrFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.OrFilter$module == null) {
                this.OrFilter$module = new BaseQueryImpl$OrFilter$(this);
            }
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$getCountForUser$20(int claimedTasks$1, int unclaimedTasks) {
        return new Tuple2.mcII.sp(claimedTasks$1, unclaimedTasks);
    }

    public static final /* synthetic */ Future $anonfun$getCountForUser$19(TaskQueriesImpl $this, Query unclaimedTasksQuery$1, int claimedTasks) {
        return $this.db().run((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)((JdbcProfile)$this.dbConfig().profile()).api().recordQueryActionExtensionMethods((Object)unclaimedTasksQuery$1.distinct().length(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)$this.dbConfig().profile()).api().intColumnType()))).result()).map((Function1 & Serializable)unclaimedTasks -> TaskQueriesImpl.$anonfun$getCountForUser$20(claimedTasks, BoxesRunTime.unboxToInt((Object)unclaimedTasks)), $this.ec());
    }

    public TaskQueriesImpl() {
        TaskQueries.$init$(this);
        CafienneJDBCConfig.$init$(this);
        QueryDBSchema.$init$(this);
        CaseTables.$init$(this);
        TaskTables.$init$(this);
        TenantTables.$init$(this);
        ConsentGroupTables.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        BaseQueryImpl.$init$(this);
        this.tasksQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag));
        Statics.releaseFence();
    }
}

