/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.identity.ConsentGroupMembership;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.actormodel.identity.Origin;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.consentgroup.actorapi.ConsentGroup;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember$;
import org.cafienne.infrastructure.jdbc.CafienneJDBCConfig;
import org.cafienne.querydb.query.UserQueries;
import org.cafienne.querydb.query.exception.ConsentGroupMemberSearchFailure;
import org.cafienne.querydb.query.exception.ConsentGroupSearchFailure;
import org.cafienne.querydb.query.exception.TenantSearchFailure;
import org.cafienne.querydb.query.exception.TenantUserSearchFailure;
import org.cafienne.querydb.query.exception.UserSearchFailure;
import org.cafienne.querydb.record.ConsentGroupMemberRecord;
import org.cafienne.querydb.record.ConsentGroupRecord;
import org.cafienne.querydb.record.TenantRecord;
import org.cafienne.querydb.record.UserRoleRecord;
import org.cafienne.querydb.schema.QueryDBSchema;
import org.cafienne.querydb.schema.table.ConsentGroupTables;
import org.cafienne.querydb.schema.table.TenantTables;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.basic.DatabaseConfig;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BaseJoinQuery;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionLift$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.lifted.TableQuery$;
import slick.lifted.Tag;
import slick.migration.api.Dialect;
import slick.migration.api.MigrationSeq;
import slick.sql.SqlAction;

@ScalaSignature(bytes="\u0006\u0005\t5a\u0001\u0002\u000b\u0016\u0001yAQA\u0010\u0001\u0005\u0002}Bq!\u0011\u0001C\u0002\u0013\r!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u0019A\u0006\u0001)A\u0005\u0019\")\u0011\f\u0001C!5\")\u0011\u000f\u0001C!e\"9\u0011q\u0001\u0001\u0005B\u0005%\u0001bBA\f\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002j\u0001!\t%a\u001b\t\rE\u0004A\u0011IA9\u0011\u001d\t9\b\u0001C!\u0003sBq!a%\u0001\t\u0003\n)\nC\u0004\u0002 \u0002!I!!)\t\u000f\u0005-\b\u0001\"\u0011\u0002n\"9\u0011Q \u0001\u0005B\u0005}(!\u0005+f]\u0006tG/U;fe&,7/S7qY*\u0011acF\u0001\u0006cV,'/\u001f\u0006\u00031e\tq!];fef$'M\u0003\u0002\u001b7\u0005A1-\u00194jK:tWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\u0019\u0001q$J\u00154wA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0014\u000e\u0003UI!\u0001K\u000b\u0003\u0017U\u001bXM])vKJLWm\u001d\t\u0003UEj\u0011a\u000b\u0006\u0003Y5\nAb]2bY\u0006dwnZ4j]\u001eT!AL\u0018\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001M\u0001\u0004G>l\u0017B\u0001\u001a,\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014!\u0002;bE2,'B\u0001\u001d\u0018\u0003\u0019\u00198\r[3nC&\u0011!(\u000e\u0002\r)\u0016t\u0017M\u001c;UC\ndWm\u001d\t\u0003iqJ!!P\u001b\u0003%\r{gn]3oi\u001e\u0013x.\u001e9UC\ndWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0003\"A\n\u0001\u0002\u0005\u0015\u001cW#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019\u000b\u0013AC2p]\u000e,(O]3oi&\u0011\u0001*\u0012\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u0003)\u0011x\u000e\\3t#V,'/_\u000b\u0002\u0019B\u0019QJ\u0015+\u000e\u00039S!a\u0014)\u0002\r1Lg\r^3e\u0015\u0005\t\u0016!B:mS\u000e\\\u0017BA*O\u0005)!\u0016M\u00197f#V,'/\u001f\t\u0003+Zk\u0011\u0001A\u0005\u0003/f\u0012Q\"V:feJ{G.\u001a+bE2,\u0017a\u0003:pY\u0016\u001c\u0018+^3ss\u0002\n\u0011bZ3u)\u0016t\u0017M\u001c;\u0015\u0005m#\u0007c\u0001#]=&\u0011Q,\u0012\u0002\u0007\rV$XO]3\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005<\u0012A\u0002:fG>\u0014H-\u0003\u0002dA\naA+\u001a8b]R\u0014VmY8sI\")QM\u0002a\u0001M\u0006AA/\u001a8b]RLE\r\u0005\u0002h]:\u0011\u0001\u000e\u001c\t\u0003S\u0006j\u0011A\u001b\u0006\u0003Wv\ta\u0001\u0010:p_Rt\u0014BA7\"\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000e\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\f\u0013!D4fiR+g.\u00198u+N,'\u000f\u0006\u0003ty\u0006\r\u0001c\u0001#]iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\tS\u0012,g\u000e^5us*\u0011\u00110G\u0001\u000bC\u000e$xN]7pI\u0016d\u0017BA>w\u0005)!VM\\1oiV\u001bXM\u001d\u0005\u0006{\u001e\u0001\rA`\u0001\u0005kN,'\u000f\u0005\u0002v\u007f&\u0019\u0011\u0011\u0001<\u0003\u0019U\u001bXM]%eK:$\u0018\u000e^=\t\r\u0005\u0015q\u00011\u0001g\u0003\u0019!XM\\1oi\u0006yq-\u001a;QY\u0006$hm\u001c:n+N,'\u000f\u0006\u0003\u0002\f\u0005M\u0001\u0003\u0002#]\u0003\u001b\u00012!^A\b\u0013\r\t\tB\u001e\u0002\r!2\fGOZ8s[V\u001bXM\u001d\u0005\u0007\u0003+A\u0001\u0019\u00014\u0002\rU\u001cXM]%e\u0003Y!W\r^3s[&tWm\u0014:jO&twJZ+tKJ\u001cHCBA\u000e\u0003w\t\t\u0005\u0005\u0003E9\u0006u\u0001CBA\u0010\u0003S\tyC\u0004\u0003\u0002\"\u0005\u0015bbA5\u0002$%\t!%C\u0002\u0002(\u0005\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"aA*fc*\u0019\u0011qE\u0011\u0011\r\u0001\n\tDZA\u001b\u0013\r\t\u0019$\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007U\f9$C\u0002\u0002:Y\u0014aa\u0014:jO&t\u0007bBA\u001f\u0013\u0001\u0007\u0011qH\u0001\u0006kN,'o\u001d\t\u0006\u0003?\tIC\u001a\u0005\u0007\u0003\u000bI\u0001\u0019\u00014\u0002\u001d\u001d,G\u000fV3oC:$Xk]3sgR!\u0011qIA&!\u0011!E,!\u0013\u0011\u000b\u0005}\u0011\u0011\u0006;\t\u000buT\u0001\u0019\u0001;\u0002%I,\u0017\rZ!mYR+g.\u00198u+N,'o\u001d\u000b\u0005\u0003\u000f\n\t\u0006C\u0003~\u0017\u0001\u0007A/\u0001\tde\u0016\fG/\u001a+f]\u0006tG/V:feR)A/a\u0016\u0002`!1Q\u0010\u0004a\u0001\u00033\u00022aXA.\u0013\r\ti\u0006\u0019\u0002\u000f+N,'OU8mKJ+7m\u001c:e\u0011\u001d\t\t\u0007\u0004a\u0001\u0003G\nQA]8mKN\u0004BaZA3M&\u0019\u0011q\r9\u0003\u0007M+G/A\u000fhKR$\u0015n]1cY\u0016$G+\u001a8b]R,6/\u001a:BG\u000e|WO\u001c;t)\u0011\t9%!\u001c\t\r\u0005=T\u00021\u0001u\u0003)!XM\\1oiV\u001bXM\u001d\u000b\u0006g\u0006M\u0014Q\u000f\u0005\u0007\u0003_r\u0001\u0019\u0001;\t\r\u0005Ua\u00021\u0001g\u0003A9W\r^\"p]N,g\u000e^$s_V\u00048\u000f\u0006\u0003\u0002|\u0005=\u0005\u0003\u0002#]\u0003{\u0002b!a\b\u0002*\u0005}\u0004\u0003BAA\u0003\u0017k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\tC\u000e$xN]1qS*\u0019\u0011\u0011R\r\u0002\u0019\r|gn]3oi\u001e\u0014x.\u001e9\n\t\u00055\u00151\u0011\u0002\r\u0007>t7/\u001a8u\u000fJ|W\u000f\u001d\u0005\b\u0003#{\u0001\u0019AA \u0003!9'o\\;q\u0013\u0012\u001c\u0018aD4fi\u000e{gn]3oi\u001e\u0013x.\u001e9\u0015\r\u0005]\u0015\u0011TAN!\u0011!E,a \t\u000bu\u0004\u0002\u0019\u0001@\t\r\u0005u\u0005\u00031\u0001g\u0003\u001d9'o\\;q\u0013\u0012\f1dY8og\u0016tGo\u0012:pkBlU-\u001c2feND\u0017\u000e])vKJLHCBAR\u0003C\f\u0019\u000f\u0005\u0006\u0002&\u0006-\u00171[Am\u0003?tA!a*\u0002@:!\u0011\u0011VAZ\u001d\r)\u00161V\u0005\u0005\u0003[\u000by+\u0001\u0005eE\u000e{gNZ5h\u0013\r\t\tl\u000e\u0002\u000e#V,'/\u001f#C'\u000eDW-\\1\n\t\u0005U\u0016qW\u0001\baJ|g-\u001b7f\u0013\u0011\tI,a/\u0003\u001d\u0011\u000bG/\u00192bg\u0016\u001cuN\u001c4jO*\u0019\u0011Q\u0018)\u0002\u000b\t\f7/[2\n\t\u0005\u0005\u00171Y\u0001\u0004CBL\u0017\u0002BAc\u0003\u000f\u00141B\u00133cGB\u0013xNZ5mK*\u0019\u0011\u0011\u001a)\u0002\t)$'mY\u0005\u0005\u0003\u001b\fyMA\u0003Rk\u0016\u0014\u00180C\u0002\u0002R:\u0013q!\u00117jCN,7\u000fE\u0002V\u0003+L1!a6=\u0005]\u0019uN\\:f]R<%o\\;q\u001b\u0016l'-\u001a:UC\ndW\rE\u0002`\u00037L1!!8a\u0005a\u0019uN\\:f]R<%o\\;q\u001b\u0016l'-\u001a:SK\u000e|'\u000f\u001a\t\u0005\u0003?\tI\u0003C\u0003~#\u0001\u0007a\u0010C\u0004\u0002\u001eF\u0001\r!!:\u0011\u000b\u0005\u0015\u0016q\u001d4\n\t\u0005%\u0018q\u001a\u0002\u0004%\u0016\u0004\u0018!F4fi\u000e{gn]3oi\u001e\u0013x.\u001e9NK6\u0014WM\u001d\u000b\t\u0003_\f90!?\u0002|B!A\tXAy!\u0011\t\t)a=\n\t\u0005U\u00181\u0011\u0002\u0013\u0007>t7/\u001a8u\u000fJ|W\u000f]'f[\n,'\u000fC\u0003~%\u0001\u0007a\u0010\u0003\u0004\u0002\u001eJ\u0001\rA\u001a\u0005\u0007\u0003+\u0011\u0002\u0019\u00014\u0002'\u001d,GoQ8og\u0016tGo\u0012:pkB,6/\u001a:\u0015\r\t\u0005!\u0011\u0002B\u0006!\u0011!ELa\u0001\u0011\u0007U\u0014)!C\u0002\u0003\bY\u0014\u0001cQ8og\u0016tGo\u0012:pkB,6/\u001a:\t\u000bu\u001c\u0002\u0019\u0001@\t\r\u0005u5\u00031\u0001g\u0001")
public class TenantQueriesImpl
implements UserQueries,
LazyLogging,
TenantTables,
ConsentGroupTables {
    private final ExecutionContext ec;
    private final TableQuery<TenantTables.UserRoleTable> rolesQuery;
    private DatabaseConfig<JdbcProfile> dbConfig;
    private JdbcBackend.DatabaseDef db;
    private boolean isSQLServer;
    private Dialect<? extends JdbcProfile> dialect;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public <CT extends CafienneJDBCConfig.CafienneTable<?>, E> CafienneJDBCConfig.QueryHelper<CT, E> QueryHelper(Query<CT, E, Seq> query) {
        return CafienneJDBCConfig.QueryHelper$(this, query);
    }

    @Override
    public <CTT extends CafienneJDBCConfig.CafienneTenantTable<?>, E> CafienneJDBCConfig.TenantQueryHelper<CTT, E> TenantQueryHelper(Query<CTT, E, Seq> query) {
        return CafienneJDBCConfig.TenantQueryHelper$(this, query);
    }

    @Override
    public MigrationSeq asSqlMigration(SqlAction<?, ?, ?> action) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, action);
    }

    @Override
    public MigrationSeq asSqlMigration(Seq<String> sql) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, sql);
    }

    private DatabaseConfig<JdbcProfile> dbConfig$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dbConfig = QueryDBSchema.dbConfig$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dbConfig;
    }

    @Override
    public DatabaseConfig<JdbcProfile> dbConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dbConfig$lzycompute() : this.dbConfig;
    }

    private JdbcBackend.DatabaseDef db$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.db = CafienneJDBCConfig.db$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    @Override
    public JdbcBackend.DatabaseDef db() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
    }

    private boolean isSQLServer$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isSQLServer = CafienneJDBCConfig.isSQLServer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isSQLServer;
    }

    @Override
    public boolean isSQLServer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isSQLServer$lzycompute() : this.isSQLServer;
    }

    private Dialect<? extends JdbcProfile> dialect$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dialect = CafienneJDBCConfig.dialect$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dialect;
    }

    @Override
    public Dialect<? extends JdbcProfile> dialect() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dialect$lzycompute() : this.dialect;
    }

    private Logger logger$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public TableQuery<TenantTables.UserRoleTable> rolesQuery() {
        return this.rolesQuery;
    }

    @Override
    public Future<TenantRecord> getTenant(String tenantId) {
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.TenantTable(this, (Tag)tag)).filter((Function1 & Serializable)x$1 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$1.name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenantId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$2 -> x$2.enabled(), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            TenantRecord record;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                throw new TenantSearchFailure(tenantId);
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            TenantRecord tenantRecord = record = (TenantRecord)some.value();
            return tenantRecord;
        }, this.ec());
    }

    @Override
    public Future<TenantUser> getTenantUser(UserIdentity user, String tenant) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$3 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$3.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$4 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$4.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            UserRoleRecord userRecord = (UserRoleRecord)records.find((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$5(record))).fold((Function0 & Serializable)() -> {
                throw new TenantUserSearchFailure(tenant, user.id());
            }, (Function1 & Serializable)r -> r);
            Set roles = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$8(record)))).map((Function1 & Serializable)x$5 -> x$5.role_name())).toSet();
            return this.createTenantUser(userRecord, (Set<String>)roles);
        }, this.ec());
    }

    @Override
    public Future<PlatformUser> getPlatformUser(String userId) {
        Query tenantUsersQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$6 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$6.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$7.enabled(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Query consentGroupsQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$8 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$8.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Future dbRetrieval = this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(tenantUsersQuery)).result()).flatMap((Function1 & Serializable)tenantRecords -> this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupsQuery)).result()).map((Function1 & Serializable)groupRecords -> new Tuple2(tenantRecords, groupRecords), this.ec()), this.ec());
        return dbRetrieval.map((Function1 & Serializable)records -> {
            Seq tenantRecords = (Seq)((IterableOps)records._1()).filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$9(userId, x$9)));
            Seq groupRecords = (Seq)((IterableOps)records._2()).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$10(userId, x$10)));
            Seq tenantUsers = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOnceOps)tenantRecords.map((Function1 & Serializable)x$11 -> x$11.tenant())).toSet().map((Function1 & Serializable)tenant -> {
                Seq userRecords = (Seq)tenantRecords.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$13(tenant, x$12)));
                Set roles = ((IterableOnceOps)((IterableOps)userRecords.filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$14(x$13)))).map((Function1 & Serializable)x$14 -> x$14.role_name())).toSet();
                Option user = userRecords.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$16(x$15)));
                return user.isEmpty() ? None$.MODULE$ : new Some((Object)this.createTenantUser((UserRoleRecord)user.get(), (Set<String>)roles));
            })).filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.nonEmpty()))).map((Function1 & Serializable)x$17 -> (TenantUser)x$17.get())).toSeq();
            Seq groups = ((IterableOnceOps)((IterableOnceOps)((IterableOps)groupRecords.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$19(x$18)))).map((Function1 & Serializable)x$19 -> x$19.group())).toSet().map((Function1 & Serializable)groupId -> {
                Seq groupInfo = (Seq)groupRecords.filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$22(groupId, x$20)));
                Set roles = ((IterableOnceOps)groupInfo.map((Function1 & Serializable)x$21 -> x$21.role())).toSet();
                boolean isOwner = groupInfo.exists((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isOwner()));
                return new ConsentGroupMembership((String)groupId, (Set<String>)roles, isOwner);
            })).toSeq();
            return new PlatformUser(userId, (Seq<TenantUser>)tenantUsers, (Seq<ConsentGroupMembership>)groups);
        }, this.ec());
    }

    @Override
    public Future<Seq<Tuple2<String, Origin>>> determineOriginOfUsers(Seq<String> users, String tenant) {
        Query tenantMembership = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$23 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$23.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$24 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$24.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$25 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$25.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$26 -> x$26.userId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).distinct().take(users.length());
        Query platformRegistration = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$27 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$27.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$28 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$28.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$29 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$29.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$30 -> x$30.userId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).distinct().take(users.length());
        BaseJoinQuery query = tenantMembership.joinFull(platformRegistration, OptionLift$.MODULE$.repOptionLift(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), Shape$.MODULE$.optionShape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionLift$.MODULE$.repOptionLift(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), Shape$.MODULE$.optionShape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods((Query)query)).result()).map((Function1 & Serializable)records -> {
            Set tenantUserIds = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$determineOriginOfUsers$12(x$31)))).map((Function1 & Serializable)x$32 -> (String)((Option)x$32._1()).get())).toSet();
            Set platformUserIds = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$determineOriginOfUsers$14(x$33)))).map((Function1 & Serializable)x$34 -> (String)((Option)x$34._2()).get())).toSet();
            return (Seq)users.map((Function1 & Serializable)user -> new Tuple2(user, (Object)TenantQueriesImpl.determineOrigin$1(user, tenantUserIds, platformUserIds)));
        }, this.ec());
    }

    @Override
    public Future<Seq<TenantUser>> getTenantUsers(TenantUser user) {
        return this.readAllTenantUsers(user).map((Function1 & Serializable)p -> (Seq)p.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.enabled())), this.ec());
    }

    private Future<Seq<TenantUser>> readAllTenantUsers(TenantUser user) {
        Query users = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$35 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$35.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.tenant(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(users)).result()).map((Function1 & Serializable)records -> {
            Seq userRecords = (Seq)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$4(record)));
            Seq roleRecords = (Seq)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$5(record)));
            Seq users = (Seq)userRecords.map((Function1 & Serializable)user -> {
                Set roles = ((IterableOnceOps)((IterableOps)roleRecords.filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$7(user, role)))).map((Function1 & Serializable)x$36 -> x$36.role_name())).toSet();
                return this.createTenantUser((UserRoleRecord)user, (Set<String>)roles);
            });
            return users;
        }, this.ec());
    }

    private TenantUser createTenantUser(UserRoleRecord user, Set<String> roles) {
        return new TenantUser(user.userId(), user.tenant(), roles, user.isOwner(), user.name(), user.email(), user.enabled());
    }

    @Override
    public Future<Seq<TenantUser>> getDisabledTenantUserAccounts(TenantUser tenantUser) {
        return this.readAllTenantUsers(tenantUser).map((Function1 & Serializable)p -> (Seq)p.filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.enabled())), this.ec());
    }

    @Override
    public Future<TenantUser> getTenantUser(TenantUser tenantUser, String userId) {
        Query users = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$37 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$37.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenantUser.tenant(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$38 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$38.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(users)).result()).map((Function1 & Serializable)roleRecords -> {
            UserRoleRecord user = (UserRoleRecord)roleRecords.find((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$14(role))).getOrElse((Function0 & Serializable)() -> {
                throw new UserSearchFailure(userId);
            });
            Set roles = ((IterableOnceOps)((IterableOps)((IterableOps)roleRecords.filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)role.enabled()))).filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$17(role)))).map((Function1 & Serializable)x$39 -> x$39.role_name())).toSet();
            return this.createTenantUser(user, (Set<String>)roles);
        }, this.ec());
    }

    @Override
    public Future<Seq<ConsentGroup>> getConsentGroups(Seq<String> groupIds) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$40 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$40.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)groupIds, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag))).on((Function2 & Serializable)(x$41, x$42) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$41.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(x$42.group(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            Set groups = ((IterableOnceOps)((IterableOps)records.map((Function1 & Serializable)x$43 -> (ConsentGroupRecord)x$43._1())).map((Function1 & Serializable)g -> new Tuple2((Object)g.id(), (Object)g.tenant()))).toSet();
            Seq members = (Seq)((IterableOps)records.map((Function1 & Serializable)x$44 -> (ConsentGroupMemberRecord)x$44._2())).filter((Function1 & Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$9(x$45)));
            Seq roles = (Seq)((IterableOps)records.map((Function1 & Serializable)x$46 -> (ConsentGroupMemberRecord)x$46._2())).filterNot((Function1 & Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$11(x$47)));
            return ((IterableOnceOps)groups.map((Function1 & Serializable)group -> {
                Seq groupUsers = (Seq)members.filter((Function1 & Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$13(group, x$48)));
                Seq groupMembers = (Seq)groupUsers.map((Function1 & Serializable)member -> {
                    Seq memberRoles = (Seq)((IterableOps)((IterableOps)roles.filter((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$15(group, x$49)))).filter((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$16(member, x$50)))).map((Function1 & Serializable)x$51 -> x$51.role());
                    return new ConsentGroupMember(member.userId(), (Set<String>)memberRoles.toSet(), member.isOwner());
                });
                return new ConsentGroup((String)group._1(), (String)group._2(), (Seq<ConsentGroupMember>)groupMembers);
            })).toSeq();
        }, this.ec());
    }

    @Override
    public Future<ConsentGroup> getConsentGroup(UserIdentity user, String groupId) {
        Query consentGroupQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$52 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$52.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)groupQuery -> this.consentGroupMembershipQuery(user, groupQuery.id()).map((Function1 & Serializable)x$53 -> {
            ConsentGroupTables.ConsentGroupMemberTable consentGroupMemberTable = x$53;
            ConsentGroupTables.ConsentGroupTable consentGroupTable = groupQuery;
            return consentGroupTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        Future queries = this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupQuery)).result()).flatMap((Function1 & Serializable)group -> this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$54 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$54.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result()).map((Function1 & Serializable)members -> new Tuple2(group, members), this.ec()), this.ec());
        return queries.map((Function1 & Serializable)result -> {
            if (((SeqOps)result._1()).isEmpty()) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            ConsentGroupRecord group = (ConsentGroupRecord)((IterableOps)result._1()).head();
            String id = group.id();
            String tenant = group.tenant();
            Seq members = (Seq)result._2();
            Seq users = (Seq)members.filter((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$10(x$55)));
            Seq memberList = (Seq)users.map((Function1 & Serializable)user -> {
                Seq userRoles = (Seq)((IterableOps)((IterableOps)members.filter((Function1 & Serializable)x$56 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$12(user, x$56)))).filterNot((Function1 & Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$13(x$57)))).map((Function1 & Serializable)x$58 -> x$58.role());
                return ConsentGroupMember$.MODULE$.apply(user.userId(), (Seq<String>)userRoles, user.isOwner());
            });
            return new ConsentGroup(id, tenant, (Seq<ConsentGroupMember>)memberList);
        }, this.ec());
    }

    private Query<ConsentGroupTables.ConsentGroupMemberTable, ConsentGroupMemberRecord, Seq> consentGroupMembershipQuery(UserIdentity user, Rep<String> groupId) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$59 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$59.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(groupId, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$60 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$60.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$61 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$61.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
    }

    @Override
    public Future<ConsentGroupMember> getConsentGroupMember(UserIdentity user, String groupId, String userId) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$62 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$62.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)member -> BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            if (!records.exists((Function1 & Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$5(user, x$63)))) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            Seq groupMemberRecords = (Seq)records.filter((Function1 & Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$6(userId, x$64)));
            Seq userRecords = (Seq)groupMemberRecords.filter((Function1 & Serializable)x$65 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$7(x$65)));
            if (userRecords.isEmpty()) {
                throw new ConsentGroupMemberSearchFailure(userId);
            }
            Seq roles = (Seq)((IterableOps)groupMemberRecords.filterNot((Function1 & Serializable)x$66 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$8(x$66)))).map((Function1 & Serializable)x$67 -> x$67.role());
            return ConsentGroupMember$.MODULE$.apply(((ConsentGroupMemberRecord)userRecords.head()).userId(), (Seq<String>)roles, ((ConsentGroupMemberRecord)userRecords.head()).isOwner());
        }, this.ec());
    }

    @Override
    public Future<ConsentGroupUser> getConsentGroupUser(UserIdentity user, String groupId) {
        Query consentGroupQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$68 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$68.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)groupQuery -> this.consentGroupMembershipQuery(user, groupQuery.id()).map((Function1 & Serializable)x$69 -> {
            ConsentGroupTables.ConsentGroupMemberTable consentGroupMemberTable = x$69;
            ConsentGroupTables.ConsentGroupTable consentGroupTable = groupQuery;
            return consentGroupTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupQuery)).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ConsentGroupSearchFailure(groupId);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            ConsentGroupRecord group = (ConsentGroupRecord)some.value();
            ConsentGroupUser consentGroupUser = new ConsentGroupUser(user.id(), group.id(), group.tenant());
            return consentGroupUser;
        }, this.ec());
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$5(UserRoleRecord record) {
        return record.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$8(UserRoleRecord record) {
        return !record.role_name().isBlank() && record.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$9(String userId$1, UserRoleRecord x$9) {
        String string = x$9.userId();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$10(String userId$1, ConsentGroupMemberRecord x$10) {
        String string = x$10.userId();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$13(String tenant$2, UserRoleRecord x$12) {
        String string = x$12.tenant();
        String string2 = tenant$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$14(UserRoleRecord x$13) {
        return x$13.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$16(UserRoleRecord x$15) {
        return x$15.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$19(ConsentGroupMemberRecord x$18) {
        return x$18.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$22(String groupId$1, ConsentGroupMemberRecord x$20) {
        String string = x$20.group();
        String string2 = groupId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$determineOriginOfUsers$12(Tuple2 x$31) {
        return ((Option)x$31._1()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$determineOriginOfUsers$14(Tuple2 x$33) {
        return ((Option)x$33._2()).isDefined();
    }

    private static final Origin determineOrigin$1(String userId, Set tenantUserIds$1, Set platformUserIds$1) {
        return tenantUserIds$1.contains((Object)userId) ? Origin.Tenant : (platformUserIds$1.contains((Object)userId) ? Origin.Platform : Origin.IDP);
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$4(UserRoleRecord record) {
        return record.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$5(UserRoleRecord record) {
        return !record.role_name().isBlank() && record.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$7(UserRoleRecord user$3, UserRoleRecord role) {
        String string = role.userId();
        String string2 = user$3.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$14(UserRoleRecord role) {
        return role.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$17(UserRoleRecord role) {
        return !role.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$9(ConsentGroupMemberRecord x$45) {
        return x$45.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$11(ConsentGroupMemberRecord x$47) {
        return x$47.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$13(Tuple2 group$1, ConsentGroupMemberRecord x$48) {
        String string = x$48.group();
        Object object = group$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$15(Tuple2 group$1, ConsentGroupMemberRecord x$49) {
        String string = x$49.group();
        Object object = group$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$16(ConsentGroupMemberRecord member$1, ConsentGroupMemberRecord x$50) {
        String string = x$50.userId();
        String string2 = member$1.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$10(ConsentGroupMemberRecord x$55) {
        return x$55.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$12(ConsentGroupMemberRecord user$5, ConsentGroupMemberRecord x$56) {
        String string = x$56.userId();
        String string2 = user$5.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$13(ConsentGroupMemberRecord x$57) {
        return x$57.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$5(UserIdentity user$7, ConsentGroupMemberRecord x$63) {
        String string = x$63.userId();
        String string2 = user$7.id();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$6(String userId$3, ConsentGroupMemberRecord x$64) {
        String string = x$64.userId();
        String string2 = userId$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$7(ConsentGroupMemberRecord x$65) {
        return x$65.role().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$8(ConsentGroupMemberRecord x$66) {
        return x$66.role().isEmpty();
    }

    public TenantQueriesImpl() {
        UserQueries.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        CafienneJDBCConfig.$init$(this);
        QueryDBSchema.$init$(this);
        TenantTables.$init$(this);
        ConsentGroupTables.$init$(this);
        this.ec = this.db().ioExecutionContext();
        this.rolesQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag));
    }
}

