/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.akkahttp;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.ServerBuilder;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RouteResult$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.akkahttp.route.CaseServiceRoute;
import org.cafienne.service.akkahttp.anonymous.AnonymousRequestRoutes;
import org.cafienne.service.akkahttp.cases.route.CasesRoutes;
import org.cafienne.service.akkahttp.consentgroup.route.ConsentGroupRoutes;
import org.cafienne.service.akkahttp.debug.DebugRoute;
import org.cafienne.service.akkahttp.identifiers.route.IdentifierRoutes;
import org.cafienne.service.akkahttp.platform.CaseEngineHealthRoute;
import org.cafienne.service.akkahttp.platform.PlatformRoutes;
import org.cafienne.service.akkahttp.repository.RepositoryRoute;
import org.cafienne.service.akkahttp.swagger.SwaggerHttpServiceRoute;
import org.cafienne.service.akkahttp.tasks.TaskRoutes;
import org.cafienne.service.akkahttp.tenant.route.TenantRoutes;
import org.cafienne.system.CaseSystem;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005M4AAC\u0006\u0001)!AQ\u0005\u0001BC\u0002\u0013\u0005a\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015q\u0003\u0001\"\u00010\u0011\u001d\u0019\u0004A1A\u0005\u0002QBaA\u0013\u0001!\u0002\u0013)\u0004bB&\u0001\u0005\u0004%\t\u0001\u0014\u0005\u0007+\u0002\u0001\u000b\u0011B'\t\u000bY\u0003A\u0011A,\t\u000bu\u0003A\u0011\u00010\u0003%\r\u000bg-[3o]\u0016DE\u000f\u001e9TKJ4XM\u001d\u0006\u0003\u00195\t\u0001\"Y6lC\"$H\u000f\u001d\u0006\u0003\u001d=\tqa]3sm&\u001cWM\u0003\u0002\u0011#\u0005A1-\u00194jK:tWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005q\u0019S\"A\u000f\u000b\u0005yy\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u0011\"\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0012\u0002\u0007\r|W.\u0003\u0002%;\tYA*\u0019>z\u0019><w-\u001b8h\u0003)\u0019\u0017m]3TsN$X-\\\u000b\u0002OA\u0011\u0001fK\u0007\u0002S)\u0011!fD\u0001\u0007gf\u001cH/Z7\n\u00051J#AC\"bg\u0016\u001c\u0016p\u001d;f[\u0006Y1-Y:f'f\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001G\r\t\u0003c\u0001i\u0011a\u0003\u0005\u0006K\r\u0001\raJ\u0001\u000eI\u00164\u0017-\u001e7u%>,H/Z:\u0016\u0003U\u00022A\u000e B\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;'\u00051AH]8pizJ\u0011\u0001G\u0005\u0003{]\tq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n\u00191+Z9\u000b\u0005u:\u0002C\u0001\"I\u001b\u0005\u0019%B\u0001#F\u0003\u0015\u0011x.\u001e;f\u0015\taaI\u0003\u0002H\u001f\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017BA%D\u0005A\u0019\u0015m]3TKJ4\u0018nY3S_V$X-\u0001\beK\u001a\fW\u000f\u001c;S_V$Xm\u001d\u0011\u0002\rI|W\u000f^3t+\u0005i\u0005c\u0001(T\u00036\tqJ\u0003\u0002Q#\u00069Q.\u001e;bE2,'B\u0001*\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003)>\u0013!\u0002T5ti\n+hMZ3s\u0003\u001d\u0011x.\u001e;fg\u0002\n\u0001\"\u00193e%>,H/\u001a\u000b\u00031n\u0003\"AF-\n\u0005i;\"\u0001B+oSRDQ\u0001\u0018\u0005A\u0002\u0005\u000b\u0001cY1tKN+'O^5dKJ{W\u000f^3\u0002\u000bM$\u0018M\u001d;\u0015\u0003}\u00032\u0001Y2f\u001b\u0005\t'B\u00012\u0018\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003I\u0006\u0014aAR;ukJ,\u0007C\u00014q\u001d\t9g.D\u0001i\u0015\tI'.\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\tYG.\u0001\u0003iiR\u0004(\"A7\u0002\t\u0005\\7.Y\u0005\u0003_\"\fA\u0001\u0013;ua&\u0011\u0011O\u001d\u0002\u000e'\u0016\u0014h/\u001a:CS:$\u0017N\\4\u000b\u0005=D\u0007")
public class CafienneHttpServer
implements LazyLogging {
    private final CaseSystem caseSystem;
    private final Seq<CaseServiceRoute> defaultRoutes;
    private final ListBuffer<CaseServiceRoute> routes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CafienneHttpServer cafienneHttpServer = this;
        synchronized (cafienneHttpServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    public Seq<CaseServiceRoute> defaultRoutes() {
        return this.defaultRoutes;
    }

    public ListBuffer<CaseServiceRoute> routes() {
        return this.routes;
    }

    public void addRoute(CaseServiceRoute caseServiceRoute) {
        this.routes().$plus$eq((Object)caseServiceRoute);
    }

    public Future<Http.ServerBinding> start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Cafienne HTTP Server - loading swagger documentation of the routes");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ListBuffer apiClasses = (ListBuffer)this.routes().flatMap((Function1 & Serializable)route -> route.apiClasses());
        ObjectRef mainRoute = ObjectRef.create(new SwaggerHttpServiceRoute(apiClasses.toSet()).route());
        ((IterableOnceOps)this.routes().map((Function1 & Serializable)x$1 -> x$1.route())).foreach((Function1 & Serializable)route -> {
            CafienneHttpServer.routeAppender$1(route, mainRoute);
            return BoxedUnit.UNIT;
        });
        Function1 apiRoutes = (Function1)mainRoute.elem;
        String apiHost = Cafienne$.MODULE$.config().api().bindHost();
        int apiPort = Cafienne$.MODULE$.config().api().bindPort();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Cafienne HTTP Server - starting akka http on {}:{}", new Object[]{apiHost, BoxesRunTime.boxToInteger((int)apiPort)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorSystem system = this.caseSystem().system();
        ServerBuilder akkaHttp = Http$.MODULE$.apply((ClassicActorSystemProvider)system).newServerAt(apiHost, apiPort);
        return akkaHttp.bindFlow(RouteResult$.MODULE$.routeToFlow(apiRoutes, (ClassicActorSystemProvider)system));
    }

    private static final void routeAppender$1(Function1 route, ObjectRef mainRoute$1) {
        mainRoute$1.elem = Directives$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1)mainRoute$1.elem, route}));
    }

    /*
     * WARNING - void declaration
     */
    public CafienneHttpServer(CaseSystem caseSystem) {
        void var2_2;
        this.caseSystem = caseSystem;
        LazyLogging.$init$((LazyLogging)this);
        Seq routes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CaseServiceRoute[]{new CaseEngineHealthRoute(caseSystem), new CasesRoutes(caseSystem), new IdentifierRoutes(caseSystem), new TaskRoutes(caseSystem), new TenantRoutes(caseSystem), new ConsentGroupRoutes(caseSystem), new PlatformRoutes(caseSystem), new RepositoryRoute(caseSystem), new DebugRoute(caseSystem)}));
        this.defaultRoutes = Cafienne$.MODULE$.config().api().anonymousConfig().enabled() ? (Seq)routes.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AnonymousRequestRoutes[]{new AnonymousRequestRoutes(caseSystem)}))) : var2_2;
        this.routes = new ListBuffer().addAll(this.defaultRoutes());
    }
}

