/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.akkahttp.repository;

import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.directives.ParameterDirectives;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import ch.megard.akka.http.cors.scaladsl.settings.CorsSettings;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.MissingTenantException;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.authentication.AuthenticatedUser;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.InvalidDefinitionException;
import org.cafienne.cmmn.repository.MissingDefinitionException;
import org.cafienne.cmmn.repository.WriteDefinitionException;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.akkahttp.ValueMarshallers$;
import org.cafienne.infrastructure.akkahttp.authentication.IdentityProvider;
import org.cafienne.infrastructure.akkahttp.route.AuthenticatedRoute;
import org.cafienne.infrastructure.akkahttp.route.AuthenticatedRoute$OIDCAuthentication$;
import org.cafienne.infrastructure.akkahttp.route.CaseServiceRoute;
import org.cafienne.infrastructure.akkahttp.route.TenantValidator;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.system.CaseSystem;
import org.w3c.dom.Document;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SecurityRequirement(name="openId", scopes={"openid"})
@Path(value="/repository")
@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001\u0002\u0007\u000e\u0001aA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0005\f\u0005\tg\u0001\u0011\t\u0011)A\u0005[!)A\u0007\u0001C\u0001k!9\u0011\b\u0001b\u0001\n\u0007Q\u0004BB!\u0001A\u0003%1\bC\u0003C\u0001\u0011\u00053\tC\u0003_\u0001\u0011\u00051\t\u0003\u0004\u0002&\u0002!\ta\u0011\u0005\u0007\u0003;\u0004A\u0011A\"\t\r\t=\u0002\u0001\"\u0001D\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f\u0013qBU3q_NLGo\u001c:z%>,H/\u001a\u0006\u0003\u001d=\t!B]3q_NLGo\u001c:z\u0015\t\u0001\u0012#\u0001\u0005bW.\f\u0007\u000e\u001e;q\u0015\t\u00112#A\u0004tKJ4\u0018nY3\u000b\u0005Q)\u0012\u0001C2bM&,gN\\3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\r QA\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001\t\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u000bI|W\u000f^3\u000b\u0005A!#BA\u0013\u0014\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!aJ\u0011\u0003%\u0005+H\u000f[3oi&\u001c\u0017\r^3e%>,H/\u001a\t\u0003A%J!AK\u0011\u0003\u001fQ+g.\u00198u-\u0006d\u0017\u000eZ1u_J\f!bY1tKNK8\u000f^3n+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0014\u0003\u0019\u0019\u0018p\u001d;f[&\u0011!g\f\u0002\u000b\u0007\u0006\u001cXmU=ti\u0016l\u0017aC2bg\u0016\u001c\u0016p\u001d;f[\u0002\na\u0001P5oSRtDC\u0001\u001c9!\t9\u0004!D\u0001\u000e\u0011\u0015Y3\u00011\u0001.\u0003\t)7-F\u0001<!\tat(D\u0001>\u0015\tq4$\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001Q\u001f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u00051!o\\;uKN,\u0012\u0001\u0012\t\u0003\u000bns!A\u0012-\u000f\u0005\u001d+fB\u0001%S\u001d\tIuJ\u0004\u0002K\u001b6\t1J\u0003\u0002M/\u00051AH]8pizJ\u0011AT\u0001\u0005C.\\\u0017-\u0003\u0002Q#\u0006!\u0001\u000e\u001e;q\u0015\u0005q\u0015BA*U\u0003!\u00198-\u00197bINd'B\u0001)R\u0013\t1v+\u0001\u0004tKJ4XM\u001d\u0006\u0003'RK!!\u0017.\u0002\u000fA\f7m[1hK*\u0011akV\u0005\u00039v\u0013QAU8vi\u0016T!!\u0017.\u0002\u00131|\u0017\rZ'pI\u0016d\u0007\u0006B\u0004aU.\u0004\"!\u00195\u000e\u0003\tT!a\u00193\u0002\u0005I\u001c(BA3g\u0003\t98OC\u0001h\u0003\u0015Q\u0017M^1y\u0013\tI'M\u0001\u0005Qe>$WoY3t\u0003\u00151\u0018\r\\;fY\u0005a\u0017%A7\u0002\u001f\u0005\u0004\b\u000f\\5dCRLwN\\\u0018y[2DCcB8~}\u0006\u0005\u00111AA\u0004\u0003\u0013\ti!a\u0004\u0002n\u0005=\u0004C\u00019|\u001b\u0005\t(B\u0001:t\u0003-\tgN\\8uCRLwN\\:\u000b\u0005Q,\u0018aA8bg*\u0011ao^\u0001\u0003mNR!\u0001_=\u0002\u000fM<\u0018mZ4fe*\t!0\u0001\u0002j_&\u0011A0\u001d\u0002\n\u001fB,'/\u0019;j_:\fqa];n[\u0006\u0014\u00180I\u0001\u0000\u0003U\u0011V\r\u001e:jKZ,\u0007%\u0019\u0011dCN,\u0007%\\8eK2\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\u0012\u0011QA\u0001&%\u0016$(/[3wK\u0002\n\u0007eY1tK\u0002jw\u000eZ3mA\tL\b%\u001b;tA\u0019LG.\u001a8b[\u0016\fA\u0001^1hg2\u0012\u00111B\u0011\u0002\u001d\u0005Q\u0001/\u0019:b[\u0016$XM]:-\t\u0005E\u00111L\u0016\u0017\u0003'\tI\"a\u0007\u0002\u0002\u0005}\u00111EA\u0013\u0003g\t)$a\u0016\u0002ZA\u0019\u0001/!\u0006\n\u0007\u0005]\u0011OA\u0005QCJ\fW.\u001a;fe\u0006!a.Y7fC\t\ti\"\u0001\u0004uK:\fg\u000e^\u0011\u0003\u0003C\t\u0001g\u00149uS>t\u0017\r\u001c\u0011uK:\fg\u000e\u001e\u0011j]\u0002:\b.[2iAQ|\u0007e]3be\u000eD\u0007EZ8sAQDW\rI7pI\u0016d\u0017AA5oI\t\t9#\u0003\u0003\u0002*\u0005-\u0012!B)V\u000bJK&\u0002BA\u0017\u0003_\t1\u0002U1sC6,G/\u001a:J]*\u0019\u0011\u0011G9\u0002\u000b\u0015tW/\\:\u0002\rM\u001c\u0007.Z7bW\u0019\t9$a\u0011\u0002FA!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>E\fQ!\\3eS\u0006LA!!\u0011\u0002<\t11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gn\t\u0002\u0002HA!\u0011\u0011JA)\u001d\u0011\tY%!\u0014\u0011\u0005)[\u0012bAA(7\u00051\u0001K]3eK\u001aLA!a\u0015\u0002V\t11\u000b\u001e:j]\u001eT1!a\u0014\u001c\u0003!\u0011X-];je\u0016$\u0017$\u0001\u0001,-\u0005M\u0011\u0011DA/\u0003\u0003\t\t'a\t\u0002f\u0005M\u0012QGA,\u0003W\n#!a\u0018\u0002\u0011\u0019LG.\u001a(b[\u0016\f#!a\u0019\u0002-\u0019KG.\u001a\u0011oC6,\u0007e\u001c4!i\",\u0007%\\8eK2$#!a\u001a\n\t\u0005%\u00141F\u0001\u0005!\u0006#\u0006*G\u0001\u0002\u0003%\u0011Xm\u001d9p]N,7\u000f\f\u0003\u0002r\u0005\u001d5FCA:\u0003\u0003\ti(!!\u0002\u0004B!\u0011QOA=\u001b\t\t9HC\u0002\u0002nELA!a\u001f\u0002x\tY\u0011\t]5SKN\u0004xN\\:fC\t\ty(\u0001\rN_\u0012,G\u000e\t4pk:$\u0007%\u00198eAI,G/\u001e:oK\u0012\fAB]3ta>t7/Z\"pI\u0016\f#!!\"\u0002\u0007I\u0002\u0004g\u000b\u0006\u0002t\u0005\u0005\u0011\u0011RAA\u0003\u001b\u000b#!a#\u0002\u001f5{G-\u001a7!]>$\bEZ8v]\u0012\f#!a$\u0002\u0007Q\u0002D\u0007K\u0002\b\u0003'\u00032!YAK\u0013\r\t9J\u0019\u0002\u0004\u000f\u0016#\u0006FB\u0004\u0002\u001c*\f\t\u000bE\u0002b\u0003;K1!a(c\u0005\u0011\u0001\u0016\r\u001e5\"\u0005\u0005\r\u0016a\u00047pC\u0012|3PZ5mK:\u000bW.Z?\u0002\u00151L7\u000f^'pI\u0016d7\u000fK\u0003\tA*\fI\u000b\f\u0002\u0002,\u0006\u0012\u0011QV\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:Dc\u0001CAYU\u0006]\u0006cA1\u00024&\u0019\u0011Q\u00172\u0003\u0011\r{gn];nKNd#!a+)+!yW0a/\u0002\u0002\u0005}\u0016qAAb\u0003\u001b\t)-!\u001c\u0002N\u0006\u0012\u0011QX\u0001#%\u0016$(/[3wK\u0002\n\u0007\u0005\\5ti\u0002zg\r\t3fa2|\u00170\u001a3![>$W\r\\:\"\u0005\u0005\u0005\u0017!\t*fiV\u0014hn\u001d\u0011bA1L7\u000f\u001e\u0011pM\u0002\"W\r\u001d7ps\u0016$\u0007%\\8eK2\u001cHFAA\u0006Y\t\t9m\u000b\f\u0002\u0014\u0005e\u00111DA\u0001\u0003\u0013\f\u0019#!\n\u00024\u0005U\u0012qKA-C\t\tY-A\u0017PaRLwN\\1mAQ,g.\u00198uA%t\u0007e\u001e5jG\"\u0004Co\u001c\u0011tK\u0006\u00148\r\u001b\u0011g_J\u0004Sn\u001c3fYNd#!a4,\u0015\u0005M\u0014\u0011AAi\u0003\u0003\u000b\u0019)\t\u0002\u0002T\u00069B*[:uA=4\u0007%\\8eK2\u001c\bE]3ukJtW\r\u001a\u0015\u0004\u0011\u0005M\u0005F\u0002\u0005\u0002\u001c*\fI.\t\u0002\u0002\\\u0006!A.[:u\u000351\u0018\r\\5eCR,Wj\u001c3fY\"*\u0011\u0002\u00196\u0002b2\u0012\u00111\u0016\u0015\u0007\u0013\u0005E&.!:-\u00031Ds\"CAu\u0003\u0003\t\u00190a\u0016\u0002l\u0005]\u0018\u0011 \t\u0005\u0003W\fy/\u0004\u0002\u0002n*\u0019\u0011QB9\n\t\u0005E\u0018Q\u001e\u0002\f%\u0016\fX/Z:u\u0005>$\u00170\t\u0002\u0002v\u0006\u0001B)\u001a4j]&$\u0018n\u001c8tA\u0019LG.Z\u0001\bG>tG/\u001a8uY\t\tYp\u000b\u0004\u0002~\u0006M\u0012Q\u0007\t\u0005\u0003s\ty0\u0003\u0003\u0003\u0002\u0005m\"aB\"p]R,g\u000e\u001e\u0015\u0012\u0013=l(QAA\u0001\u0005\u0013\t9A!\u0004\u0002n\t=\u0011E\u0001B\u0004\u0003U1\u0016\r\\5eCR,\u0007%\u0019\u0011dCN,\u0007%\\8eK2\f#Aa\u0003\u0002\u001dZ\u000bG.\u001b3bi\u0016\u0004\u0013\rI2bg\u0016\u0004Sn\u001c3fY\u0002\"WMZ5oSRLwN\\:!M&dW\rI1oI\u0002\u0012X\r^;s]\u0002\"\b.\u001a\u0011wC2LG-\u0019;j_:\u0004SM\u001d:peNd\u0003e\u001c:!\u001f.c#!a\u0003-\t\tE!qC\u0016\u000b\u0003g\n\tAa\u0005\u0002\u0002\u0006\r\u0015E\u0001B\u000b\u0003=iu\u000eZ3mAY\fG.\u001b3bi\u0016$7FCA:\u0003\u0003\u0011I\"!!\u0003\u001e\u0005\u0012!1D\u0001\u0011\u001b>$W\r\u001c\u0011jg\u0002JgN^1mS\u0012\f#Aa\b\u0002\u0007Q\u0002\u0004\u0007K\u0002\n\u0005G\u00012!\u0019B\u0013\u0013\r\u00119C\u0019\u0002\u0005!>\u001bF\u000b\u000b\u0004\n\u00037S'1F\u0011\u0003\u0005[\t\u0001B^1mS\u0012\fG/Z\u0001\fI\u0016\u0004Hn\\=N_\u0012,G\u000e\u000b\u0004\u000b\u0003cS'1\u0007\u0017\u0002Y\"z!\"!;\u0002\u0002\t]\u0012qKA6\u0003o\u0014Y$\t\u0002\u0003:\u0005!B)\u001a4j]&$\u0018n\u001c8tAakE\n\t4jY\u0016d#!a?)+)yWPa\u0010\u0002\u0002\t\r\u0013q\u0001B$\u0003\u001b\u0011I%!\u001c\u0003X\u0005\u0012!\u0011I\u0001\u0014\t\u0016\u0004Hn\\=!C\u0002\u001a\u0017m]3![>$W\r\\\u0011\u0003\u0005\u000b\n\u0011\bR3qY>L\b%\u0019\u0011dCN,\u0007%\\8eK2\u0004C-\u001a4j]&$\u0018n\u001c8tA\u0019LG.\u001a\u0011u_\u0002\"\b.\u001a\u0011eKBdw.\u001f\u0011g_2$WM\u001d\u0017\u0003\u0003\u0017aCAa\u0013\u0003R-2\u00121CA\r\u00037\t\tA!\u0014\u0002$\u0005\u0015\u00121GA\u001b\u0003/\nI&\t\u0002\u0003P\u0005as\n\u001d;j_:\fG\u000e\t;f]\u0006tG\u000fI5oA]D\u0017n\u00195!i>\u0004C-\u001a9m_f\u0004C\u000f[3![>$W\r\\\u0016\u0017\u0003'\tI\"!\u0018\u0002\u0002\tM\u00131EA3\u0003g\t)$a\u0016\u0002l\u0005\u0012!QK\u0001)\r&dW\r\t8b[\u0016\u0004sN\u001a\u0011uQ\u0016\u0004Sn\u001c3fY\u0002:\u0018\u000e\u001e5pkR\u0004S\r\u001f;f]NLwN\u001c\u0017\t\u00053\u0012\u0019G!\u001b\u0003t-R\u00111OA\u0001\u00057\n\tIa\u0018\"\u0005\tu\u0013\u0001F'pI\u0016d\u0007\u0005Z3qY>LX\rZ\u0018tCZ,G-\t\u0002\u0003b\u0005\u0019!\u0007\r\u001b,\u0015\u0005M\u0014\u0011\u0001B3\u0003\u0003\u0013i\"\t\u0002\u0003h\u00051\u0013J\u001c<bY&$\u0007%\\8eK2\u0004sN\u001d\u0011gC&dWO]3!o\"LG.\u001a\u0011xe&$\u0018N\\4,\u0015\u0005M\u0014\u0011\u0001B6\u0003\u0003\u0013y'\t\u0002\u0003n\u0005qaj\u001c;!\u0003V$\bn\u001c:ju\u0016$\u0017E\u0001B9\u0003\r!\u0004'M\u0016\u000b\u0003g\n\tA!\u001e\u0002\u0002\ne\u0014E\u0001B<\u0003u\u0019v.\\3!k:,\u0007\u0010]3di\u0016$\u0007%\u001a:s_J\u0004snY2ve\u0016$\u0017E\u0001B>\u0003\r)\u0004\u0007\r\u0015\u0004\u0015\t\r\u0002F\u0002\u0006\u0002\u001c*\u0014\t)\t\u0002\u0003\u0004\u0006\tB-\u001a9m_f|3PZ5mK:\u000bW.Z?\u0002\u001dU\u001cXM],ji\"$VM\\1oiR\u0019AI!#\t\u000f\t-5\u00021\u0001\u0003\u000e\u0006A1/\u001e2S_V$X\r\u0005\u0005\u001b\u0005\u001f\u0013\u0019*a\u0012E\u0013\r\u0011\tj\u0007\u0002\n\rVt7\r^5p]J\u0002BA!&\u0003 6\u0011!q\u0013\u0006\u0005\u00053\u0013Y*\u0001\u0005jI\u0016tG/\u001b;z\u0015\r\u0011ijE\u0001\u000bC\u000e$xN]7pI\u0016d\u0017\u0002\u0002BQ\u0005/\u0013A\u0002\u00157bi\u001a|'/\\+tKJDc\u0001AANU\n\u0015\u0016E\u0001BT\u0003-y#/\u001a9pg&$xN]=)\u0017\u0001\u0011Y+!\u0007\u00038\nm&Q\u0018\t\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*\u0019!\u0011W9\u0002\u0011M,7-\u001e:jifLAA!.\u00030\n\u00192+Z2ve&$\u0018PU3rk&\u0014X-\\3oi\u0006\u0012!\u0011X\u0001\u0007_B,g.\u00133\u0002\rM\u001cw\u000e]3tY\t\u0011y,\t\u0002\u0003B\u00061q\u000e]3oS\u0012\u0004")
public class RepositoryRoute
implements TenantValidator {
    private final CaseSystem caseSystem;
    private final ExecutionContext ec;
    private IdentityProvider userCache;
    private IdentityProvider uc;
    private volatile AuthenticatedRoute$OIDCAuthentication$ OIDCAuthentication$module;
    private CorsSettings org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings;
    private RejectionHandler org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler;
    private Directive<BoxedUnit> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors;
    private Function1<RequestContext, Future<RouteResult>> route;
    private Option<Function1<RequestContext, Future<RouteResult>>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes;
    private String prefix;
    private boolean addToSwaggerRoutes;
    private Buffer<Class<?>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Function1<RequestContext, Future<RouteResult>> validateTenant(String tenant, Function0<Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return TenantValidator.validateTenant$(this, tenant, subRoute);
    }

    @Override
    public ExceptionHandler exceptionHandler() {
        return AuthenticatedRoute.exceptionHandler$(this);
    }

    @Override
    @Deprecated
    public Function1<RequestContext, Future<RouteResult>> optionalUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.optionalUser$(this, subRoute);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> authenticatedUser(Function1<AuthenticatedUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.authenticatedUser$(this, subRoute);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> validUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.validUser$(this, subRoute);
    }

    @Override
    public void caseSystemMustBeHealthy() {
        AuthenticatedRoute.caseSystemMustBeHealthy$(this);
    }

    @Override
    public RejectionHandler requestServiceRejectionHandler() {
        return CaseServiceRoute.requestServiceRejectionHandler$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> defaultExceptionHandler(Throwable t) {
        return CaseServiceRoute.defaultExceptionHandler$(this, t);
    }

    @Override
    public Directive<BoxedUnit> writeLastModifiedHeader(ModelResponse response, String headerName) {
        return CaseServiceRoute.writeLastModifiedHeader$(this, response, headerName);
    }

    @Override
    public String writeLastModifiedHeader$default$2() {
        return CaseServiceRoute.writeLastModifiedHeader$default$2$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> completeCafienneJSONSeq(Seq<CafienneJson> seq) {
        return CaseServiceRoute.completeCafienneJSONSeq$(this, seq);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> completeJsonValue(Value<?> v) {
        return CaseServiceRoute.completeJsonValue$(this, v);
    }

    @Override
    public void addSubRoute(CaseServiceRoute subRoute) {
        CaseServiceRoute.addSubRoute$(this, subRoute);
    }

    @Override
    public Seq<Class<?>> apiClasses() {
        return CaseServiceRoute.apiClasses$(this);
    }

    @Override
    public void registerAPIRoute(CaseServiceRoute route) {
        CaseServiceRoute.registerAPIRoute$(this, route);
    }

    @Override
    public IdentityProvider userCache() {
        return this.userCache;
    }

    @Override
    public IdentityProvider uc() {
        return this.uc;
    }

    @Override
    public AuthenticatedRoute$OIDCAuthentication$ OIDCAuthentication() {
        if (this.OIDCAuthentication$module == null) {
            this.OIDCAuthentication$lzycompute$1();
        }
        return this.OIDCAuthentication$module;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$AuthenticatedRoute$_setter_$userCache_$eq(IdentityProvider x$1) {
        this.userCache = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$AuthenticatedRoute$_setter_$uc_$eq(IdentityProvider x$1) {
        this.uc = x$1;
    }

    @Override
    public CorsSettings org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings;
    }

    @Override
    public RejectionHandler org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler;
    }

    @Override
    public Directive<BoxedUnit> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    @Override
    public Option<Function1<RequestContext, Future<RouteResult>>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes_$eq(Option<Function1<RequestContext, Future<RouteResult>>> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes = x$1;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public boolean addToSwaggerRoutes() {
        return this.addToSwaggerRoutes;
    }

    @Override
    public Buffer<Class<?>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings_$eq(CorsSettings x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler_$eq(RejectionHandler x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors_$eq(Directive<BoxedUnit> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$route_$eq(Function1<RequestContext, Future<RouteResult>> x$1) {
        this.route = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$prefix_$eq(String x$1) {
        this.prefix = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$addToSwaggerRoutes_$eq(boolean x$1) {
        this.addToSwaggerRoutes = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses_$eq(Buffer<Class<?>> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses = x$1;
    }

    private Logger logger$lzycompute() {
        RepositoryRoute repositoryRoute = this;
        synchronized (repositoryRoute) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> routes() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathPrefix(Directives$.MODULE$._segmentStringToPathMatcher("repository"))).apply((Function0 & Serializable)() -> Directives$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{this.loadModel(), this.listModels(), this.validateModel(), this.deployModel()})));
    }

    @Path(value="load/{fileName}")
    @GET
    @Operation(summary="Retrieve a case model", description="Retrieve a case model by its filename", tags={"repository"}, parameters={@Parameter(name="tenant", description="Optional tenant in which to search for the model", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), required=false), @Parameter(name="fileName", description="File name of the model", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Model found and returned", responseCode="200"), @ApiResponse(description="Model not found", responseCode="404")})
    @Produces(value={"application/xml"})
    public Function1<RequestContext, Future<RouteResult>> loadModel() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("load").$div((PathMatcher)Directives$.MODULE$.Segment(), TupleOps.Join$.MODULE$.join0P())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)modelName -> this.userWithTenant((Function2<PlatformUser, String, Function1<RequestContext, Future<RouteResult>>>)(Function2 & Serializable)(platformUser, tenant) -> {
            StandardRoute standardRoute;
            try {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Loading definitions '{}' from tenant '{}'", new Object[]{modelName, tenant});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                DefinitionsDocument model = Cafienne$.MODULE$.config().repository().DefinitionProvider().read((UserIdentity)platformUser, (String)tenant, (String)modelName);
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.OK(), (Function0 & Serializable)() -> model.getDocument(), ValueMarshallers$.MODULE$.documentMarshaller());
            }
            catch (MissingDefinitionException m) {
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> "A model with name " + modelName + " cannot be found", Marshaller$.MODULE$.StringMarshaller());
            }
            catch (InvalidDefinitionException i) {
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> i.toXML(), ValueMarshallers$.MODULE$.documentMarshaller());
            }
            catch (MissingTenantException t) {
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> t.getMessage(), Marshaller$.MODULE$.StringMarshaller());
            }
            catch (Exception other) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected loading failure", (Throwable)other);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.InternalServerError(), Marshaller$.MODULE$.fromStatusCode()));
            }
            return standardRoute;
        })));
    }

    @Path(value="list")
    @GET
    @Operation(summary="Retrieve a list of deployed models", description="Returns a list of deployed models", tags={"repository"}, parameters={@Parameter(name="tenant", description="Optional tenant in which to search for models", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), required=false)}, responses={@ApiResponse(description="List of models returned", responseCode="200")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> listModels() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("list"))).apply((Function0 & Serializable)() -> this.userWithTenant((Function2<PlatformUser, String, Function1<RequestContext, Future<RouteResult>>>)(Function2 & Serializable)(platformUser, tenant) -> {
            ValueMap models = new ValueMap();
            models.withArray("models");
            CollectionConverters$.MODULE$.ListHasAsScala(Cafienne$.MODULE$.config().repository().DefinitionProvider().list((UserIdentity)platformUser, (String)tenant)).asScala().foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RepositoryRoute.$anonfun$listModels$4(platformUser, tenant, models, file)));
            return this.completeJsonValue(models);
        })));
    }

    @Path(value="validate")
    @POST
    @Operation(summary="Validate a case model", description="Validate a case model definitions file and return the validation errors, or OK", tags={"repository"}, responses={@ApiResponse(description="Model validated", responseCode="200"), @ApiResponse(description="Model is invalid", responseCode="400")})
    @RequestBody(description="Definitions file", required=true, content={@Content(schema=@Schema(implementation=String.class))})
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> validateModel() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("validate"))).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(ValueMarshallers$.MODULE$.DocumentUnmarshaller()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)payload -> {
            StandardRoute standardRoute;
            try {
                new DefinitionsDocument((Document)payload);
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.OK(), Marshaller$.MODULE$.fromStatusCode()));
            }
            catch (InvalidDefinitionException idd) {
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> idd.toJSON().toString(), Marshaller$.MODULE$.StringMarshaller());
            }
            catch (Throwable other) {
                throw other;
            }
            return standardRoute;
        })));
    }

    @Path(value="deploy/{fileName}")
    @POST
    @Operation(summary="Deploy a case model", description="Deploy a case model definitions file to the deploy folder", tags={"repository"}, parameters={@Parameter(name="tenant", description="Optional tenant in which to deploy the model", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), required=false), @Parameter(name="fileName", description="File name of the model without extension", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Model deployed/saved", responseCode="204"), @ApiResponse(description="Invalid model or failure while writing", responseCode="400"), @ApiResponse(description="Not Authorized", responseCode="401"), @ApiResponse(description="Some unexpected error occured", responseCode="500")})
    @RequestBody(description="Definitions XML file", required=true, content={@Content(schema=@Schema(implementation=String.class))})
    @Consumes(value={"application/xml"})
    public Function1<RequestContext, Future<RouteResult>> deployModel() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("deploy").$div((PathMatcher)Directives$.MODULE$.Remaining(), TupleOps.Join$.MODULE$.join0P())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)modelName -> this.userWithTenant((Function2<PlatformUser, String, Function1<RequestContext, Future<RouteResult>>>)(Function2 & Serializable)(platformUser, tenant) -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(ValueMarshallers$.MODULE$.DocumentUnmarshaller()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)xmlDocument -> {
            StandardRoute standardRoute;
            block16: {
                try {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Deploying '{}' to tenant '{}'", new Object[]{modelName, tenant});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    DefinitionsDocument definitions = new DefinitionsDocument((Document)xmlDocument);
                    TenantUser tenantUser = platformUser.getTenantUser((String)tenant);
                    if (tenantUser.isOwner()) {
                        Cafienne$.MODULE$.config().repository().DefinitionProvider().write((UserIdentity)platformUser, (String)tenant, (String)modelName, definitions);
                        standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.NoContent(), Marshaller$.MODULE$.fromStatusCode()));
                        break block16;
                    }
                    standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.Unauthorized(), (Function0 & Serializable)() -> "User '" + platformUser.id() + "' does not have the privileges to deploy a definition", Marshaller$.MODULE$.StringMarshaller());
                }
                catch (InvalidDefinitionException idd) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Deployment failure", (Throwable)idd);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> "Cannot deploy " + modelName + ": definition is invalid.", Marshaller$.MODULE$.StringMarshaller());
                }
                catch (WriteDefinitionException failure) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Deployment failure", (Throwable)failure);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> failure.getLocalizedMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                catch (AuthorizationException failure) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Deployment failure", (Throwable)failure);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.Unauthorized(), (Function0 & Serializable)() -> failure.getLocalizedMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                catch (Throwable other) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Unexpected deployment failure", other);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.InternalServerError(), Marshaller$.MODULE$.fromStatusCode()));
                }
            }
            return standardRoute;
        }))));
    }

    private Function1<RequestContext, Future<RouteResult>> userWithTenant(Function2<PlatformUser, String, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return this.validUser((Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)platformUser -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.parameters(ParameterDirectives.ParamSpec$.MODULE$.forNOR(Directives$.MODULE$._string2NR("tenant").$qmark(), Unmarshaller$.MODULE$.sourceOptionUnmarshaller(Unmarshaller$.MODULE$.identityUnmarshaller()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)optionalTenant -> {
            String tenant = platformUser.resolveTenant((Option<String>)optionalTenant);
            return this.validateTenant(tenant, (Function0<Function1<RequestContext, Future<RouteResult>>>)(Function0 & Serializable)() -> (Function1)subRoute.apply(platformUser, (Object)tenant));
        }));
    }

    private final void OIDCAuthentication$lzycompute$1() {
        RepositoryRoute repositoryRoute = this;
        synchronized (repositoryRoute) {
            if (this.OIDCAuthentication$module == null) {
                this.OIDCAuthentication$module = new AuthenticatedRoute$OIDCAuthentication$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$listModels$4(PlatformUser platformUser$1, String tenant$1, ValueMap models$1, String file) {
        Object description = "Description";
        try {
            DefinitionsDocument definitionsDocument = Cafienne$.MODULE$.config().repository().DefinitionProvider().read(platformUser$1, tenant$1, file);
            description = definitionsDocument.getFirstCase().documentation.text;
        }
        catch (InvalidDefinitionException i) {
            description = i.toString();
        }
        catch (Throwable t) {
            description = "Could not read definition: " + t.getMessage();
        }
        ValueMap model = new ValueMap("definitions", file, "description", description);
        return models$1.withArray("models").add(model);
    }

    public RepositoryRoute(CaseSystem caseSystem) {
        this.caseSystem = caseSystem;
        LazyLogging.$init$((LazyLogging)this);
        CaseServiceRoute.$init$(this);
        AuthenticatedRoute.$init$(this);
        TenantValidator.$init$(this);
        this.ec = caseSystem.system().dispatcher();
        this.registerAPIRoute(this);
        Statics.releaseFence();
    }
}

