/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.akkahttp.tenant.route;

import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import ch.megard.akka.http.cors.scaladsl.settings.CorsSettings;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.authentication.AuthenticatedUser;
import org.cafienne.consentgroup.actorapi.ConsentGroup;
import org.cafienne.consentgroup.actorapi.command.CreateConsentGroup;
import org.cafienne.infrastructure.akkahttp.authentication.IdentityProvider;
import org.cafienne.infrastructure.akkahttp.route.AuthenticatedRoute;
import org.cafienne.infrastructure.akkahttp.route.AuthenticatedRoute$OIDCAuthentication$;
import org.cafienne.infrastructure.akkahttp.route.CaseServiceRoute;
import org.cafienne.infrastructure.akkahttp.route.CommandRoute;
import org.cafienne.infrastructure.akkahttp.route.QueryRoute;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.Value;
import org.cafienne.querydb.materializer.LastModifiedRegistration;
import org.cafienne.querydb.query.UserQueries;
import org.cafienne.service.akkahttp.cases.CaseDefinitionDocument;
import org.cafienne.service.akkahttp.consentgroup.model.ConsentGroupAPI;
import org.cafienne.service.akkahttp.consentgroup.model.ConsentGroupAPI$;
import org.cafienne.service.akkahttp.tenant.model.TenantAPI;
import org.cafienne.service.akkahttp.tenant.model.TenantAPI$;
import org.cafienne.service.akkahttp.tenant.route.TenantRoute;
import org.cafienne.system.CaseSystem;
import org.cafienne.tenant.actorapi.command.GetTenantOwners;
import org.cafienne.tenant.actorapi.command.RemoveTenantUser;
import org.cafienne.tenant.actorapi.command.ReplaceTenant;
import org.cafienne.tenant.actorapi.command.SetTenantUser;
import org.cafienne.tenant.actorapi.command.TenantCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple1;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SecurityRequirement(name="openId", scopes={"openid"})
@Path(value="/tenant")
@ScalaSignature(bytes="\u0006\u0005\r-c\u0001B\b\u0011\u0001uA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t%\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!)\u0011\u0007\u0001C\u0001e!)Q\u0007\u0001C!m!)\u0011\u000b\u0001C\u0001m!1\u00111\u0012\u0001\u0005\u0002YBaA!\u0004\u0001\t\u00031\u0004B\u0002B\b\u0001\u0011%a\u0007\u0003\u0004\u0003\u0012\u0001!\tA\u000e\u0005\u0007\u0005+\u0002A\u0011\u0001\u001c\t\r\t]\u0003\u0001\"\u00017\u0011\u0019\u0011I\u0006\u0001C\u0001m!1!q\u0012\u0001\u0005\u0002YBaA!;\u0001\t\u00031$!\u0005+f]\u0006tGoT<oKJ\u001c(k\\;uK*\u0011\u0011CE\u0001\u0006e>,H/\u001a\u0006\u0003'Q\ta\u0001^3oC:$(BA\u000b\u0017\u0003!\t7n[1iiR\u0004(BA\f\u0019\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0007\u000e\u0002\u0011\r\fg-[3o]\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&M5\t\u0001#\u0003\u0002(!\tYA+\u001a8b]R\u0014v.\u001e;f\u0003)\u0019\u0017m]3TsN$X-\\\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011Q\u0006G\u0001\u0007gf\u001cH/Z7\n\u0005=b#AC\"bg\u0016\u001c\u0016p\u001d;f[\u0006Y1-Y:f'f\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003K\u0001AQ\u0001K\u0002A\u0002)\naA]8vi\u0016\u001cX#A\u001c\u0011\u0005areBA\u001dL\u001d\tQ\u0004J\u0004\u0002<\u000b:\u0011AH\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fq\ta\u0001\u0010:p_Rt\u0014\"A!\u0002\t\u0005\\7.Y\u0005\u0003\u0007\u0012\u000bA\u0001\u001b;ua*\t\u0011)\u0003\u0002G\u000f\u0006A1oY1mC\u0012\u001cHN\u0003\u0002D\t&\u0011\u0011JS\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0019;\u0015B\u0001'N\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u0013&\n\u0005=\u0003&!\u0002*pkR,'B\u0001'N\u0003=9W\r\u001e+f]\u0006tGoT<oKJ\u001c\b\u0006B\u0003T;z\u0003\"\u0001V.\u000e\u0003US!AV,\u0002\u0005I\u001c(B\u0001-Z\u0003\t98OC\u0001[\u0003\u0015Q\u0017M^1y\u0013\taVK\u0001\u0005Qe>$WoY3t\u0003\u00151\u0018\r\\;fY\u0005y\u0016%\u00011\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007FD\u0003caF\u001cHO^<zu\u0006u\u0012q\b\t\u0003G:l\u0011\u0001\u001a\u0006\u0003K\u001a\f1\"\u00198o_R\fG/[8og*\u0011q\r[\u0001\u0004_\u0006\u001c(BA5k\u0003\t18G\u0003\u0002lY\u000691o^1hO\u0016\u0014(\"A7\u0002\u0005%|\u0017BA8e\u0005%y\u0005/\u001a:bi&|g.A\u0004tk6l\u0017M]=\"\u0003I\f\u0011cR3uAQ,g.\u00198uA=<h.\u001a:t\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003U\f1EU3ue&,g/Z:!i\",\u0007\u0005\\5ti\u0002zg\r\t;f]\u0006tG\u000fI8x]\u0016\u00148/\u0001\u0003uC\u001e\u001cH&\u0001=\"\u0003M\t!\u0002]1sC6,G/\u001a:tY\u0005Y8F\u0005?\u0000qN\f\t!!\u0002\u0002\b\u0005U\u0011qCA\u001d\u0003w\u0001\"aY?\n\u0005y$'!\u0003)be\u0006lW\r^3s\u0003\u0011q\u0017-\\3\"\u0005\u0005\r\u0011A\t+iK\u0002\"XM\\1oi\u0002\"x\u000e\t:fiJLWM^3!_^tWM]:!MJ|W.\u0001\u0002j]\u0012\u0012\u0011\u0011B\u0005\u0005\u0003\u0017\ti!\u0001\u0003Q\u0003RC%\u0002BA\b\u0003#\t1\u0002U1sC6,G/\u001a:J]*\u0019\u00111\u00033\u0002\u000b\u0015tW/\\:\u0002\rM\u001c\u0007.Z7bW\u0019\tI\"!\n\u0002(A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0011\fQ!\\3eS\u0006LA!a\t\u0002\u001e\t11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gn\t\u0002\u0002*A!\u00111FA\u001a\u001d\u0011\ti#a\f\u0011\u0005u\u0002\u0013bAA\u0019A\u00051\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\r!\u0003!\u0011X-];je\u0016$\u0017$A\u0001\u0002\u0013I,7\u000f]8og\u0016\u001cH\u0006BA!\u0003[ZS\"a\u0011\u0002N\u0005=3/a\u0015\u0002X\u0005e\u0003\u0003BA#\u0003\u0013j!!a\u0012\u000b\u0007\u0005uB-\u0003\u0003\u0002L\u0005\u001d#aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f#!!\u0015\u0002\u0007I\u0002D'\t\u0002\u0002V\u0005\u0001D*[:uA=4\u0007%^:fe\u0002JGm\u001d\u0011pM\u0002\"\b.\u0019;!CJ,\u0007e\\<oKJ\u0004sN\u001a\u0011uQ\u0016\u0004C/\u001a8b]R\fqaY8oi\u0016tG\u000f\f\u0002\u0002\\-2\u0011QLA\u000b\u0003G\u0002B!a\u0007\u0002`%!\u0011\u0011MA\u000f\u0005\u001d\u0019uN\u001c;f]R\\c!!\u0007\u0002&\u0005\u00154EAA4!\u0019\tY#!\u001b\u0002*%!\u00111NA\u001c\u0005\r\u0019V\r^\u0016\n\u0003\u0007\ni%a\u001ct\u0003g\n#!!\u001d\u0002\u0007Q\u0002D'\t\u0002\u0002v\u0005\u0001B+\u001a8b]R\u0004cn\u001c;!M>,h\u000e\u001a\u0015\u0004\u000b\u0005e\u0004c\u0001+\u0002|%\u0019\u0011QP+\u0003\u0007\u001d+E\u000b\u000b\u0004\u0006\u0003\u0003k\u0016q\u0011\t\u0004)\u0006\r\u0015bAAC+\n!\u0001+\u0019;iC\t\tI)\u0001\t0wR,g.\u00198u{>zwO\\3sg\u0006I1/\u001a;UK:\fg\u000e\u001e\u0015\u0007\r\u0005=U,!&\u0011\u0007Q\u000b\t*C\u0002\u0002\u0014V\u0013\u0001bQ8ogVlWm\u001d\u0017\u0002?\"ra!!'t\u0003G\u000bI$a\u000f\u0002X\u0005\u001d\u0006\u0003BAN\u0003?k!!!(\u000b\u0005e$\u0017\u0002BAQ\u0003;\u00131BU3rk\u0016\u001cHOQ8es\u0006\u0012\u0011QU\u0001\u0010+N,'o\u001d\u0011u_\u0002*\b\u000fZ1uK2\u0012\u0011\u0011V\u0016\u0007\u0003;\n)\"a+,\r\u0005e\u0011QEAWG\t\ty\u000b\u0005\u0003\u00022\u0006Mg\u0002BAZ\u0003\u001btA!!.\u0002J:!\u0011qWAd\u001d\u0011\tI,!2\u000f\t\u0005m\u00161\u0019\b\u0005\u0003{\u000b\tMD\u0002>\u0003\u007fK\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012BA\n\u0015\u0013\r\tYME\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u001f\f\t.A\u0005UK:\fg\u000e^!Q\u0013*\u0019\u00111\u001a\n\n\t\u0005U\u0017q\u001b\u0002\u0014%\u0016\u0004H.Y2f)\u0016t\u0017M\u001c;G_Jl\u0017\r\u001e\u0006\u0005\u0003\u001f\f\t\u000e\u000b\n\u0007EB\fYn]Apm\u0006\r\u00180!:\u0002>\u00055\u0018EAAo\u0003I\u0011V\r\u001d7bG\u0016\u0004C\u000f[3!i\u0016t\u0017M\u001c;\"\u0005\u0005\u0005\u0018!a(SKBd\u0017mY3!i\",\u0007%\u001a=jgRLgn\u001a\u0011uK:\fg\u000e\u001e\u0011vg\u0016\u00148O\f\u0011Fq&\u001cH/\u001b8hAU\u001cXM]\u0017bG\u000e|WO\u001c;tA9|G\u000fI5oAQDW\r\t8fo\u0002b\u0017n\u001d;!o&dG\u000e\t3jg\u0006\u0014G.\u001a3/A9+w\u000fI;tKJ\u001c\b%\u001b8!i\",\u0007\u0005\\5ti\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0013\r\u001a3fI2\u0002s\u000e\u001e5feN\u0004s/\u001b7mA!\fg/\u001a\u0011uQ\u0016L'\u000f\t9s_B,'\u000f^5fg\u0002\ng\u000e\u001a\u0011s_2,7\u000f\t:fa2\f7-\u001a3!o&$\b\u000e\t;iK\u0002rWm\u001e\u0011j]\u001a|'/\\1uS>tG&\u0001=-\u0005\u0005\u001d8F\u0005?\u0000qN\fI/!\u0002\u0002\b\u0005U\u0011qCA\u001d\u0003w\t#!a;\u0002]QCW\r\t;f]\u0006tG\u000fI5oA]D\u0017n\u00195!i>\u0004#/\u001a9mC\u000e,\u0007\u0005\u001e5fA%tgm\u001c:nCRLwN\u001c\u0017\u0005\u0003_\f)pK\u0005\u0002DM\f\t0!\u0014\u0002P\u0005\u0012\u00111_\u0001\u001d)\u0016t\u0017M\u001c;!e\u0016\u0004H.Y2fI\u0002\u001aXoY2fgN4W\u000f\u001c7zW%\t\u0019e]A|\u0003\u001b\nY0\t\u0002\u0002z\u0006iB+\u001a8b]R\u0004\u0013N\u001c4pe6\fG/[8oA%\u001c\b%\u001b8wC2LG-\t\u0002\u0002~\u0006\u0019A\u0007\r\u0019)\u0007\u0019\u0011\t\u0001E\u0002U\u0005\u0007I1A!\u0002V\u0005\u0011\u0001vj\u0015+)\r\u0019\t\t)\u0018B\u0005C\t\u0011Y!A\u00050wR,g.\u00198u{\u0006I\u0001/\u001e;UK:\fg\u000e^\u0001\u000ee\u0016\u0004H.Y2f)\u0016t\u0017M\u001c;\u0002\u000fM,G/V:fe\"2\u0011\"a$^\u0005+a\u0013a\u0018\u0015\u000f\u0013\u0005e5O!\u0007\u0002:\u0005m\u0012q\u000bB\u000fC\t\u0011Y\"\u0001\tVg\u0016\u0014\b%\u001b8g_Jl\u0017\r^5p]2\u0012!qD\u0016\u0007\u0003;\n)B!\t,\r\u0005e\u0011Q\u0005B\u0012G\t\u0011)\u0003\u0005\u0003\u00022\n\u001d\u0012\u0002\u0002B\u0015\u0003/\u0014!\"V:fe\u001a{'/\\1uQII!\r\u001dB\u0017g\nEbO!\u000ez\u0005o\tiDa\u0010\"\u0005\t=\u0012\u0001H!eI\u0002z'\u000f\t:fa2\f7-\u001a\u0011bAQ,g.\u00198uAU\u001cXM]\u0011\u0003\u0005g\tQLU3qY\u0006\u001cW\r\t;iK\u0002\u0002(o\u001c9feRLWm\u001d\u0011b]\u0012\u0004#o\u001c7fg\u0002zg\rI1!i\u0016t\u0017M\u001c;!kN,'\u000fI5gA%$\b%\u001a=jgR\u001cH\u0006I8uQ\u0016\u0014x/[:fA\r\u0014X-\u0019;fg\u0002\n\u0007E\\3xAU\u001cXM\u001d\u0018-\u0003ad#A!\u000f,%q|\bp\u001dB\u001e\u0003\u000b\t9!!\u0006\u0002\u0018\u0005e\u00121H\u0011\u0003\u0005{\t!\u0006\u00165fAQ,g.\u00198uA%t\u0007e\u001e5jG\"\u0004Co\u001c\u0011bI\u0012|S\u000f\u001d3bi\u0016\u0004C\u000f[3!kN,'\u000f\f\u0003\u0003B\t\u001d3&CA\"g\n\r\u0013QJA(C\t\u0011)%A\u0012UK:\fg\u000e\u001e\u0011vg\u0016\u0014\bE]3hSN$XM]3eAM,8mY3tg\u001a,H\u000e\\=,\u0013\u0005\r3O!\u0013\u0002N\u0005m\u0018E\u0001B&\u0003\t\"VM\\1oi\u0002*8/\u001a:!S:4wN]7bi&|g\u000eI5tA%tg/\u00197jI\"\u001a\u0011B!\u0001)\r%\t\t)\u0018B)C\t\u0011\u0019&A\b0wR,g.\u00198u{>*8/\u001a:t\u0003\u001d\u0001X\u000f^+tKJ\f1B]3qY\u0006\u001cW-V:fe\u0006Q!/Z7pm\u0016,6/\u001a:)%1\u0011\u0007O!\u0018t\u0005C2(QM=\u0003h\u0005u\"\u0011P\u0011\u0003\u0005?\nACU3n_Z,\u0007%\u0019\u0011uK:\fg\u000e\u001e\u0011vg\u0016\u0014\u0018E\u0001B2\u0003%\u0013V-\\8wKN\u0004C\u000f[3!kN,'\u000f\t4s_6\u0004C\u000f[3!i\u0016t\u0017M\u001c;!Q%4\u0007%\u001b;!KbL7\u000f^:!C:$\u0007%[:!]>$\b\u0005\u001e5fA1\f7\u000f\u001e\u0011po:,'/\u000b\u0017\u0002q2\"!\u0011\u000eB8WIax\u0010_:\u0003l\u0005\u0015\u0011qAA\u000b\u0003/\tI$a\u000f\"\u0005\t5\u0014\u0001\u000b+iK\u0002\"XM\\1oi\u00022'o\\7!o\"L7\r\u001b\u0011u_\u0002\u0012X-\\8wK\u0002\"\b.\u001a\u0011vg\u0016\u00148f\u0005?\u0000\u0005c\u001a(QOA\u0003\u0003\u000f\t)\"a\u0006\u0002:\u0005m\u0012E\u0001B:\u0003\u0019)8/\u001a:JI\u0006\u0012!qO\u0001\u0013)\",\u0007%\u001b3!_\u001a\u0004C\u000f[3!kN,'\u000f\f\u0003\u0003|\t\u001d3&CA\"g\nu\u0014QJA(C\t\u0011y(\u0001\u0011UK:\fg\u000e\u001e\u0011vg\u0016\u0014\bE]3n_Z,G\rI:vG\u000e,7o\u001d4vY2L\bf\u0001\u0007\u0003\u0004B\u0019AK!\"\n\u0007\t\u001dUK\u0001\u0004E\u000b2+E+\u0012\u0015\u0007\u0019\u0005\u0005ULa#\"\u0005\t5\u0015\u0001G\u0018|i\u0016t\u0017M\u001c;~_U\u001cXM]:0wV\u001cXM]%e{\u0006\u00112M]3bi\u0016\u001cuN\\:f]R<%o\\;qQ\u0019i\u0011qR/\u0003\u00142\nq\f\u000b\b\u000e\u00033\u001b(qSA\u001d\u0003w\t9Fa'\"\u0005\te\u0015aD$s_V\u0004\b\u0005^8!GJ,\u0017\r^3-\u0005\tu5FBA/\u0003+\u0011yj\u000b\u0004\u0002\u001a\u0005\u0015\"\u0011U\u0012\u0003\u0005G\u0003BA!*\u0003::!!q\u0015BZ\u001d\u0011\u0011IKa,\u000f\t\u0005]&1V\u0005\u0004\u0005[#\u0012\u0001D2p]N,g\u000e^4s_V\u0004\u0018\u0002BAf\u0005cS1A!,\u0015\u0013\u0011\u0011)La.\u0002\u001f\r{gn]3oi\u001e\u0013x.\u001e9B!&SA!a3\u00032&!!1\u0018B_\u0005I\u0019uN\\:f]R<%o\\;q\r>\u0014X.\u0019;\u000b\t\tU&q\u0017\u0015\u0013\u001b\t\u0004(\u0011Y:\u0003FZ\u0014I-\u001fBf\u0003{\u0011\u0019.\t\u0002\u0003D\u000612I]3bi\u0016\u0004\u0013\rI2p]N,g\u000e\u001e\u0011he>,\b/\t\u0002\u0003H\u0006i'+Z4jgR,'\u000fI1!]\u0016<\beY8og\u0016tG\u000fI4s_V\u0004\b%\u001b8!C\u0002\"XM\\1oin\u0002C\u000f[3!OJ|W\u000f\u001d\u0011nkN$\b\u0005[1wK\u0002jW-\u001c2feNd\u0003%\u00198eA\u0005$\b\u0005\\3bgR\u0004sN\\3![\u0016l'-\u001a:![V\u001cH\u000f\t2fA=<h.\u001a:/Y\u0005AHF\u0001BgWIax\u0010_:\u0003P\u0006\u0015\u0011qAA\u000b\u0003/\tI$a\u000f\"\u0005\tE\u0017\u0001\n+iK\u0002\"XM\\1oi\u0002\"x\u000e\t:fiJLWM^3!C\u000e\u001cw.\u001e8ug\u00022'o\\7-\t\tU'1\\\u0016\n\u0003\u0007\u001a(q[A'\u0003\u001f\n#A!7\u0002E\r{gn]3oi\u0002:'o\\;qAU\u0004H-\u0019;fI\u0002\u001aXoY2fgN4W\u000f\u001c7zW%\t\u0019%!\u0014\u0002pM\u0014i.\t\u0002\u0003`\u000692i\u001c8tK:$\be\u001a:pkB\u0004cn\u001c;!M>,h\u000e\u001a\u0015\u0004\u001b\t\u0005\u0001FB\u0007\u0002\u0002v\u0013)/\t\u0002\u0003h\u0006Arf\u001f;f]\u0006tG/`\u0018d_:\u001cXM\u001c;.OJ|W\u000f]:\u0002/\u001d,G\u000fR5tC\ndW\rZ+tKJ\f5mY8v]R\u001c\b&\u0002\bT;\n5H&A0)%9\u0011\u0007O!=t\u0005k4(\u0011`=\u0003|\u0006u\"Q`\u0011\u0003\u0005g\fAeR3uA\u0005\u0004C.[:uA=4\u0007\u0005Z5tC\ndW\r\u001a\u0011vg\u0016\u0014\b%Y2d_VtGo]\u0011\u0003\u0005o\fAFU3ue&,g/Z:!i\",\u0007\u0005\\5ti\u0002zg\r\t3jg\u0006\u0014G.\u001a3!kN,'\u000fI1dG>,h\u000e^:-\u0003ad#A!4-\t\t}\u0018QN\u0016\u000e\u0003\u0007\nie!\u0001t\u0007\u000b\t9f!\u0003\"\u0005\r\r\u0011a\u0001\u001a1a\u0005\u00121qA\u0001<\u0019&\u001cH\u000fI8gAU\u001cXM\u001d\u0011bG\u000e|WO\u001c;tAQD\u0017\r\u001e\u0011iCZ,\u0007EY3f]\u0002\"\u0017n]1cY\u0016$\u0007%\u001b8!i\",\u0007\u0005^3oC:$HFAB\u0006W\u0019\ti&!\u0006\u0004\u000e-2\u0011\u0011DA\u0013\u0007\u001f\u0019#a!\u0005\u0011\r\u0005-\u0012\u0011NB\n!\u0011\u0019)ba\b\u000e\u0005\r]!\u0002BB\r\u00077\t\u0001\"\u001b3f]RLG/\u001f\u0006\u0004\u0007;A\u0012AC1di>\u0014Xn\u001c3fY&!1\u0011EB\f\u0005)!VM\\1oiV\u001bXM\u001d\u0015\u0004\u001d\u0005e\u0004F\u0002\b\u0002\u0002v\u001b9#\t\u0002\u0004*\u0005Yrf\u001f;f]\u0006tG/`\u0018eSN\f'\r\\3e[\u0005\u001c7m\\;oiNDc\u0001AAA;\u000e5\u0012EAB\u0018\u0003\u001dyC/\u001a8b]RD#\u0002AB\u001a\u007f\u000e}21IB#!\u0011\u0019)da\u000f\u000e\u0005\r]\"bAB\u001dI\u0006A1/Z2ve&$\u00180\u0003\u0003\u0004>\r]\"aE*fGV\u0014\u0018\u000e^=SKF,\u0018N]3nK:$\u0018EAB!\u0003\u0019y\u0007/\u001a8JI\u000611oY8qKNd#aa\u0012\"\u0005\r%\u0013AB8qK:LG\r")
public class TenantOwnersRoute
implements TenantRoute {
    private final CaseSystem caseSystem;
    private UserQueries userQueries;
    private LastModifiedRegistration lastModifiedRegistration;
    private String lastModifiedHeaderName;
    private ExecutionContext ec;
    private IdentityProvider userCache;
    private IdentityProvider uc;
    private volatile AuthenticatedRoute$OIDCAuthentication$ OIDCAuthentication$module;
    private CorsSettings org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings;
    private RejectionHandler org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler;
    private Directive<BoxedUnit> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors;
    private Function1<RequestContext, Future<RouteResult>> route;
    private Option<Function1<RequestContext, Future<RouteResult>>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes;
    private String prefix;
    private boolean addToSwaggerRoutes;
    private Buffer<Class<?>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Function1<RequestContext, Future<RouteResult>> tenantUser(Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return TenantRoute.tenantUser$(this, subRoute);
    }

    @Override
    public Future<TenantUser> getTenantUser(AuthenticatedUser user, String tenant, Option<String> lastModified) {
        return TenantRoute.getTenantUser$(this, user, tenant, lastModified);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> askTenant(TenantCommand command) {
        return TenantRoute.askTenant$(this, command);
    }

    @Override
    public Directive<Tuple1<Option<String>>> readLastModifiedHeader() {
        return QueryRoute.readLastModifiedHeader$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> runXMLQuery(Function0<Future<CaseDefinitionDocument>> future) {
        return QueryRoute.runXMLQuery$(this, future);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> handleXMLResult(Function0<Future<CaseDefinitionDocument>> future) {
        return QueryRoute.handleXMLResult$(this, future);
    }

    @Override
    public <T extends CafienneJson> Function1<RequestContext, Future<RouteResult>> runQuery(Function0<Future<T>> future) {
        return QueryRoute.runQuery$(this, future);
    }

    @Override
    public <T extends CafienneJson> Function1<RequestContext, Future<RouteResult>> runListQuery(Function0<Future<scala.collection.immutable.Seq<T>>> future) {
        return QueryRoute.runListQuery$(this, future);
    }

    @Override
    public <T extends CafienneJson> Function1<RequestContext, Future<RouteResult>> handleQueryResult(Function0<Future<T>> future) {
        return QueryRoute.handleQueryResult$(this, future);
    }

    @Override
    public <T extends CafienneJson> Function1<RequestContext, Future<RouteResult>> handleQueryResultList(Function0<Future<scala.collection.immutable.Seq<T>>> future) {
        return QueryRoute.handleQueryResultList$(this, future);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> handleFailure(Throwable t) {
        return QueryRoute.handleFailure$(this, t);
    }

    @Override
    public <A> Future<A> runSyncedQuery(Function0<Future<A>> query, Option<String> lastModified) {
        return QueryRoute.runSyncedQuery$(this, query, lastModified);
    }

    @Override
    public <A> Option<String> runSyncedQuery$default$2() {
        return QueryRoute.runSyncedQuery$default$2$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> askModelActor(ModelCommand command) {
        return CommandRoute.askModelActor$(this, command);
    }

    @Override
    public ExceptionHandler exceptionHandler() {
        return AuthenticatedRoute.exceptionHandler$(this);
    }

    @Override
    @Deprecated
    public Function1<RequestContext, Future<RouteResult>> optionalUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.optionalUser$(this, subRoute);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> authenticatedUser(Function1<AuthenticatedUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.authenticatedUser$(this, subRoute);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> validUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.validUser$(this, subRoute);
    }

    @Override
    public void caseSystemMustBeHealthy() {
        AuthenticatedRoute.caseSystemMustBeHealthy$(this);
    }

    @Override
    public RejectionHandler requestServiceRejectionHandler() {
        return CaseServiceRoute.requestServiceRejectionHandler$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> defaultExceptionHandler(Throwable t) {
        return CaseServiceRoute.defaultExceptionHandler$(this, t);
    }

    @Override
    public Directive<BoxedUnit> writeLastModifiedHeader(ModelResponse response, String headerName) {
        return CaseServiceRoute.writeLastModifiedHeader$(this, response, headerName);
    }

    @Override
    public String writeLastModifiedHeader$default$2() {
        return CaseServiceRoute.writeLastModifiedHeader$default$2$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> completeCafienneJSONSeq(scala.collection.immutable.Seq<CafienneJson> seq) {
        return CaseServiceRoute.completeCafienneJSONSeq$(this, seq);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> completeJsonValue(Value<?> v) {
        return CaseServiceRoute.completeJsonValue$(this, v);
    }

    @Override
    public void addSubRoute(CaseServiceRoute subRoute) {
        CaseServiceRoute.addSubRoute$(this, subRoute);
    }

    @Override
    public scala.collection.immutable.Seq<Class<?>> apiClasses() {
        return CaseServiceRoute.apiClasses$(this);
    }

    @Override
    public void registerAPIRoute(CaseServiceRoute route) {
        CaseServiceRoute.registerAPIRoute$(this, route);
    }

    @Override
    public UserQueries userQueries() {
        return this.userQueries;
    }

    @Override
    public LastModifiedRegistration lastModifiedRegistration() {
        return this.lastModifiedRegistration;
    }

    @Override
    public String lastModifiedHeaderName() {
        return this.lastModifiedHeaderName;
    }

    @Override
    public void org$cafienne$service$akkahttp$tenant$route$TenantRoute$_setter_$userQueries_$eq(UserQueries x$1) {
        this.userQueries = x$1;
    }

    @Override
    public void org$cafienne$service$akkahttp$tenant$route$TenantRoute$_setter_$lastModifiedRegistration_$eq(LastModifiedRegistration x$1) {
        this.lastModifiedRegistration = x$1;
    }

    @Override
    public void org$cafienne$service$akkahttp$tenant$route$TenantRoute$_setter_$lastModifiedHeaderName_$eq(String x$1) {
        this.lastModifiedHeaderName = x$1;
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$QueryRoute$_setter_$ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$QueryRoute$_setter_$lastModifiedHeaderName_$eq(String x$1) {
    }

    @Override
    public IdentityProvider userCache() {
        return this.userCache;
    }

    @Override
    public IdentityProvider uc() {
        return this.uc;
    }

    @Override
    public AuthenticatedRoute$OIDCAuthentication$ OIDCAuthentication() {
        if (this.OIDCAuthentication$module == null) {
            this.OIDCAuthentication$lzycompute$1();
        }
        return this.OIDCAuthentication$module;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$AuthenticatedRoute$_setter_$userCache_$eq(IdentityProvider x$1) {
        this.userCache = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$AuthenticatedRoute$_setter_$uc_$eq(IdentityProvider x$1) {
        this.uc = x$1;
    }

    @Override
    public CorsSettings org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings;
    }

    @Override
    public RejectionHandler org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler;
    }

    @Override
    public Directive<BoxedUnit> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    @Override
    public Option<Function1<RequestContext, Future<RouteResult>>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes_$eq(Option<Function1<RequestContext, Future<RouteResult>>> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes = x$1;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public boolean addToSwaggerRoutes() {
        return this.addToSwaggerRoutes;
    }

    @Override
    public Buffer<Class<?>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings_$eq(CorsSettings x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler_$eq(RejectionHandler x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors_$eq(Directive<BoxedUnit> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$route_$eq(Function1<RequestContext, Future<RouteResult>> x$1) {
        this.route = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$prefix_$eq(String x$1) {
        this.prefix = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$addToSwaggerRoutes_$eq(boolean x$1) {
        this.addToSwaggerRoutes = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses_$eq(Buffer<Class<?>> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses = x$1;
    }

    private Logger logger$lzycompute() {
        TenantOwnersRoute tenantOwnersRoute = this;
        synchronized (tenantOwnersRoute) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> routes() {
        return Directives$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{this.getTenantOwners(), this.setUser(), this.putUser(), this.removeUser(), this.createConsentGroup(), this.setTenant(), this.putTenant(), this.getDisabledUserAccounts()}));
    }

    @Path(value="/{tenant}/owners")
    @GET
    @Operation(summary="Get tenant owners", description="Retrieves the list of tenant owners", tags={"tenant"}, parameters={@Parameter(name="tenant", description="The tenant to retrieve owners from", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(responseCode="204", description="List of user ids of that are owner of the tenant", content={@Content(schema=@Schema(implementation=Set.class))}), @ApiResponse(responseCode="404", description="Tenant not found")})
    @Produces(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> getTenantOwners() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> this.tenantUser((Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)tenantOwner -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("owners"))).apply((Function0 & Serializable)() -> this.askTenant(new GetTenantOwners((TenantUser)tenantOwner, tenantOwner.tenant())))));
    }

    @Path(value="/{tenant}")
    @POST
    @Operation(summary="Replace the tenant", description="Replace the existing tenant users. Existing user-accounts not in the new list will disabled. New users in the list will be added, others will have their properties and roles replaced with the new information", tags={"tenant"}, parameters={@Parameter(name="tenant", description="The tenant in which to replace the information", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Tenant replaced successfully", responseCode="204"), @ApiResponse(description="Tenant information is invalid", responseCode="400")})
    @RequestBody(description="Users to update", required=true, content={@Content(schema=@Schema(implementation=TenantAPI.ReplaceTenantFormat.class))})
    @Consumes(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> setTenant() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> this.replaceTenant());
    }

    public Function1<RequestContext, Future<RouteResult>> putTenant() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.put()).apply((Function0 & Serializable)() -> this.replaceTenant());
    }

    private Function1<RequestContext, Future<RouteResult>> replaceTenant() {
        return this.tenantUser((Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)tenantOwner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(TenantAPI$.MODULE$.replaceTenantReader()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)newTenantInformation -> {
            scala.collection.immutable.Seq users = (scala.collection.immutable.Seq)newTenantInformation.users().map((Function1 & Serializable)user -> user.asTenantUser(tenantOwner.tenant()));
            return this.askTenant(new ReplaceTenant((TenantUser)tenantOwner, tenantOwner.tenant(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)users).asJava()));
        }));
    }

    @Path(value="/{tenant}/users")
    @POST
    @Operation(summary="Add or replace a tenant user", description="Replace the properties and roles of a tenant user if it exists, otherwise creates a new user.", tags={"tenant"}, parameters={@Parameter(name="tenant", description="The tenant in which to add/update the user", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Tenant user registered successfully", responseCode="204"), @ApiResponse(description="Tenant user information is invalid", responseCode="400")})
    @RequestBody(description="User information", required=true, content={@Content(schema=@Schema(implementation=TenantAPI.UserFormat.class))})
    @Consumes(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> setUser() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> this.replaceUser());
    }

    public Function1<RequestContext, Future<RouteResult>> putUser() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.put()).apply((Function0 & Serializable)() -> this.replaceUser());
    }

    public Function1<RequestContext, Future<RouteResult>> replaceUser() {
        return this.tenantUser((Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)tenantOwner -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("users"))).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(TenantAPI$.MODULE$.userReader()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)newUser -> this.askTenant(new SetTenantUser((TenantUser)tenantOwner, tenantOwner.tenant(), newUser.asTenantUser(tenantOwner.tenant()))))));
    }

    @Path(value="/{tenant}/users/{userId}")
    @DELETE
    @Operation(summary="Remove a tenant user", description="Removes the user from the tenant (if it exists and is not the last owner)", tags={"tenant"}, parameters={@Parameter(name="tenant", description="The tenant from which to remove the user", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true), @Parameter(name="userId", description="The id of the user", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Tenant user removed successfully", responseCode="204"), @ApiResponse(description="Tenant user information is invalid", responseCode="400")})
    public Function1<RequestContext, Future<RouteResult>> removeUser() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.delete()).apply((Function0 & Serializable)() -> this.tenantUser((Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)tenantOwner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("users").$div((PathMatcher)Directives$.MODULE$.Segment(), TupleOps.Join$.MODULE$.join0P())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)userId -> this.askTenant(new RemoveTenantUser((TenantUser)tenantOwner, tenantOwner.tenant(), (String)userId)))));
    }

    @Path(value="/{tenant}/consent-groups")
    @POST
    @Operation(summary="Create a consent group", description="Register a new consent group in a tenant; the group must have members, and at least one member must be owner.", tags={"tenant"}, parameters={@Parameter(name="tenant", description="The tenant to retrieve accounts from", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Consent group updated successfully", responseCode="204"), @ApiResponse(responseCode="404", description="Consent group not found")})
    @RequestBody(description="Group to create", required=true, content={@Content(schema=@Schema(implementation=ConsentGroupAPI.ConsentGroupFormat.class))})
    @Consumes(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> createConsentGroup() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> this.tenantUser((Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)tenantOwner -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("consent-groups"))).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(ConsentGroupAPI$.MODULE$.consentGroupReader()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)newGroup -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            if (!tenantOwner.isOwner()) {
                function1 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.Unauthorized(), (Function0 & Serializable)() -> "Only tenant owners can create consent groups", Marshaller$.MODULE$.StringMarshaller());
            } else {
                ConsentGroup group = newGroup.asGroup(tenantOwner.tenant());
                String x$1 = tenantOwner.id();
                String x$2 = tenantOwner.tenant();
                String x$3 = group.id();
                ConsentGroupUser groupOwner = new ConsentGroupUser(x$1, x$3, x$2);
                function1 = this.askModelActor(new CreateConsentGroup(groupOwner, group));
            }
            return function1;
        }))));
    }

    @Path(value="/{tenant}/disabled-accounts")
    @GET
    @Operation(summary="Get a list of disabled user accounts", description="Retrieves the list of disabled user accounts", tags={"tenant"}, parameters={@Parameter(name="tenant", description="The tenant to retrieve accounts from", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(responseCode="200", description="List of user accounts that have been disabled in the tenant", content={@Content(schema=@Schema(implementation=Set.class))}), @ApiResponse(responseCode="404", description="Tenant not found")})
    @Produces(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> getDisabledUserAccounts() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> this.tenantUser((Function1<TenantUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)tenantOwner -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("disabled-accounts"))).apply((Function0 & Serializable)() -> this.runListQuery((Function0 & Serializable)() -> this.userQueries().getDisabledTenantUserAccounts((TenantUser)tenantOwner)))));
    }

    private final void OIDCAuthentication$lzycompute$1() {
        TenantOwnersRoute tenantOwnersRoute = this;
        synchronized (tenantOwnersRoute) {
            if (this.OIDCAuthentication$module == null) {
                this.OIDCAuthentication$module = new AuthenticatedRoute$OIDCAuthentication$(this);
            }
        }
    }

    public TenantOwnersRoute(CaseSystem caseSystem) {
        this.caseSystem = caseSystem;
        LazyLogging.$init$((LazyLogging)this);
        CaseServiceRoute.$init$(this);
        AuthenticatedRoute.$init$(this);
        CommandRoute.$init$(this);
        QueryRoute.$init$(this);
        TenantRoute.$init$(this);
        Statics.releaseFence();
    }
}

