/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.system.bootstrap;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import org.cafienne.actormodel.identity.PlatformOwner;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.identity.TenantUser$;
import org.cafienne.actormodel.response.ActorExistsFailure;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.bootstrap.BootstrapFailure;
import org.cafienne.system.bootstrap.BootstrapFailure$;
import org.cafienne.tenant.actorapi.command.platform.CreateTenant;
import org.cafienne.tenant.actorapi.response.TenantResponse;
import scala.Function1;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BootstrapPlatformConfiguration$
implements LazyLogging {
    public static final BootstrapPlatformConfiguration$ MODULE$ = new BootstrapPlatformConfiguration$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        BootstrapPlatformConfiguration$ bootstrapPlatformConfiguration$ = this;
        synchronized (bootstrapPlatformConfiguration$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public void run(CaseSystem caseSystem) {
        try {
            ((IterableOps)this.findConfigFile().map((Function1 & Serializable)configFile -> MODULE$.parseConfigFile((File)configFile))).map((Function1 & Serializable)c -> MODULE$.sendCommand(caseSystem, (CreateTenant)c));
        }
        catch (BootstrapFailure b) {
            throw b;
        }
        catch (Throwable t) {
            throw new BootstrapFailure("Unexpected error while reading bootstrap configuration", t);
        }
    }

    private scala.collection.immutable.Seq<File> findConfigFile() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Checking presence of bootstrap configuration for the case system");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        scala.collection.immutable.Seq<String> bootstrapTenantConfFiles = Cafienne$.MODULE$.config().platform().bootstrapFile();
        if (bootstrapTenantConfFiles.nonEmpty()) {
            scala.collection.immutable.Seq files = (scala.collection.immutable.Seq)bootstrapTenantConfFiles.map((Function1 & Serializable)fileName -> {
                void var1_1;
                BoxedUnit boxedUnit;
                File configFile = new File((String)fileName);
                if (!configFile.exists()) {
                    BoxedUnit boxedUnit2;
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("Sleeping a bit, because file " + fileName + " seems to not (yet) exist");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    Thread.sleep(1000L);
                    if (!configFile.exists()) {
                        throw new BootstrapFailure("The configured bootstrap tenant file cannot be found at '" + configFile.getAbsolutePath() + "' (conf value: '" + fileName + "')", BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("Sleeping a bit helped, because file " + fileName + " now exists");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return var1_1;
            });
            return files;
        }
        String defaultTenant = Cafienne$.MODULE$.config().platform().defaultTenant();
        if (defaultTenant.isBlank()) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Default tenant is empty and bootstrap-file is not filled. Skipping bootstrap attempts");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        }
        File confFile = new File(defaultTenant + ".conf");
        if (confFile.exists()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{confFile}));
        }
        File jsonFile = new File(defaultTenant + ".json");
        if (jsonFile.exists()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{jsonFile}));
        }
        File ymlFile = new File(defaultTenant + ".yml");
        if (ymlFile.exists()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{ymlFile}));
        }
        File yamlFile = new File(defaultTenant + ".yaml");
        if (yamlFile.exists()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{yamlFile}));
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Skipping bootstrap tenant configuration for '{}', because a file '{}', '{}', '{}' or '{}' cannot be found", new Object[]{defaultTenant, confFile, jsonFile, ymlFile, yamlFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    private CreateTenant parseConfigFile(File configFile) {
        CreateTenant createTenant;
        BoxedUnit boxedUnit;
        String defaultTenant = Cafienne$.MODULE$.config().platform().defaultTenant();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Bootstrapping tenant '{}' from file {}", new Object[]{defaultTenant, configFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Config tenantConfig = ConfigFactory.parseFile((File)configFile);
        try {
            Seq seq;
            String tenantName = tenantConfig.getString("name");
            if (tenantConfig.hasPath("owners")) {
                BoxedUnit boxedUnit2;
                Buffer list = CollectionConverters$.MODULE$.ListHasAsScala(tenantConfig.getStringList("owners")).asScala();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Bootstrap tenant '{}' in file '{}' uses deprecated property 'owners = [{}]'. Use 'isOwner = true' inside the designated users instead.", new Object[]{tenantName, configFile.getName(), list.mkString("\"", "\", \"", "\"")});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                seq = list;
            } else {
                seq = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            }
            Seq ownerIds = seq;
            scala.collection.immutable.Seq users = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.ListHasAsScala(tenantConfig.getConfigList("users")).asScala().toSeq().map((Function1 & Serializable)user -> {
                String userId = user.getString("id");
                Set roles = MODULE$.readStringList((Config)user, "roles", MODULE$.readStringList$default$3()).toSet();
                String name = MODULE$.readStringOr((Config)user, "name", "");
                String email = MODULE$.readStringOr((Config)user, "email", "");
                boolean isOwner = MODULE$.readBooleanOr((Config)user, "isOwner", ownerIds.contains((Object)userId));
                String x$1 = userId;
                String x$2 = tenantName;
                Set x$3 = roles;
                String x$4 = name;
                String x$5 = email;
                boolean x$6 = isOwner;
                boolean x$7 = TenantUser$.MODULE$.apply$default$7();
                return new TenantUser(x$1, x$2, (Set<String>)x$3, x$6, x$4, x$5, x$7);
            });
            if (!users.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isOwner()))) {
                throw new BootstrapFailure("Bootstrap tenant '" + tenantName + "' misses a mandatory tenant owner. File " + configFile.getAbsolutePath(), BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
            }
            Seq undefinedOwners = (Seq)ownerIds.filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)BootstrapPlatformConfiguration$.$anonfun$parseConfigFile$3(users, id)));
            if (undefinedOwners.nonEmpty()) {
                BoxedUnit boxedUnit3;
                String msg = "Bootstrap tenant '" + tenantName + "' in file " + configFile.getAbsolutePath() + " mentions owner(s) [" + undefinedOwners.mkString("\"", "\", \"", "\"") + "], but corresponding users are not defined in the file.";
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("FATAL ERROR: " + msg);
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                throw new BootstrapFailure(msg, BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
            }
            PlatformOwner aPlatformOwner = (PlatformOwner)Cafienne$.MODULE$.config().platform().platformOwners().head();
            createTenant = new CreateTenant(aPlatformOwner, tenantName, tenantName, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)users).asJava());
        }
        catch (ConfigException c) {
            throw new BootstrapFailure("Bootstrap file " + configFile.getAbsolutePath() + " is invalid: " + c.getMessage(), c);
        }
        return createTenant;
    }

    private boolean readBooleanOr(Config config, String path, boolean defaultValue) {
        return config.hasPath(path) ? config.getBoolean(path) : defaultValue;
    }

    private String readStringOr(Config config, String path, String defaultValue) {
        return config.hasPath(path) ? config.getString(path) : defaultValue;
    }

    private scala.collection.immutable.Seq<String> readStringList(Config config, String path, scala.collection.immutable.Seq<String> defaultValue) {
        return config.hasPath(path) ? CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(path)).asScala().toSeq() : defaultValue;
    }

    private scala.collection.immutable.Seq<String> readStringList$default$3() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    private Future<BoxedUnit> sendCommand(CaseSystem caseSystem, CreateTenant bootstrapTenant) {
        ExecutionContextExecutor ec = caseSystem.system().dispatcher();
        return caseSystem.gateway().request(bootstrapTenant).map((Function1 & Serializable)x0$1 -> {
            BootstrapPlatformConfiguration$.$anonfun$sendCommand$1(bootstrapTenant, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ec);
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigFile$3(scala.collection.immutable.Seq users$1, String id) {
        return !((SeqOps)users$1.map((Function1 & Serializable)u -> u.id())).contains((Object)id);
    }

    public static final /* synthetic */ void $anonfun$sendCommand$1(CreateTenant bootstrapTenant$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof ActorExistsFailure) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Bootstrap tenant '{}' already exists; ignoring bootstrap info (even if it is updated)", (Object)bootstrapTenant$1.name);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof CommandFailure) {
            BoxedUnit boxedUnit;
            CommandFailure commandFailure = (CommandFailure)object;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Bootstrap tenant '" + bootstrapTenant$1.name + "' creation failed with an unexpected exception", (Object)commandFailure);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (object instanceof TenantResponse) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Completed creation of bootstrap tenant '{}'", (Object)bootstrapTenant$1.name);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (object instanceof ModelResponse) {
            BoxedUnit boxedUnit;
            ModelResponse modelResponse = (ModelResponse)object;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Unexpected response during creation of bootstrap tenant: " + modelResponse);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                throw throwable;
            }
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error("Unexpected response during creation of bootstrap tenant, of type " + object.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        }
    }

    private BootstrapPlatformConfiguration$() {
    }
}

