/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant.actorapi.command.platform;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.PlatformOwner;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.command.platform.PlatformTenantCommand;
import org.cafienne.tenant.actorapi.exception.TenantException;
import org.cafienne.tenant.actorapi.response.TenantResponse;

@Manifest
public class CreateTenant
extends PlatformTenantCommand
implements BootstrapMessage {
    public final String name;
    private final List<TenantUser> users;

    public CreateTenant(PlatformOwner platformOwner, String string, String string2, List<TenantUser> list) {
        super(platformOwner, string);
        this.name = string2;
        this.users = list;
        super.validateUserList(list);
    }

    public CreateTenant(ValueMap valueMap) {
        super(valueMap);
        this.name = valueMap.readString((Object)Fields.name, new String[0]);
        this.users = valueMap.readObjects((Object)Fields.users, TenantUser::deserialize);
    }

    @Override
    public String tenant() {
        return this.name;
    }

    @Override
    public void validate(TenantActor tenantActor) throws InvalidCommandException {
        super.validate(tenantActor);
        if (tenantActor.exists()) {
            throw new TenantException("Tenant already exists");
        }
    }

    public TenantResponse process(TenantActor tenantActor) {
        tenantActor.createInstance(this.users);
        return new TenantResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.name, this.name);
        this.writeListField(jsonGenerator, (Object)Fields.users, this.users);
    }
}

