/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.cmmn.actorapi.command.platform.PlatformUpdate;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.event.TenantBaseEvent;

@Manifest
public class TenantAppliedPlatformUpdate
extends TenantBaseEvent
implements CommitEvent {
    public final PlatformUpdate newUserInformation;

    public TenantAppliedPlatformUpdate(TenantActor tenantActor, PlatformUpdate platformUpdate) {
        super(tenantActor);
        this.newUserInformation = platformUpdate;
    }

    public TenantAppliedPlatformUpdate(ValueMap valueMap) {
        super(valueMap);
        this.newUserInformation = PlatformUpdate.deserialize(valueMap.withArray((Object)Fields.users));
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " on " + this.newUserInformation.info().size() + " users";
    }

    @Override
    public void updateState(TenantActor tenantActor) {
        tenantActor.updateState(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeTenantEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.users, this.newUserInformation.toValue());
    }
}

