/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.Offset;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerCleared;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSet;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.infrastructure.cqrs.TaggedEventSource;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.health.HealthMonitor$;
import org.cafienne.timerservice.TimerService;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u001d4Aa\u0003\u0007\u0001'!A!\u0005\u0001BC\u0002\u0013\u00051\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003%\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u001di\u0003A1A\u0005B9Ba!\u000e\u0001!\u0002\u0013y\u0003\"\u0002\u001c\u0001\t\u0003:\u0004b\u0002%\u0001\u0005\u0004%\t%\u0013\u0005\u0007+\u0002\u0001\u000b\u0011\u0002&\t\u000bY\u0003A\u0011A,\t\u000b\t\u0004A\u0011A2\u0003\u001dQKW.\u001a:Fm\u0016tGoU5oW*\u0011QBD\u0001\ri&lWM]:feZL7-\u001a\u0006\u0003\u001fA\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003dcJ\u001c(BA\u0010\u000f\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!!\t\u000f\u0003#Q\u000bwmZ3e\u000bZ,g\u000e^*pkJ\u001cW-\u0001\u0007uS6,'oU3sm&\u001cW-F\u0001%!\t)c%D\u0001\r\u0013\t9CB\u0001\u0007US6,'oU3sm&\u001cW-A\u0007uS6,'oU3sm&\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003CA\u0013\u0001\u0011\u0015\u00113\u00011\u0001%\u0003)\u0019\u0017m]3TsN$X-\\\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!GD\u0001\u0007gf\u001cH/Z7\n\u0005Q\n$AC\"bg\u0016\u001c\u0016p\u001d;f[\u0006Y1-Y:f'f\u001cH/Z7!\u0003%9W\r^(gMN,G/F\u00019!\rIDHP\u0007\u0002u)\u00111HF\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u001f;\u0005\u00191U\u000f^;sKB\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0006cV,'/\u001f\u0006\u0003\u0007\u0012\u000b1\u0002]3sg&\u001cH/\u001a8dK*\tQ)\u0001\u0003bW.\f\u0017BA$A\u0005\u0019yeMZ:fi\u0006\u0019A/Y4\u0016\u0003)\u0003\"a\u0013*\u000f\u00051\u0003\u0006CA'\u0017\u001b\u0005q%BA(\u0013\u0003\u0019a$o\\8u}%\u0011\u0011KF\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R-\u0005!A/Y4!\u0003E\u0019wN\\:v[\u0016lu\u000eZ3m\u000bZ,g\u000e\u001e\u000b\u00031v\u00032!\u000f\u001fZ!\tQ6,D\u0001E\u0013\taFI\u0001\u0003E_:,\u0007\"\u00020\n\u0001\u0004y\u0016\u0001C3om\u0016dw\u000e]3\u0011\u0005m\u0001\u0017BA1\u001d\u0005Iiu\u000eZ3m\u000bZ,g\u000e^#om\u0016dw\u000e]3\u0002\u000bM$\u0018M\u001d;\u0015\u0003\u0011\u0004\"!F3\n\u0005\u00194\"\u0001B+oSR\u0004")
public class TimerEventSink
implements TaggedEventSource {
    private final TimerService timerService;
    private final CaseSystem caseSystem;
    private final String tag;
    private String configuredJournal;
    private String readJournalSetting;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Source<ModelEventEnvelope, NotUsed> taggedEvents() {
        return TaggedEventSource.taggedEvents$(this);
    }

    @Override
    public Source<EventEnvelope, NotUsed> restartableTaggedEventSourceFromLastKnownOffset() {
        return TaggedEventSource.restartableTaggedEventSourceFromLastKnownOffset$(this);
    }

    @Override
    public EventEnvelope reportHealth(EventEnvelope envelope) {
        return TaggedEventSource.reportHealth$(this, envelope);
    }

    @Override
    public boolean modelEventFilter(EventEnvelope element) {
        return TaggedEventSource.modelEventFilter$(this, element);
    }

    @Override
    public ActorSystem system() {
        return ReadJournalProvider.system$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    private String configuredJournal$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.configuredJournal$lzycompute() : this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.readJournalSetting$lzycompute() : this.readJournalSetting;
    }

    private Logger logger$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public TimerService timerService() {
        return this.timerService;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public Future<Offset> getOffset() {
        return this.timerService().storage.getOffset();
    }

    @Override
    public String tag() {
        return this.tag;
    }

    public Future<Done> consumeModelEvent(ModelEventEnvelope envelope) {
        Future<Done> future;
        ModelEvent modelEvent = envelope.event();
        if (modelEvent instanceof TimerSet) {
            BoxedUnit boxedUnit;
            TimerSet timerSet = (TimerSet)modelEvent;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{} on timer {} in case {} (triggering at {})", new Object[]{timerSet.getClass().getSimpleName(), timerSet.getTimerId(), timerSet.getActorId(), timerSet.getTargetMoment()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.timerService().monitor.addTimer(timerSet, envelope.offset());
        } else if (modelEvent instanceof TimerCleared) {
            BoxedUnit boxedUnit;
            TimerCleared timerCleared = (TimerCleared)modelEvent;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{} on timer {} in case {}", new Object[]{timerCleared.getClass().getSimpleName(), timerCleared.getTimerId(), timerCleared.getActorId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.timerService().monitor.removeTimer(timerCleared.getTimerId(), (Option<Offset>)new Some((Object)envelope.offset()));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Timer Service received an unexpected event of type {}", (Object)modelEvent.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    public void start() {
        ((Future)((Source)this.taggedEvents().mapAsync(1, (Function1 & Serializable)envelope -> this.consumeModelEvent((ModelEventEnvelope)envelope))).runWith((Graph)Sink$.MODULE$.ignore(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()))).onComplete((Function1 & Serializable)x0$1 -> {
            TimerEventSink.$anonfun$start$2(this, x0$1);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public static final /* synthetic */ void $anonfun$start$2(TimerEventSink $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("{} bumped into an issue that it cannot recover from: {}", new Object[]{$this.getClass().getSimpleName(), ex.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HealthMonitor$.MODULE$.readJournal().hasFailed(ex);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public TimerEventSink(TimerService timerService) {
        this.timerService = timerService;
        LazyLogging.$init$((LazyLogging)this);
        ReadJournalProvider.$init$(this);
        TaggedEventSource.$init$(this);
        this.caseSystem = timerService.caseSystem;
        this.tag = "cafienne:timer";
    }
}

