/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.concurrent.TimeUnit;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.cmmn.actorapi.command.plan.eventlistener.RaiseEvent;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.TimerService;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\f\u0018\u0001yA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005m!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b1\u0003A\u0011A'\t\u000fI\u0003!\u0019!C\u0001'\"1\u0011\r\u0001Q\u0001\nQCqA\u0019\u0001C\u0002\u0013\u00051\r\u0003\u0004k\u0001\u0001\u0006I\u0001\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0001d\u0011\u0019a\u0007\u0001)A\u0005I\"9Q\u000e\u0001b\u0001\n\u0003q\u0007B\u0002<\u0001A\u0003%q\u000eC\u0004x\u0001\t\u0007I\u0011\u0001=\t\rq\u0004\u0001\u0015!\u0003z\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002(\u0001!\t!!\u000b\u0003\u0011QKW.\u001a:K_\nT!\u0001G\r\u0002\u0019QLW.\u001a:tKJ4\u0018nY3\u000b\u0005iY\u0012\u0001C2bM&,gN\\3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0010(UA\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0005Y\u0006twMC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019\n#AB(cU\u0016\u001cG\u000f\u0005\u0002!Q%\u0011\u0011&\t\u0002\t%Vtg.\u00192mKB\u00111FM\u0007\u0002Y)\u0011QFL\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003_A\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002c\u0005\u00191m\\7\n\u0005Mb#a\u0003'bufdunZ4j]\u001e\fA\u0002^5nKJ\u001cVM\u001d<jG\u0016,\u0012A\u000e\t\u0003oaj\u0011aF\u0005\u0003s]\u0011A\u0002V5nKJ\u001cVM\u001d<jG\u0016\fQ\u0002^5nKJ\u001cVM\u001d<jG\u0016\u0004\u0013!\u0002;j[\u0016\u0014X#A\u001f\u0011\u0005]r\u0014BA \u0018\u0005\u0015!\u0016.\\3s\u0003\u0019!\u0018.\\3sA\u0005I1o\u00195fIVdWM]\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0006C\u000e$xN\u001d\u0006\u0002\u0011\u0006!\u0011m[6b\u0013\tQUIA\u0005TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011qu\nU)\u0011\u0005]\u0002\u0001\"\u0002\u001b\b\u0001\u00041\u0004\"B\u001e\b\u0001\u0004i\u0004\"B!\b\u0001\u0004\u0019\u0015aB2p[6\fg\u000eZ\u000b\u0002)B\u0011QkX\u0007\u0002-*\u0011q\u000bW\u0001\u000eKZ,g\u000e\u001e7jgR,g.\u001a:\u000b\u0005eS\u0016\u0001\u00029mC:T!AU.\u000b\u0005qk\u0016\u0001C1di>\u0014\u0018\r]5\u000b\u0005yK\u0012\u0001B2n[:L!\u0001\u0019,\u0003\u0015I\u000b\u0017n]3Fm\u0016tG/\u0001\u0005d_6l\u0017M\u001c3!\u0003\u0019i\u0017\u000e\u001c7jgV\tA\r\u0005\u0002fQ6\taMC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIgM\u0001\u0003M_:<\u0017aB7jY2L7\u000fI\u0001\u0006I\u0016d\u0017-_\u0001\u0007I\u0016d\u0017-\u001f\u0011\u0002\u0011\u0011,(/\u0019;j_:,\u0012a\u001c\t\u0003aRl\u0011!\u001d\u0006\u0003[JT!a\u001d4\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002vc\nqa)\u001b8ji\u0016$UO]1uS>t\u0017!\u00033ve\u0006$\u0018n\u001c8!\u0003!\u00198\r[3ek2,W#A=\u0011\u0005\u0011S\u0018BA>F\u0005-\u0019\u0015M\\2fY2\f'\r\\3\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0004\u0013a\u0001:v]R\tq\u0010E\u0002f\u0003\u0003I1!a\u0001g\u0005\u0011)f.\u001b;\u0002\r\r\fgnY3m)\t\tI\u0001E\u0002f\u0003\u0017I1!!\u0004g\u0005\u001d\u0011un\u001c7fC:\f1\u0004[1oI2,g)Y5mS:<7)Y:f\u0013:4xnY1uS>tGcA@\u0002\u0014!9\u0011Q\u0003\u000bA\u0002\u0005]\u0011a\u00024bS2,(/\u001a\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003!\u0011Xm\u001d9p]N,'bAA\u00113\u0005Q\u0011m\u0019;pe6|G-\u001a7\n\t\u0005\u0015\u00121\u0004\u0002\u000f\u0007>lW.\u00198e\r\u0006LG.\u001e:f\u0003QA\u0017M\u001c3mK\u000e\u000b7/Z%om>\u001c\u0017\r^5p]R\u0019q0a\u000b\t\u000f\u0005uQ\u00031\u0001\u0002.A!\u0011\u0011DA\u0018\u0013\u0011\t\t$a\u0007\u0003\u001b5{G-\u001a7SKN\u0004xN\\:f\u0001")
public class TimerJob
implements Runnable,
LazyLogging {
    private final TimerService timerService;
    private final Timer timer;
    private final Scheduler scheduler;
    private final RaiseEvent command;
    private final long millis;
    private final long delay;
    private final FiniteDuration duration;
    private final Cancellable schedule;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TimerJob timerJob = this;
        synchronized (timerJob) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public TimerService timerService() {
        return this.timerService;
    }

    public Timer timer() {
        return this.timer;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public RaiseEvent command() {
        return this.command;
    }

    public long millis() {
        return this.millis;
    }

    public long delay() {
        return this.delay;
    }

    public FiniteDuration duration() {
        return this.duration;
    }

    public Cancellable schedule() {
        return this.schedule;
    }

    @Override
    public void run() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Raising timer in case {} for timer {} on behalf of user {}", new Object[]{this.timer().caseInstanceId(), this.timer().timerId(), this.timer().userId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.timerService().askCase(this.command(), failure -> this.handleFailingCaseInvocation(failure), response -> this.handleCaseInvocation(response));
    }

    public boolean cancel() {
        return this.schedule().cancel();
    }

    public void handleFailingCaseInvocation(CommandFailure failure) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Could not trigger timer " + this.timer() + " in case " + this.timer().caseInstanceId() + ":" + failure.toJson());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleCaseInvocation(ModelResponse response) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Successfully invoked timer {} in case {}", new Object[]{this.timer(), this.timer().caseInstanceId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public TimerJob(TimerService timerService, Timer timer, Scheduler scheduler) {
        BoxedUnit boxedUnit;
        this.timerService = timerService;
        this.timer = timer;
        this.scheduler = scheduler;
        LazyLogging.$init$((LazyLogging)this);
        this.command = new RaiseEvent(timer.user(), timer.caseInstanceId(), timer.timerId());
        this.millis = timer.moment().toEpochMilli();
        this.delay = this.millis() - System.currentTimeMillis();
        this.duration = Duration$.MODULE$.create(this.delay(), TimeUnit.MILLISECONDS);
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Scheduling to run timer request {} in {}.{} seconds from now (at {})", new Object[]{timer.timerId(), BoxesRunTime.boxToLong((long)(this.duration().length() / 1000L)), BoxesRunTime.boxToLong((long)(this.duration().length() % 1000L)), timer.moment()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.schedule = scheduler.scheduleOnce(this.duration(), (Runnable)this, ExecutionContext.Implicits$.MODULE$.global());
    }
}

