/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import akka.Done;
import akka.actor.Scheduler;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSet;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.TimerJob;
import org.cafienne.timerservice.TimerService;
import org.cafienne.timerservice.TimerStorageReader;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\t\u0012\u0001aA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005W!)\u0001\u0007\u0001C\u0001c!9A\u0007\u0001b\u0001\n\u0013)\u0004B\u0002'\u0001A\u0003%a\u0007C\u0004N\u0001\t\u0007I1\u0001(\t\rU\u0003\u0001\u0015!\u0003P\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000b\u001d\u0004A\u0011\u00015\t\u000b1\u0004A\u0011A7\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\"\u0001\u0004+j[\u0016\u0014Xj\u001c8ji>\u0014(B\u0001\n\u0014\u00031!\u0018.\\3sg\u0016\u0014h/[2f\u0015\t!R#\u0001\u0005dC\u001aLWM\u001c8f\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0011*\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0019\n1aY8n\u0013\tA\u0013EA\u0006MCjLHj\\4hS:<\u0017\u0001\u0004;j[\u0016\u00148+\u001a:wS\u000e,W#A\u0016\u0011\u00051jS\"A\t\n\u00059\n\"\u0001\u0004+j[\u0016\u00148+\u001a:wS\u000e,\u0017!\u0004;j[\u0016\u00148+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003eM\u0002\"\u0001\f\u0001\t\u000b%\u001a\u0001\u0019A\u0016\u0002\u0019\u0005\u001cG/\u001b<f)&lWM]:\u0016\u0003Y\u0002Ba\u000e\u001f?\u00136\t\u0001H\u0003\u0002:u\u00059Q.\u001e;bE2,'BA\u001e\u001c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{a\u00121!T1q!\tydI\u0004\u0002A\tB\u0011\u0011iG\u0007\u0002\u0005*\u00111iF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015[\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!R\u000e\u0011\u00051R\u0015BA&\u0012\u0005!!\u0016.\\3s\u0015>\u0014\u0017!D1di&4X\rV5nKJ\u001c\b%\u0001\u0006eSN\u0004\u0018\r^2iKJ,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%n\t!bY8oGV\u0014(/\u001a8u\u0013\t!\u0016K\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006YA-[:qCR\u001c\u0007.\u001a:!\u0003%\u00198\r[3ek2,'/F\u0001Y!\tIf,D\u0001[\u0015\tYF,A\u0003bGR|'OC\u0001^\u0003\u0011\t7n[1\n\u0005}S&!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0007e\u0016\fG-\u001a:\u0016\u0003\r\u0004\"\u0001\f3\n\u0005\u0015\f\"A\u0005+j[\u0016\u00148\u000b^8sC\u001e,'+Z1eKJ\fqA]3bI\u0016\u0014\b%A\u0003ti\u0006\u0014H\u000fF\u0001j!\tQ\".\u0003\u0002l7\t!QK\\5u\u0003-\u0011X-\\8wKRKW.\u001a:\u0015\u00079,x\u000fE\u0002Q_FL!\u0001])\u0003\r\u0019+H/\u001e:f!\t\u00118/D\u0001]\u0013\t!HL\u0001\u0003E_:,\u0007\"\u0002<\u000e\u0001\u0004q\u0014a\u0002;j[\u0016\u0014\u0018\n\u001a\u0005\u0006q6\u0001\r!_\u0001\u0007_\u001a47/\u001a;\u0011\u0007iQH0\u0003\u0002|7\t1q\n\u001d;j_:\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005)\u0011/^3ss*\u0019\u00111\u0001/\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0004\u0003\u000fq(AB(gMN,G/\u0001\u0005bI\u0012$\u0016.\\3s)\u0015q\u0017QBA\u0016\u0011\u001d\tyA\u0004a\u0001\u0003#\tQ!\u001a<f]R\u0004B!a\u0005\u0002(5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0007fm\u0016tG\u000f\\5ti\u0016tWM\u001d\u0006\u0005\u00037\ti\"\u0001\u0003qY\u0006t'\u0002BA\b\u0003?QA!!\t\u0002$\u0005A\u0011m\u0019;pe\u0006\u0004\u0018NC\u0002\u0002&M\tAaY7n]&!\u0011\u0011FA\u000b\u0005!!\u0016.\\3s'\u0016$\b\"\u0002=\u000f\u0001\u0004a\u0018!D:dQ\u0016$W\u000f\\3US6,'\u000fF\u0002j\u0003cAq!a\r\u0010\u0001\u0004\t)$A\u0003uS6,'\u000fE\u0002-\u0003oI1!!\u000f\u0012\u0005\u0015!\u0016.\\3s\u0001")
public class TimerMonitor
implements LazyLogging {
    private final TimerService timerService;
    private final Map<String, TimerJob> activeTimers;
    private final ExecutionContext dispatcher;
    private final Scheduler scheduler;
    private final TimerStorageReader reader;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TimerMonitor timerMonitor = this;
        synchronized (timerMonitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public TimerService timerService() {
        return this.timerService;
    }

    private Map<String, TimerJob> activeTimers() {
        return this.activeTimers;
    }

    public ExecutionContext dispatcher() {
        return this.dispatcher;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public TimerStorageReader reader() {
        return this.reader;
    }

    public void start() {
        this.reader().loadNextWindow();
        FiniteDuration interval = Cafienne$.MODULE$.config().engine().timerService().interval();
        this.scheduler().scheduleAtFixedRate(interval, interval, (Runnable)this.reader(), this.dispatcher());
    }

    public Future<Done> removeTimer(String timerId, Option<Offset> offset) {
        this.activeTimers().remove((Object)timerId).map((Function1 & Serializable)schedule -> BoxesRunTime.boxToBoolean((boolean)schedule.cancel()));
        return this.timerService().storage.removeTimer(timerId, offset);
    }

    public Future<Done> addTimer(TimerSet event, Offset offset) {
        Timer job = new Timer(event.getCaseInstanceId(), event.getTimerId(), event.getTargetMoment(), event.getUser().id());
        if (this.reader().fitsActiveWindow(job)) {
            this.scheduleTimer(job);
        }
        return this.timerService().storage.storeTimer(job, (Option<Offset>)new Some((Object)offset));
    }

    public void scheduleTimer(Timer timer) {
        this.activeTimers().getOrElseUpdate((Object)timer.timerId(), (Function0 & Serializable)() -> new TimerJob(this.timerService(), timer, this.scheduler()));
    }

    public TimerMonitor(TimerService timerService) {
        this.timerService = timerService;
        LazyLogging.$init$((LazyLogging)this);
        this.activeTimers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dispatcher = timerService.caseSystem.system().dispatcher();
        this.scheduler = timerService.caseSystem.system().scheduler();
        this.reader = new TimerStorageReader(this);
    }
}

