/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice.persistence;

import akka.actor.ActorSystem;
import akka.persistence.cassandra.query.scaladsl.CassandraReadJournal;
import akka.persistence.jdbc.query.scaladsl.JdbcReadJournal;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.system.CaseSystem;
import org.cafienne.timerservice.persistence.TimerStore;
import org.cafienne.timerservice.persistence.cassandra.CassandraTimerStore;
import org.cafienne.timerservice.persistence.inmemory.InMemoryStore;
import org.cafienne.timerservice.persistence.jdbc.JDBCTimerStore;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005M2AAB\u0004\u0001!!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\"\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u001di\u0003A1A\u0005\u00029BaA\r\u0001!\u0002\u0013y#A\u0005+j[\u0016\u00148\u000b^8sKB\u0013xN^5eKJT!\u0001C\u0005\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u0015-\tA\u0002^5nKJ\u001cXM\u001d<jG\u0016T!\u0001D\u0007\u0002\u0011\r\fg-[3o]\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!1-\u001d:t\u0015\ta2\"\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005yI\"a\u0005*fC\u0012Tu.\u001e:oC2\u0004&o\u001c<jI\u0016\u0014\u0018AC2bg\u0016\u001c\u0016p\u001d;f[V\t\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%\u0017\u000511/_:uK6L!AJ\u0012\u0003\u0015\r\u000b7/Z*zgR,W.A\u0006dCN,7+_:uK6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002+YA\u00111\u0006A\u0007\u0002\u000f!)qd\u0001a\u0001C\u0005)1\u000f^8sKV\tq\u0006\u0005\u0002,a%\u0011\u0011g\u0002\u0002\u000b)&lWM]*u_J,\u0017AB:u_J,\u0007\u0005")
public class TimerStoreProvider
implements ReadJournalProvider {
    private final CaseSystem caseSystem;
    private final TimerStore store;
    private String configuredJournal;
    private String readJournalSetting;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public ActorSystem system() {
        return ReadJournalProvider.system$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    private String configuredJournal$lzycompute() {
        TimerStoreProvider timerStoreProvider = this;
        synchronized (timerStoreProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.configuredJournal$lzycompute() : this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        TimerStoreProvider timerStoreProvider = this;
        synchronized (timerStoreProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.readJournalSetting$lzycompute() : this.readJournalSetting;
    }

    private Logger logger$lzycompute() {
        TimerStoreProvider timerStoreProvider = this;
        synchronized (timerStoreProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    public TimerStore store() {
        return this.store;
    }

    public TimerStoreProvider(CaseSystem caseSystem) {
        TimerStore timerStore;
        this.caseSystem = caseSystem;
        LazyLogging.$init$((LazyLogging)this);
        ReadJournalProvider.$init$(this);
        CurrentPersistenceIdsQuery currentPersistenceIdsQuery = this.journal();
        if (currentPersistenceIdsQuery instanceof CassandraReadJournal) {
            CassandraReadJournal cassandraReadJournal = (CassandraReadJournal)currentPersistenceIdsQuery;
            timerStore = new CassandraTimerStore(cassandraReadJournal);
        } else {
            timerStore = currentPersistenceIdsQuery instanceof JdbcReadJournal ? new JDBCTimerStore() : new InMemoryStore();
        }
        this.store = timerStore;
    }
}

