/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import akka.actor.Cancellable;
import akka.actor.Scheduler;
import java.util.HashMap;
import java.util.Map;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.util.Guid;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class CaseScheduler {
    private final ModelActor actor;
    private final Scheduler akkaScheduler;
    private final Map<String, Cancellable> jobs = new HashMap<String, Cancellable>();
    private int i = 0;

    CaseScheduler(ModelActor modelActor) {
        this.actor = modelActor;
        this.akkaScheduler = modelActor.getContext().system().scheduler();
    }

    public void clearSchedules() {
        this.jobs.values().forEach(Cancellable::cancel);
        this.jobs.clear();
    }

    public Cancellable schedule(FiniteDuration finiteDuration, Runnable runnable) {
        int n = this.i++;
        final String string = new Guid().toString();
        Runnable runnable2 = () -> {
            this.jobs.remove(string);
            runnable.run();
        };
        final Cancellable cancellable = this.akkaScheduler.scheduleOnce(finiteDuration, runnable2, (ExecutionContext)this.actor.context().system().dispatcher());
        this.jobs.put(string, cancellable);
        return new Cancellable(){

            public boolean cancel() {
                CaseScheduler.this.jobs.remove(string);
                return cancellable.cancel();
            }

            public boolean isCancelled() {
                return cancellable.isCancelled();
            }
        };
    }

    public void println(String string) {
    }
}

