/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import akka.persistence.JournalProtocol;
import akka.persistence.SnapshotProtocol;
import org.cafienne.actormodel.BackOffice;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.RecoveryRoom;
import org.cafienne.actormodel.Warehouse;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.actormodel.response.ActorChokedFailure;
import org.cafienne.actormodel.response.ActorExistsFailure;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.infrastructure.serialization.DeserializationFailure;

class Reception {
    private boolean bootstrapPending = true;
    private final ModelActor actor;
    private boolean isBroken = false;
    private final RecoveryRoom recoveryRoom;
    private final BackOffice backoffice;
    final Warehouse warehouse;

    Reception(ModelActor modelActor) {
        this.actor = modelActor;
        this.recoveryRoom = new RecoveryRoom(modelActor, this);
        this.backoffice = new BackOffice(modelActor, this);
        this.warehouse = new Warehouse(modelActor);
    }

    void handleRecovery(Object object) {
        if (this.isBroken()) {
            return;
        }
        this.recoveryRoom.handleRecovery(object);
    }

    void handleMessage(Object object) {
        if (object instanceof IncomingActorMessage) {
            IncomingActorMessage incomingActorMessage = (IncomingActorMessage)object;
            if (incomingActorMessage.isResponse() || this.canPass(incomingActorMessage.asCommand())) {
                this.backoffice.handleVisitor(incomingActorMessage);
            }
        } else if (object instanceof SnapshotProtocol.Message) {
            this.actor.handleSnapshotProtocolMessage((SnapshotProtocol.Message)object);
        } else if (object instanceof JournalProtocol.Message) {
            this.actor.handleJournalProtocolMessage((JournalProtocol.Message)object);
        } else {
            this.actor.getLogger().warn(this.actor + " received a message it cannot handle, of type " + object.getClass().getName());
        }
    }

    private boolean canPass(ModelCommand modelCommand) {
        modelCommand.setActor(this.actor);
        if (this.isBroken()) {
            return this.informAboutRecoveryFailure(modelCommand);
        }
        if (!this.bootstrapPending && modelCommand.isBootstrapMessage()) {
            this.handleAlreadyCreated(modelCommand);
            return false;
        }
        if (this.bootstrapPending) {
            if (modelCommand.isBootstrapMessage()) {
                this.actor.handleBootstrapMessage(modelCommand.asBootstrapMessage());
            } else {
                this.fail(modelCommand, "Expected bootstrap command in " + this.actor + " instead of " + modelCommand.getClass().getSimpleName());
                return false;
            }
        }
        if (!this.actor.supportsCommand(modelCommand)) {
            this.fail(modelCommand, this.actor + " does not support commands of type " + modelCommand.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    void unlock() {
        this.bootstrapPending = false;
    }

    private void hideFrontdoor(String string) {
        this.isBroken = true;
        this.actor.getLogger().warn("Aborting recovery of " + this.actor + ". " + string);
    }

    private boolean isBroken() {
        return this.isBroken;
    }

    private boolean informAboutRecoveryFailure(IncomingActorMessage incomingActorMessage) {
        if (incomingActorMessage.isCommand()) {
            if (incomingActorMessage.isBootstrapMessage()) {
                this.handleAlreadyCreated(incomingActorMessage);
            } else {
                String string = this.actor + " cannot handle message '" + incomingActorMessage.getClass().getSimpleName() + "' because it has not recovered properly. Check the server logs for more details.";
                this.actor.reply(new ActorChokedFailure(incomingActorMessage.asCommand(), new InvalidCommandException(string)));
            }
            this.actor.takeABreak("Removing ModelActor[" + this.actor.getId() + "] because of recovery failure upon unexpected incoming message of type " + incomingActorMessage.getClass().getSimpleName());
        }
        return false;
    }

    private void handleAlreadyCreated(IncomingActorMessage incomingActorMessage) {
        if (incomingActorMessage.isCommand()) {
            this.actor.reply(new ActorExistsFailure(incomingActorMessage.asCommand(), new IllegalArgumentException("Failure while handling message " + incomingActorMessage.getClass().getSimpleName() + ". Check the server logs for more details")));
        }
    }

    private void fail(ModelCommand modelCommand, String string) {
        this.actor.reply(new CommandFailure(modelCommand, new InvalidCommandException(string)));
    }

    void reportDeserializationFailure(DeserializationFailure deserializationFailure) {
        this.hideFrontdoor("" + deserializationFailure);
    }

    void reportInvalidRecoveryEvent(ModelEvent modelEvent) {
        if (modelEvent.isBootstrapMessage()) {
            this.hideFrontdoor("Recovery event " + modelEvent.getClass().getSimpleName() + " requires an actor of type " + modelEvent.actorClass().getSimpleName());
        } else {
            this.hideFrontdoor("Received unexpected recovery event of type " + modelEvent.getClass().getName());
        }
    }

    void reportStateUpdateFailure(Throwable throwable) {
        this.actor.getLogger().error("Unexpected error during recovery of " + this.actor, throwable);
        this.hideFrontdoor("Updating actor state failed.");
    }

    void open() {
        this.actor.recoveryCompleted();
    }
}

