/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import akka.persistence.RecoveryCompleted;
import akka.persistence.SnapshotOffer;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.Reception;
import org.cafienne.actormodel.event.DebugEvent;
import org.cafienne.actormodel.event.EngineVersionChanged;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.infrastructure.serialization.DeserializationFailure;

class RecoveryRoom {
    private final ModelActor actor;
    private final Reception reception;

    RecoveryRoom(ModelActor modelActor, Reception reception) {
        this.actor = modelActor;
        this.reception = reception;
        if (modelActor.getLogger().isDebugEnabled()) {
            modelActor.getLogger().debug("Opening recovery of " + modelActor);
        }
    }

    void handleRecovery(Object object) {
        if (object instanceof SnapshotOffer) {
            this.actor.handleSnapshot((SnapshotOffer)object);
        } else if (object instanceof ModelEvent) {
            ModelEvent modelEvent = (ModelEvent)object;
            this.actor.setCurrentUser(modelEvent.getUser());
            if (!(modelEvent instanceof DebugEvent)) {
                if (this.actor.supportsEvent(modelEvent) || modelEvent instanceof EngineVersionChanged) {
                    this.recoverEvent(modelEvent);
                } else {
                    this.reception.reportInvalidRecoveryEvent(modelEvent);
                }
            }
        } else if (object instanceof DeserializationFailure) {
            this.reception.reportDeserializationFailure((DeserializationFailure)object);
        } else if (object instanceof RecoveryCompleted) {
            if (this.actor.getLogger().isDebugEnabled()) {
                this.actor.getLogger().debug(this.actor + " completed recovery");
            }
            this.reception.open();
        } else {
            this.actor.getLogger().warn(this.actor + " received unknown message of type " + object.getClass().getName() + " during recovery: " + object);
        }
    }

    private void recoverEvent(ModelEvent modelEvent) {
        if (modelEvent.isBootstrapMessage()) {
            this.actor.handleBootstrapMessage(modelEvent.asBootstrapMessage());
        }
        if (this.actor.getLogger().isDebugEnabled()) {
            this.actor.getLogger().debug("Recovering event " + this.actor + ".[" + this.actor.lastSequenceNr() + "].[" + modelEvent.getTimestamp().toString().substring(0, 23) + "].[" + modelEvent.getClass().getSimpleName() + "]");
        }
        try {
            modelEvent.updateActorState(this.actor);
            if (modelEvent.isBootstrapMessage()) {
                this.reception.unlock();
            }
        }
        catch (Throwable throwable) {
            this.reception.reportStateUpdateFailure(throwable);
        }
    }
}

