/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.BaseModelEvent;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class ActorModified
extends BaseModelEvent<ModelActor>
implements CommitEvent {
    public final String source;
    public final Instant lastModified;

    protected ActorModified(ModelActor modelActor, IncomingActorMessage incomingActorMessage) {
        super(modelActor);
        this.source = incomingActorMessage.getClass().getName();
        this.lastModified = modelActor.getTransactionTimestamp();
    }

    protected ActorModified(ValueMap valueMap) {
        super(valueMap);
        this.lastModified = valueMap.readInstant((Object)Fields.lastModified, new Instant[0]);
        this.source = valueMap.readString((Object)Fields.source, "unknown message");
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + " upon " + this.source;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeActorModified(jsonGenerator);
    }

    @Override
    public void updateState(ModelActor modelActor) {
        modelActor.setLastModified(this.lastModified());
    }

    public void writeActorModified(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.lastModified, this.lastModified);
        this.writeField(jsonGenerator, (Object)Fields.source, this.source);
    }
}

