/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.response;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.exception.SerializedException;
import org.cafienne.actormodel.response.BaseModelResponse;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

@Manifest
public class CommandFailure
extends BaseModelResponse {
    private final Throwable exception;
    private final SerializedException serializedException;
    private final ValueMap exceptionAsJSON;

    public CommandFailure(ModelCommand modelCommand, Throwable throwable) {
        super(modelCommand);
        this.exception = throwable;
        this.exceptionAsJSON = Value.convertThrowable(throwable);
        this.serializedException = new SerializedException(throwable);
    }

    public CommandFailure(ValueMap valueMap) {
        super(valueMap);
        this.exception = null;
        this.exceptionAsJSON = valueMap.readMap((Object)Fields.exception);
        this.serializedException = new SerializedException(this.exceptionAsJSON);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.exception, this.exceptionAsJSON);
    }

    public Throwable internalException() {
        return this.exception;
    }

    public ValueMap toJson() {
        return this.exceptionAsJSON;
    }

    public SerializedException exception() {
        return this.serializedException;
    }

    @Override
    public String toString() {
        return this.exceptionAsJSON.toString();
    }
}

