/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.authentication;

import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.cafienne.authentication.AuthenticatedUser;
import org.cafienne.authentication.CannotReachIDPException;
import org.cafienne.authentication.InvalidIssuerException;
import org.cafienne.authentication.MissingClaimsException;
import org.cafienne.authentication.MissingTokenException$;
import org.cafienne.authentication.MultiIssuerJWSKeySelector;
import org.cafienne.authentication.TokenVerificationException;
import org.cafienne.authentication.TokenVerificationException$;
import org.cafienne.authentication.TokenVerifier;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005a3AAB\u0004\u0001\u001d!Aa\u0005\u0001B\u0001B\u0003-q\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00043\u0001\t\u0007I\u0011A\u001a\t\r\u0015\u0003\u0001\u0015!\u00035\u0011\u00151\u0005\u0001\"\u0011H\u0005AQu\u000f\u001e+pW\u0016tg+\u001a:jM&,'O\u0003\u0002\t\u0013\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'B\u0001\u0006\f\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001yQ\u0003\b\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Y9\u0012$D\u0001\b\u0013\tArAA\u0007U_.,gNV3sS\u001aLWM\u001d\t\u0003-iI!aG\u0004\u0003#\u0005+H\u000f[3oi&\u001c\u0017\r^3e+N,'\u000f\u0005\u0002\u001eI5\taD\u0003\u0002 A\u0005a1oY1mC2|wmZ5oO*\u0011\u0011EI\u0001\tif\u0004Xm]1gK*\t1%A\u0002d_6L!!\n\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0003K\u000e\u0004\"\u0001K\u0016\u000e\u0003%R!AK\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002-S\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\"\"\u0001M\u0019\u0011\u0005Y\u0001\u0001\"\u0002\u0014\u0003\u0001\b9\u0013\u0001\u00046xiB\u0013xnY3tg>\u0014X#\u0001\u001b\u0011\u0007Ubd(D\u00017\u0015\t9\u0004(\u0001\u0003qe>\u001c'BA\u001d;\u0003\rQw\u000f\u001e\u0006\u0003w\t\n\u0001B\\5nEV\u001cHm]\u0005\u0003{Y\u0012\u0001dQ8oM&<WO]1cY\u0016Tu\u000b\u0016)s_\u000e,7o]8s!\ty4)D\u0001A\u0015\t9\u0014I\u0003\u0002Cu\u0005!!n\\:f\u0013\t!\u0005IA\bTK\u000e,(/\u001b;z\u0007>tG/\u001a=u\u00035Qw\u000f\u001e)s_\u000e,7o]8sA\u0005Ya/\u001a:jMf$vn[3o)\tA5\nE\u0002)\u0013fI!AS\u0015\u0003\r\u0019+H/\u001e:f\u0011\u0015aU\u00011\u0001N\u0003\u0015!xn[3o!\tqUK\u0004\u0002P'B\u0011\u0001+E\u0007\u0002#*\u0011!+D\u0001\u0007yI|w\u000e\u001e \n\u0005Q\u000b\u0012A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V\t")
public class JwtTokenVerifier
implements TokenVerifier<AuthenticatedUser>,
LazyLogging {
    private final ExecutionContext ec;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        JwtTokenVerifier jwtTokenVerifier = this;
        synchronized (jwtTokenVerifier) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ConfigurableJWTProcessor<SecurityContext> jwtProcessor() {
        return this.jwtProcessor;
    }

    @Override
    public Future<AuthenticatedUser> verifyToken(String token) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            AuthenticatedUser authenticatedUser;
            None$ claimsSet = None$.MODULE$;
            if (token.isEmpty()) {
                throw MissingTokenException$.MODULE$;
            }
            try {
                SecurityContext ctx = null;
                claimsSet = new Some((Object)this.jwtProcessor().process(token, ctx));
                authenticatedUser = (AuthenticatedUser)claimsSet.fold((Function0 & Serializable)() -> {
                    throw new TokenVerificationException("Unable to create claimSet for " + token);
                }, (Function1 & Serializable)cS -> {
                    HealthMonitor$.MODULE$.idp().isOK();
                    return new AuthenticatedUser(token, (JWTClaimsSet)cS);
                });
            }
            catch (RemoteKeySourceException rp) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failure in contacting IDP. Check IDP configuration settings of the case engine.", (Throwable)rp);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                CannotReachIDPException failure = new CannotReachIDPException("Cannot reach the IDP to validate credentials", rp);
                HealthMonitor$.MODULE$.idp().hasFailed(failure);
                throw failure;
            }
            catch (Throwable other) {
                HealthMonitor$.MODULE$.idp().isOK();
                Throwable throwable = other;
                if (throwable instanceof BadJWTException) {
                    BadJWTException badJWTException = (BadJWTException)throwable;
                    String exceptionMessage = badJWTException.getMessage();
                    String missingClaimsMsg = "JWT missing required claims";
                    if (badJWTException.getCause() instanceof ParseException) {
                        throw new TokenVerificationException("Token parse failure: " + badJWTException.getCause().getLocalizedMessage());
                    }
                    if (exceptionMessage.contains(missingClaimsMsg)) {
                        throw new MissingClaimsException(exceptionMessage.replace(missingClaimsMsg, "JWT token misses claims"));
                    }
                    throw TokenVerificationException$.MODULE$.apply("Invalid token: " + badJWTException.getLocalizedMessage());
                }
                if (throwable instanceof BadJOSEException) {
                    BoxedUnit boxedUnit;
                    BadJOSEException badJOSEException = (BadJOSEException)throwable;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Encountered JWT issues", (Throwable)badJOSEException);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw TokenVerificationException$.MODULE$.apply("Token cannot be verified: " + badJOSEException.getLocalizedMessage());
                }
                if (throwable instanceof ParseException) {
                    ParseException parseException = (ParseException)throwable;
                    throw TokenVerificationException$.MODULE$.apply("Token parse failure: " + parseException.getLocalizedMessage());
                }
                if (throwable instanceof InvalidIssuerException) {
                    InvalidIssuerException invalidIssuerException = (InvalidIssuerException)throwable;
                    throw invalidIssuerException;
                }
                if (throwable != null) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Unexpected or unforeseen exception during token verification; throwing it further", throwable2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new TokenVerificationException("Token verification failure of type " + throwable2.getClass().getSimpleName(), throwable2);
                }
                throw new MatchError((Object)throwable);
            }
            return authenticatedUser;
        }, this.ec);
    }

    public JwtTokenVerifier(ExecutionContext ec) {
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.jwtProcessor = new DefaultJWTProcessor();
        this.jwtProcessor().setJWTClaimsSetAwareJWSKeySelector((JWTClaimsSetAwareJWSKeySelector)new MultiIssuerJWSKeySelector());
        this.jwtProcessor().setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().build(), new HashSet<Object>(Arrays.asList((Object[])new String[]{"sub", "exp"}))));
    }
}

