/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.authentication;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashSet;
import org.cafienne.infrastructure.Cafienne$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class MultiIssuerJWSKeySelector$
implements LazyLogging {
    public static final MultiIssuerJWSKeySelector$ MODULE$ = new MultiIssuerJWSKeySelector$();
    private static final Map<String, JWSKeySelector<SecurityContext>> configuredIssuers;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        configuredIssuers = MODULE$.readIssuersConfiguration();
    }

    private Logger logger$lzycompute() {
        MultiIssuerJWSKeySelector$ multiIssuerJWSKeySelector$ = this;
        synchronized (multiIssuerJWSKeySelector$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public Map<String, JWSKeySelector<SecurityContext>> configuredIssuers() {
        return configuredIssuers;
    }

    public Map<String, JWSKeySelector<SecurityContext>> readIssuersConfiguration() {
        BoxedUnit boxedUnit;
        Seq issuers = (Seq)Cafienne$.MODULE$.config().OIDC().issuers().map((Function1 & Serializable)metadata -> {
            RemoteJWKSet keySource = new RemoteJWKSet(metadata.getJWKSetURI().toURL());
            String issuer = metadata.getIssuer().getValue();
            HashSet algorithms = new HashSet(metadata.getIDTokenJWSAlgs());
            JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(algorithms, (JWKSource)keySource);
            return new Tuple2((Object)issuer, (Object)keySelector);
        });
        if (issuers.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("ERROR: Missing valid OIDC configuration");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return issuers.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private MultiIssuerJWSKeySelector$() {
    }
}

