/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.actorapi.event.CaseDefinitionApplied;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.actorapi.response.CaseStartedResponse;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

@Manifest
public class StartCase
extends CaseCommand
implements BootstrapMessage {
    private final String tenant;
    private final String rootCaseId;
    private final String parentCaseId;
    private final ValueMap inputParameters;
    private final CaseDefinition definition;
    private CaseTeam caseTeam;
    private final boolean debugMode;

    public StartCase(String string, CaseUserIdentity caseUserIdentity, String string2, CaseDefinition caseDefinition, ValueMap valueMap, CaseTeam caseTeam, boolean bl) {
        this(string, caseUserIdentity, string2, caseDefinition, valueMap, caseTeam, bl, "", string2);
    }

    public StartCase(String string, CaseUserIdentity caseUserIdentity, String string2, CaseDefinition caseDefinition, ValueMap valueMap, CaseTeam caseTeam, boolean bl, String string3, String string4) {
        super(caseUserIdentity, string2);
        this.tenant = string;
        if (string == null || string.isEmpty()) {
            throw new NullPointerException("Tenant cannot be null or empty");
        }
        this.definition = caseDefinition;
        this.rootCaseId = string4;
        this.parentCaseId = string3;
        this.inputParameters = valueMap;
        this.caseTeam = caseTeam;
        this.debugMode = bl;
    }

    public StartCase(ValueMap valueMap) {
        super(valueMap);
        this.tenant = valueMap.readString((Object)Fields.tenant, new String[0]);
        this.rootCaseId = valueMap.readString((Object)Fields.rootActorId, new String[0]);
        this.parentCaseId = valueMap.readString((Object)Fields.parentActorId, new String[0]);
        this.definition = valueMap.readDefinition((Object)Fields.definition, CaseDefinition.class);
        this.inputParameters = valueMap.readMap((Object)Fields.inputParameters);
        this.debugMode = valueMap.readBoolean((Object)Fields.debugMode, new Boolean[0]);
        this.caseTeam = valueMap.readObject((Object)Fields.team, CaseTeam::deserialize);
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    @Override
    public String toString() {
        return "Set Case Definition '" + this.definition.getName() + "'";
    }

    @Override
    public void validate(Case case_) {
        if (case_.getDefinition() != null) {
            throw new InvalidCommandException("Cannot apply a new case definition; the case already has a definition");
        }
        ((Map)this.inputParameters.getValue()).forEach((string, value) -> {
            InputParameterDefinition inputParameterDefinition = this.definition.getInputParameters().get(string);
            if (inputParameterDefinition == null) {
                throw new InvalidCommandException("An input parameter with name " + string + " is not defined in the case");
            }
            inputParameterDefinition.validate((Value<?>)value);
        });
        if (this.caseTeam.isEmpty()) {
            case_.addDebugInfo(() -> "Adding user '" + ((CaseUserIdentity)this.getUser()).id() + "' to the case team (as owner) because new team is empty", new Object[0]);
            this.caseTeam = CaseTeam.create((CaseUserIdentity)this.getUser());
        }
        if (this.caseTeam.owners().isEmpty()) {
            throw new CaseTeamError("The case team needs to have at least one owner");
        }
        this.caseTeam.validate(this.definition.getCaseTeamModel());
    }

    public CaseResponse process(Case case_) {
        case_.upsertDebugMode(this.debugMode);
        if (this.debugMode) {
            case_.addDebugInfo(() -> "Starting case " + this.actorId + " of type " + this.definition.getName() + " in debug mode", new Object[0]);
        } else {
            case_.addDebugInfo(() -> "Starting case " + this.actorId + " of type " + this.definition.getName(), new Object[0]);
        }
        case_.addEvent(new CaseDefinitionApplied(case_, this.rootCaseId, this.parentCaseId, this.definition));
        case_.getCaseTeam().create(this.caseTeam);
        case_.addDebugInfo(() -> "Input parameters for new case of type " + this.definition.getName(), this.inputParameters);
        case_.setInputParameters(this.inputParameters);
        case_.createCasePlan();
        case_.releaseBootstrapCaseFileEvents();
        ValueMap valueMap = new ValueMap();
        valueMap.put("caseInstanceId", new StringValue(case_.getId()));
        valueMap.put("name", new StringValue(case_.getDefinition().getName()));
        return new CaseStartedResponse(this, valueMap);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelCommand(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.tenant, this.tenant);
        this.writeField(jsonGenerator, (Object)Fields.team, this.caseTeam);
        this.writeField(jsonGenerator, (Object)Fields.inputParameters, this.inputParameters);
        this.writeField(jsonGenerator, (Object)Fields.rootActorId, this.rootCaseId);
        this.writeField(jsonGenerator, (Object)Fields.parentActorId, this.parentCaseId);
        this.writeField(jsonGenerator, (Object)Fields.definition, this.definition);
        this.writeField(jsonGenerator, (Object)Fields.debugMode, this.debugMode);
    }
}

