/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.casefile;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

abstract class CaseFileItemCommand
extends CaseCommand {
    protected Path path;
    protected final Value<?> content;
    protected final CaseFileItemTransition intendedTransition;
    protected CaseFileItemCollection<?> caseFileItem;

    protected CaseFileItemCommand(CaseUserIdentity caseUserIdentity, String string, Value<?> value, Path path, CaseFileItemTransition caseFileItemTransition) {
        super(caseUserIdentity, string);
        this.path = path;
        this.content = value;
        this.intendedTransition = caseFileItemTransition;
    }

    protected CaseFileItemCommand(ValueMap valueMap, CaseFileItemTransition caseFileItemTransition) {
        super(valueMap);
        this.path = valueMap.readPath((Object)Fields.path, new String[0]);
        this.content = valueMap.get((Object)Fields.content);
        this.intendedTransition = caseFileItemTransition;
    }

    @Override
    public void validate(Case case_) {
        super.validate(case_);
        this.caseFileItem = this.path.resolve(case_);
        this.caseFileItem.validateTransition(this.intendedTransition, this.content);
    }

    public CaseResponse process(Case case_) {
        this.apply(case_, this.caseFileItem, this.content);
        return new CaseResponse(this);
    }

    abstract void apply(Case var1, CaseFileItemCollection<?> var2, Value<?> var3);

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.path + "]";
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.path, this.path);
        this.writeField(jsonGenerator, (Object)Fields.content, this.content);
    }
}

