/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.migration;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.actorapi.response.migration.MigrationStartedResponse;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class MigrateDefinition
extends CaseCommand {
    private final CaseDefinition newDefinition;

    public MigrateDefinition(CaseUserIdentity caseUserIdentity, String string, CaseDefinition caseDefinition) {
        super(caseUserIdentity, string);
        this.newDefinition = caseDefinition;
    }

    public MigrateDefinition(ValueMap valueMap) {
        super(valueMap);
        this.newDefinition = valueMap.readDefinition((Object)Fields.definition, CaseDefinition.class);
    }

    @Override
    public String toString() {
        return "Migrate Case Definition '" + this.newDefinition.getName() + "'";
    }

    public CaseResponse process(Case case_) {
        if (this.newDefinition.getDefinitionsDocument().equals(case_.getDefinition().getDefinitionsDocument())) {
            case_.addDebugInfo(() -> "No need to migrate definition of case " + case_.getId() + " (proposed definition already in use by the case instance)", new Object[0]);
        } else {
            case_.migrate(this.newDefinition);
        }
        return new MigrationStartedResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelCommand(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.definition, this.newDefinition);
    }
}

