/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.event.ActorModified;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.cmmn.actorapi.event.CaseEvent;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.State;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.LongValue;
import org.cafienne.json.ValueMap;

@Manifest
public class CaseModified
extends ActorModified
implements CaseEvent {
    private final int numFailures;
    private final State state;

    public CaseModified(Case case_, IncomingActorMessage incomingActorMessage, int n) {
        super(case_, incomingActorMessage);
        this.numFailures = n;
        this.state = case_.getCasePlan().getState();
    }

    public CaseModified(ValueMap valueMap) {
        super(valueMap);
        this.numFailures = valueMap.rawInt((Object)Fields.numFailures);
        this.state = valueMap.readEnum((Object)Fields.state, State.class);
    }

    public State getState() {
        return this.state;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    @Override
    public String toString() {
        return "CaseModified[" + this.getCaseInstanceId() + "] at " + this.lastModified();
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeActorModified(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.numFailures, new LongValue(this.numFailures));
        this.writeField(jsonGenerator, (Object)Fields.state, this.state);
    }
}

