/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.CaseBaseEvent;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class CasePlanEvent
extends CaseBaseEvent {
    public final String planItemId;
    public final String stageId;
    public final Path path;
    public final PlanItemType type;
    private final int index;
    private transient PlanItem<?> planItem;

    private static String getStageId(PlanItem<?> planItem) {
        Stage<?> stage = planItem.getStage();
        return stage == null ? "" : stage.getId();
    }

    protected CasePlanEvent(PlanItem<?> planItem) {
        this(planItem.getCaseInstance(), planItem.getId(), CasePlanEvent.getStageId(planItem), planItem.getPath(), planItem.getType(), planItem);
    }

    protected CasePlanEvent(Case case_, String string, String string2, Path path, PlanItemType planItemType, PlanItem<?> planItem) {
        super(case_);
        this.planItemId = string;
        this.stageId = string2;
        this.path = path;
        this.type = planItemType;
        this.index = this.readIndex(path, null);
        this.planItem = planItem;
    }

    protected CasePlanEvent(ValueMap valueMap) {
        super(valueMap);
        this.planItemId = valueMap.readString((Object)Fields.planItemId, new String[0]);
        this.stageId = valueMap.readString((Object)Fields.stageId, "");
        this.path = Path.untrimmed(valueMap.readString((Object)Fields.path, ""));
        this.type = valueMap.readEnum((Object)Fields.type, PlanItemType.class);
        this.planItem = null;
        this.index = this.readIndex(this.path, valueMap);
    }

    private int readIndex(Path path, ValueMap valueMap) {
        if (path.isEmpty()) {
            return valueMap.with((Object)Fields.planitem).readLong((Object)Fields.index, -1L).intValue();
        }
        return Math.max(0, path.index);
    }

    protected void setPlanItem(PlanItem<?> planItem) {
        this.planItem = planItem;
    }

    protected PlanItem<?> getPlanItem() {
        return this.planItem;
    }

    @Override
    public void updateState(Case case_) {
        if (this.planItem == null) {
            this.planItem = case_.getPlanItemById(this.getPlanItemId());
            if (this.planItem == null) {
                logger.error("MAJOR ERROR in " + this.getClass().getSimpleName() + ": Cannot recover event, because plan item with id " + this.planItemId + " cannot be found; Case instance " + this.getActorId() + " with definition name '" + case_.getDefinition().getName() + "'");
                return;
            }
        }
        this.updatePlanItemState(this.planItem);
    }

    protected abstract void updatePlanItemState(PlanItem<?> var1);

    public void writeCasePlanEvent(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.planItemId, this.planItemId);
        this.writeField(jsonGenerator, (Object)Fields.stageId, this.stageId);
        this.writeField(jsonGenerator, (Object)Fields.path, this.path);
        this.writeField(jsonGenerator, (Object)Fields.type, this.type);
    }

    public PlanItemType getType() {
        return this.type;
    }

    public String getPlanItemId() {
        return this.planItemId;
    }

    protected String getName() {
        return this.getPlanItem() != null ? this.getPlanItem().getName() + "." + this.getIndex() : "PlanItem";
    }

    public int getIndex() {
        return this.index;
    }
}

