/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class PlanItemTransitioned
extends CasePlanEvent
implements StandardEvent<Transition, PlanItem<?>> {
    private final State currentState;
    private final State historyState;
    private final Transition transition;

    public PlanItemTransitioned(PlanItem<?> planItem, State state, State state2, Transition transition) {
        super(planItem);
        this.currentState = state;
        this.historyState = state2;
        this.transition = transition;
    }

    public PlanItemTransitioned(ValueMap valueMap) {
        super(valueMap);
        this.currentState = valueMap.readEnum((Object)Fields.currentState, State.class);
        this.historyState = valueMap.readEnum((Object)Fields.historyState, State.class);
        this.transition = valueMap.readEnum((Object)Fields.transition, Transition.class);
    }

    @Override
    public PlanItem<?> getSource() {
        return this.getPlanItem();
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public State getHistoryState() {
        if (this.historyState == null) {
            return State.Null;
        }
        return this.historyState;
    }

    @Override
    public boolean hasBehavior() {
        return true;
    }

    @Override
    public void runImmediateBehavior() {
        this.getPlanItem().runStateMachineAction(this);
        this.getPlanItem().informConnectedEntryCriteria(this);
    }

    @Override
    public void runDelayedBehavior() {
        this.getPlanItem().runStageCompletionCheck(this);
        this.getPlanItem().informConnectedExitCriteria(this);
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "/" + this.getPlanItemId() + "]: " + this.getHistoryState() + "." + this.getTransition().toString().toLowerCase() + "() ===> " + this.getCurrentState();
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeCasePlanEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.historyState, this.historyState);
        this.writeField(jsonGenerator, (Object)Fields.transition, this.transition);
        this.writeField(jsonGenerator, (Object)Fields.currentState, this.currentState);
    }

    @Override
    protected void updatePlanItemState(PlanItem<?> planItem) {
        planItem.publishTransition(this);
    }
}

