/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan.eventlistener;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerBaseEvent;
import org.cafienne.cmmn.definition.TimerEventDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.TimerEvent;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Manifest
public class TimerSet
extends TimerBaseEvent {
    private static final Logger logger = LoggerFactory.getLogger(TimerSet.class);
    private final Instant targetMoment;
    private transient TimerEvent timerEvent;

    public TimerSet(TimerEvent timerEvent) {
        super(timerEvent);
        this.timerEvent = timerEvent;
        this.targetMoment = ((TimerEventDefinition)timerEvent.getDefinition()).getMoment(timerEvent);
    }

    public TimerSet(ValueMap valueMap) {
        super(valueMap);
        this.targetMoment = valueMap.readInstant((Object)Fields.targetMoment, new Instant[0]);
    }

    public Instant getTargetMoment() {
        return this.targetMoment;
    }

    @Override
    public void updateState(Case case_) {
        if (this.timerEvent == null) {
            this.timerEvent = (TimerEvent)case_.getPlanItemById(this.getTimerId());
            if (this.timerEvent == null) {
                logger.error("MAJOR ERROR: Cannot recover task timerEvent for task with id " + this.getTimerId() + ", because the plan item cannot be found");
                return;
            }
        }
        this.timerEvent.updateState(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeTimerEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.targetMoment, this.targetMoment);
    }

    @Override
    public String toString() {
        return "Timer " + this.getTimerId() + " is set to occur at " + this.targetMoment;
    }
}

