/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.cafienne.cmmn.definition.CMMNDocumentationDefinition;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.InvalidDefinitionException;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.StageDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.infrastructure.serialization.CafienneSerializer;
import org.cafienne.infrastructure.serialization.DeserializationError;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class CMMNElementDefinition
extends XMLElementDefinition {
    private static final Logger logger = LoggerFactory.getLogger(CafienneSerializer.class);
    public final CMMNDocumentationDefinition documentation = this.parseDocumentation();

    protected CMMNElementDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition, boolean ... blArray) {
        super(element, modelDefinition, cMMNElementDefinition, blArray);
        if (modelDefinition != null) {
            modelDefinition.addCMMNElement(this);
        }
    }

    private CMMNDocumentationDefinition parseDocumentation() {
        CMMNDocumentationDefinition cMMNDocumentationDefinition = this.parse("documentation", CMMNDocumentationDefinition.class, false);
        if (cMMNDocumentationDefinition == null) {
            cMMNDocumentationDefinition = new CMMNDocumentationDefinition(this.getModelDefinition(), this);
        }
        return cMMNDocumentationDefinition;
    }

    public CMMNDocumentationDefinition getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getContextDescription() {
        return "";
    }

    public String toString() {
        if (this.getName().isEmpty()) {
            return this.getClass().getSimpleName();
        }
        return this.getName();
    }

    @Override
    public CaseDefinition getCaseDefinition() {
        return (CaseDefinition)this.getModelDefinition();
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        return (ProcessDefinition)this.getModelDefinition();
    }

    protected StageDefinition getSurroundingStage() {
        Object t;
        for (t = this.getParentElement(); t != null && !(t instanceof StageDefinition); t = ((XMLElementDefinition)t).getParentElement()) {
        }
        return (StageDefinition)t;
    }

    public static <T extends CMMNElementDefinition> T fromJSON(String string, ValueMap valueMap, Class<T> clazz) {
        String string2 = valueMap.readString((Object)Fields.elementId, new String[0]);
        String string3 = valueMap.readString((Object)Fields.source, new String[0]);
        try {
            DefinitionsDocument definitionsDocument = new DefinitionsDocument(XMLHelper.loadXML(string3));
            T t = definitionsDocument.getElement(string2, clazz);
            return t;
        }
        catch (InvalidDefinitionException invalidDefinitionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("Encountered invalid definition during deserialization; probably content from a newer or older version", (Throwable)invalidDefinitionException);
            } else {
                logger.warn("Encountered invalid definition during deserialization; probably content from a newer or older version.\nEnable debug logging for full stacktrace. Error messages: " + invalidDefinitionException.getErrors());
            }
            throw new DeserializationError("Invalid Definition Failure while deserializing an instance of " + string, invalidDefinitionException);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new DeserializationError("Parsing Failure while deserializing an instance of " + string, exception);
        }
    }

    public ValueMap toJSON() {
        String string = this.getId();
        if (string == null || string.isEmpty()) {
            string = this.getName();
        }
        String string2 = this.getModelDefinition().getDefinitionsDocument().getSource();
        ValueMap valueMap = new ValueMap(new Object[]{Fields.elementId, string, Fields.source, string2});
        return valueMap;
    }
}

