/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CasePlanDefinition;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanFragmentDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.task.TaskImplementationContract;
import org.cafienne.cmmn.definition.team.CaseTeamDefinition;
import org.w3c.dom.Element;

public class CaseDefinition
extends ModelDefinition
implements TaskImplementationContract {
    private final CaseFileDefinition caseFileModel = this.parse("caseFileModel", CaseFileDefinition.class, true);
    private final CasePlanDefinition casePlanModel = this.parse("casePlanModel", CasePlanDefinition.class, true);
    private final CaseTeamDefinition caseTeamModel = new CaseTeamDefinition(this);

    public CaseDefinition(Element element, DefinitionsDocument definitionsDocument) {
        super(element, definitionsDocument);
    }

    public CasePlanDefinition getCasePlanModel() {
        return this.casePlanModel;
    }

    public CaseFileDefinition getCaseFileModel() {
        return this.caseFileModel;
    }

    public CaseTeamDefinition getCaseTeamModel() {
        return this.caseTeamModel;
    }

    public PlanItemDefinition findPlanItem(CMMNElementDefinition cMMNElementDefinition, String string) {
        PlanItemDefinition planItemDefinition;
        if (cMMNElementDefinition == null) {
            return null;
        }
        if (cMMNElementDefinition instanceof PlanFragmentDefinition && (planItemDefinition = ((PlanFragmentDefinition)cMMNElementDefinition).searchPlanItem(string)) != null) {
            return planItemDefinition;
        }
        return this.findPlanItem((CMMNElementDefinition)cMMNElementDefinition.getParentElement(), string);
    }

    PlanItemDefinitionDefinition findPlanItemDefinition(String string) {
        Collection<PlanItemDefinitionDefinition> collection = this.getCasePlanModel().getPlanItemDefinitions();
        return collection.stream().filter(planItemDefinitionDefinition -> planItemDefinitionDefinition.getId().equals(string) || planItemDefinitionDefinition.getName().equals(string)).findFirst().orElse(null);
    }

    public CaseFileItemDefinition findCaseFileItem(String string) {
        return this.getCaseFileModel().findCaseFileItem(string);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameCaseDefinition);
    }

    public boolean sameCaseDefinition(CaseDefinition caseDefinition) {
        return this.sameModelDefinition(caseDefinition) && this.same(this.caseFileModel, caseDefinition.caseFileModel) && this.same(this.casePlanModel, caseDefinition.casePlanModel) && this.same(this.caseTeamModel, caseDefinition.caseTeamModel);
    }
}

