/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanningTableDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.task.WorkflowTaskDefinition;
import org.cafienne.cmmn.definition.task.validation.TaskOutputValidatorDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.w3c.dom.Element;

public class HumanTaskDefinition
extends TaskDefinition<WorkflowTaskDefinition> {
    private final PlanningTableDefinition planningTable = this.parse("planningTable", PlanningTableDefinition.class, false);
    private final String performerRef = this.parseAttribute("performerRef", false, "");
    private CaseRoleDefinition performer;
    private final WorkflowTaskDefinition workflowDefinition;
    private final String taskOutputValidatorRef;
    private TaskOutputValidatorDefinition taskOutputValidator;

    public HumanTaskDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        if (!this.isBlocking() && this.getPlanningTable() != null) {
            this.getCaseDefinition().addDefinitionError("HumanTask " + this.getName() + " is non blocking and therefore may not have a planning table");
        }
        this.workflowDefinition = this.parseWorkflowTaskDefinition();
        this.taskOutputValidatorRef = this.workflowDefinition.getElement().getAttribute("validatorRef");
    }

    @Override
    public PlanItemType getItemType() {
        return PlanItemType.HumanTask;
    }

    private WorkflowTaskDefinition parseWorkflowTaskDefinition() {
        WorkflowTaskDefinition workflowTaskDefinition = this.getExtension("implementation", WorkflowTaskDefinition.class, false);
        if (workflowTaskDefinition == null) {
            workflowTaskDefinition = WorkflowTaskDefinition.createEmptyDefinition(this);
        }
        return workflowTaskDefinition;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    public TaskOutputValidatorDefinition getTaskOutputValidator() {
        return this.taskOutputValidator;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        if (!this.performerRef.isEmpty()) {
            this.performer = this.getCaseDefinition().getCaseTeamModel().resolveRoleReference(this.performerRef, "Human Task " + this);
        }
        if (!this.taskOutputValidatorRef.isEmpty()) {
            ProcessDefinition processDefinition = this.getCaseDefinition().getDefinitionsDocument().getProcessDefinition(this.taskOutputValidatorRef);
            if (processDefinition == null) {
                this.getModelDefinition().addReferenceError("The task output validator in human task '" + this.getName() + "' refers to a process named " + this.taskOutputValidatorRef + ", but that definition is not found");
                return;
            }
            this.taskOutputValidator = new TaskOutputValidatorDefinition(processDefinition);
        }
    }

    public HumanTask createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        return new HumanTask(string, n, itemDefinition, this, stage);
    }

    public PlanningTableDefinition getPlanningTable() {
        return this.planningTable;
    }

    public CaseRoleDefinition getPerformer() {
        return this.performer;
    }

    @Override
    public WorkflowTaskDefinition getImplementationDefinition() {
        return this.workflowDefinition;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameHumanTask);
    }

    public boolean sameHumanTask(HumanTaskDefinition humanTaskDefinition) {
        return this.sameTask(humanTaskDefinition) && this.same(this.planningTable, humanTaskDefinition.planningTable) && this.same(this.performer, humanTaskDefinition.performer) && this.same(this.workflowDefinition, humanTaskDefinition.workflowDefinition) && this.same(this.taskOutputValidator, humanTaskDefinition.taskOutputValidator);
    }
}

