/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.sentry.SentryDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class PlanFragmentDefinition
extends PlanItemDefinitionDefinition {
    private static final Logger logger = LoggerFactory.getLogger(PlanFragmentDefinition.class);
    private final Collection<PlanItemDefinition> planItems = new ArrayList<PlanItemDefinition>();
    private final Collection<SentryDefinition> sentries = new ArrayList<SentryDefinition>();

    public PlanFragmentDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parse("planItem", PlanItemDefinition.class, this.planItems);
        this.parse("sentry", SentryDefinition.class, this.sentries);
    }

    public Collection<SentryDefinition> getSentries() {
        return this.sentries;
    }

    public SentryDefinition getSentry(String string) {
        return this.sentries.stream().filter(sentryDefinition -> sentryDefinition.getName().equals(string) || sentryDefinition.getId().equals(string)).findFirst().orElse(null);
    }

    public Collection<PlanItemDefinition> getPlanItems() {
        return this.planItems;
    }

    public PlanItemDefinition getPlanItem(String string) {
        return this.planItems.stream().filter(planItemDefinition -> planItemDefinition.getId().equals(string) || planItemDefinition.getName().equals(string)).findFirst().orElse(null);
    }

    PlanItemDefinition searchPlanItem(String string) {
        PlanItemDefinition planItemDefinition = this.getPlanItem(string);
        if (planItemDefinition != null) {
            return planItemDefinition;
        }
        for (PlanItemDefinition planItemDefinition2 : this.planItems) {
            PlanItemDefinitionDefinition planItemDefinitionDefinition = planItemDefinition2.getPlanItemDefinition();
            if (planItemDefinitionDefinition == null) {
                logger.error("Wow... the definition of " + planItemDefinition2.getId() + " is missing while searching for planItem with id " + string);
            }
            if (!(planItemDefinitionDefinition instanceof PlanFragmentDefinition) || (planItemDefinition = ((PlanFragmentDefinition)planItemDefinitionDefinition).searchPlanItem(string)) == null) continue;
            return planItemDefinition;
        }
        return null;
    }

    @Override
    public PlanItem<?> createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Transition getEntryTransition() {
        return Transition.Start;
    }

    public boolean samePlanItems(PlanFragmentDefinition planFragmentDefinition) {
        return this.same(this.planItems, planFragmentDefinition.planItems);
    }

    public boolean sameSentries(PlanFragmentDefinition planFragmentDefinition) {
        return this.same(this.sentries, planFragmentDefinition.sentries);
    }

    public boolean samePlanFragment(PlanFragmentDefinition planFragmentDefinition) {
        return this.samePlanItemDefinitionDefinition(planFragmentDefinition) && this.samePlanItems(planFragmentDefinition) && this.sameSentries(planFragmentDefinition);
    }
}

