/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.task.process.ProcessTask;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.w3c.dom.Element;

public class ProcessTaskDefinition
extends TaskDefinition<ProcessDefinition> {
    private final String processRef = this.parseAttribute("processRef", true, new String[0]);
    private ProcessDefinition processDefinition;

    public ProcessTaskDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
    }

    @Override
    public PlanItemType getItemType() {
        return PlanItemType.ProcessTask;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.processDefinition = this.getCaseDefinition().getDefinitionsDocument().getProcessDefinition(this.processRef);
        if (this.processDefinition == null) {
            this.getModelDefinition().addReferenceError("The process task '" + this.getName() + "' refers to a process named " + this.processRef + ", but that definition is not found");
            return;
        }
    }

    public ProcessTask createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        return new ProcessTask(string, n, itemDefinition, this, stage);
    }

    @Override
    public ProcessDefinition getImplementationDefinition() {
        return this.processDefinition;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameProcessTask);
    }

    public boolean sameProcessTask(ProcessTaskDefinition processTaskDefinition) {
        return this.sameTask(processTaskDefinition) && this.processDefinition.sameProcessDefinition(processTaskDefinition.processDefinition);
    }
}

