/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.ParameterMappingDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.parameter.TaskInputParameterDefinition;
import org.cafienne.cmmn.definition.parameter.TaskOutputParameterDefinition;
import org.cafienne.cmmn.definition.task.TaskImplementationContract;
import org.cafienne.cmmn.instance.Transition;
import org.w3c.dom.Element;

public abstract class TaskDefinition<T extends TaskImplementationContract>
extends PlanItemDefinitionDefinition {
    private final boolean isBlocking;
    private final Map<String, TaskInputParameterDefinition> inputs = new LinkedHashMap<String, TaskInputParameterDefinition>();
    private final Map<String, TaskOutputParameterDefinition> outputs = new LinkedHashMap<String, TaskOutputParameterDefinition>();
    private final Collection<ParameterMappingDefinition> mappings = new ArrayList<ParameterMappingDefinition>();

    protected TaskDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.isBlocking = Boolean.parseBoolean(this.parseAttribute("isBlocking", false, "true"));
        this.parse("inputs", TaskInputParameterDefinition.class, this.inputs);
        this.parse("outputs", TaskOutputParameterDefinition.class, this.outputs);
        if (!this.isBlocking() && !this.getOutputParameters().isEmpty()) {
            this.getCaseDefinition().addDefinitionError("The non blocking task " + this.getName() + " may not have output parameters");
        }
        this.parse("parameterMapping", ParameterMappingDefinition.class, this.mappings);
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public Map<String, TaskInputParameterDefinition> getInputParameters() {
        return this.inputs;
    }

    public Map<String, TaskOutputParameterDefinition> getOutputParameters() {
        return this.outputs;
    }

    public Collection<ParameterMappingDefinition> getParameterMappings() {
        return this.mappings;
    }

    public Stream<ParameterMappingDefinition> getInputMappings() {
        return this.mappings.stream().filter(ParameterMappingDefinition::isInputParameterMapping);
    }

    public Stream<ParameterMappingDefinition> getOutputMappings() {
        return this.mappings.stream().filter(parameterMappingDefinition -> !parameterMappingDefinition.isInputParameterMapping());
    }

    @Override
    public Transition getEntryTransition() {
        return Transition.Start;
    }

    abstract T getImplementationDefinition();

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameTask);
    }

    public boolean sameTask(TaskDefinition<T> taskDefinition) {
        return this.samePlanItemDefinitionDefinition(taskDefinition) && this.same(this.isBlocking, taskDefinition.isBlocking) && this.sameInputParameters(taskDefinition) && this.sameOutputParameters(taskDefinition) && this.sameMappings(taskDefinition);
    }

    public boolean sameInputParameters(TaskDefinition<T> taskDefinition) {
        return this.same(this.inputs.values(), taskDefinition.inputs.values());
    }

    public boolean sameOutputParameters(TaskDefinition<T> taskDefinition) {
        return this.same(this.outputs.values(), taskDefinition.outputs.values());
    }

    public boolean sameMappings(TaskDefinition<?> taskDefinition) {
        return this.same(this.mappings, taskDefinition.mappings);
    }
}

