/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.EventListenerDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.UserEvent;
import org.w3c.dom.Element;

public class UserEventDefinition
extends EventListenerDefinition {
    private final String authorizedRoleRefs;
    private final Collection<CaseRoleDefinition> authorizedRoles = new ArrayList<CaseRoleDefinition>();

    public UserEventDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.authorizedRoleRefs = this.parseAttribute("authorizedRoleRefs", false, "");
    }

    @Override
    public PlanItemType getItemType() {
        return PlanItemType.UserEvent;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.getCaseDefinition().getCaseTeamModel().resolveRoleReferences(this.authorizedRoleRefs, this.authorizedRoles, "User Event " + this);
    }

    public Collection<CaseRoleDefinition> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public UserEvent createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        return new UserEvent(string, n, itemDefinition, this, stage);
    }

    @Override
    public Transition getEntryTransition() {
        return Transition.Occur;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameUserEvent);
    }

    public boolean sameUserEvent(UserEventDefinition userEventDefinition) {
        return this.samePlanItemDefinitionDefinition(userEventDefinition) && this.same(this.authorizedRoles, userEventDefinition.authorizedRoles);
    }
}

