/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.util.StringTemplate;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class XMLElementDefinition
implements DefinitionElement {
    private static final Logger logger = LoggerFactory.getLogger(XMLElementDefinition.class);
    protected static final String NAMESPACE_URI = "org.cafienne";
    private final String id;
    private String name;
    private final ModelDefinition modelDefinition;
    private final XMLElementDefinition parentElement;
    private final Element element;
    private static final String EXTENSIONELEMENTS = "extensionElements";
    private static String indent = "";

    protected XMLElementDefinition(Element element, ModelDefinition modelDefinition, XMLElementDefinition xMLElementDefinition, boolean ... blArray) {
        this.element = element;
        this.modelDefinition = modelDefinition;
        this.parentElement = xMLElementDefinition;
        this.id = this.parseAttribute("id", false, new String[0]);
        this.name = this.parseAttribute("name", false, new String[0]);
        if (blArray.length > 0 && blArray[0] && this.getName().isEmpty() && this.getId().isEmpty()) {
            this.getModelDefinition().addDefinitionError("An element of type '" + this.printElement() + "' does not have an identifier " + XMLHelper.printXMLNode(element));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    @Override
    public String getId() {
        if (this.id == null || this.id.isEmpty()) {
            return this.name;
        }
        return this.id;
    }

    public String getContextDescription() {
        return "";
    }

    public ModelDefinition getModelDefinition() {
        return this.modelDefinition;
    }

    public CaseDefinition getCaseDefinition() {
        return (CaseDefinition)this.getModelDefinition();
    }

    public ProcessDefinition getProcessDefinition() {
        return (ProcessDefinition)this.getModelDefinition();
    }

    public <T extends CMMNElementDefinition> T getParentElement() {
        CMMNElementDefinition cMMNElementDefinition = (CMMNElementDefinition)this.parentElement;
        return (T)cMMNElementDefinition;
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public String getType() {
        String string = this.getClass().getSimpleName();
        if (string.endsWith("Definition")) {
            string = string.substring(0, string.length() - "Definition".length());
        }
        return string;
    }

    protected void resolveReferences() {
    }

    protected void validateElement() {
    }

    private <T> T instantiateT(Element element, Class<T> clazz) {
        try {
            if (clazz.equals(String.class)) {
                String string = element.getTextContent();
                return (T)string;
            }
            Constructor<T> constructor = clazz.getConstructor(Element.class, ModelDefinition.class, CMMNElementDefinition.class);
            T t = constructor.newInstance(element, this.getModelDefinition(), this);
            return t;
        }
        catch (IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            String string = "The class " + clazz.getName() + " cannot be instantiated";
            this.getModelDefinition().fatalError(string, exception);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "The class " + clazz.getName() + " cannot be accessed";
            this.getModelDefinition().fatalError(string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "The class " + clazz.getName() + " must have a constructor with 3 arguments: org.w3c.dom.Element, Definition and  CMMNElementDefinition";
            this.getModelDefinition().fatalError(string, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            String string = "The class " + clazz.getName() + " cannot be accessed due to a security exception";
            this.getModelDefinition().fatalError(string, securityException);
        }
        return null;
    }

    protected <T> void parse(String string, Class<? extends T> clazz, Collection<T> collection) {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.element, string);
        for (Element element : list) {
            T t = this.instantiateT(element, clazz);
            collection.add(t);
        }
    }

    protected <T> void parseExtension(String string, Class<? extends T> clazz, Collection<T> collection) {
        this.parseGrandChildren(EXTENSIONELEMENTS, string, clazz, collection);
    }

    protected <T> T parseExtension(String string, Class<? extends T> clazz) {
        return this.parseGrandChild(EXTENSIONELEMENTS, string, clazz);
    }

    private <T> T parseGrandChild(String string, String string2, Class<? extends T> clazz) {
        Element element;
        Element element2 = XMLHelper.findElement(this.element, string);
        if (element2 != null && (element = XMLHelper.findElement(this.element, string2)) != null) {
            T t = this.instantiateT(element, clazz);
            return t;
        }
        return null;
    }

    protected <T> void parseGrandChildren(String string, String string2, Class<? extends T> clazz, Collection<T> collection) {
        Element element = XMLHelper.findElement(this.element, string);
        if (element != null) {
            List<Element> list = XMLHelper.getChildrenWithTagName(element, string2);
            for (Element element2 : list) {
                T t = this.instantiateT(element2, clazz);
                collection.add(t);
            }
        }
    }

    protected <T extends XMLElementDefinition> void parse(String string, Class<? extends T> clazz, Map<String, T> map) {
        List<Element> list = XMLHelper.getChildrenWithTagName(this.element, string);
        for (Element element : list) {
            XMLElementDefinition xMLElementDefinition = (XMLElementDefinition)this.instantiateT(element, clazz);
            if (xMLElementDefinition.getName().isEmpty()) {
                this.getModelDefinition().addDefinitionError("The element does not have a name, but it is required in order to be able to look it up\n" + XMLHelper.printXMLNode(element));
            }
            map.put(xMLElementDefinition.getName(), xMLElementDefinition);
        }
    }

    protected <T> T parse(String string, Class<? extends T> clazz, boolean bl) {
        if (this.element == null) {
            if (bl) {
                this.getModelDefinition().addDefinitionError("A '" + string + "' cannot be found in the class " + this.getClass().getName() + ", because there is no XML element defined");
            }
            return null;
        }
        Element element = XMLHelper.getElement(this.element, string);
        if (element != null) {
            return this.instantiateT(element, clazz);
        }
        if (bl) {
            this.getModelDefinition().addDefinitionError("A '" + string + "' cannot be found in the element " + this.printElement() + ", but it is required");
        }
        return null;
    }

    protected String parseString(String string, boolean bl, String ... stringArray) {
        String string2 = XMLHelper.getContent(this.element, string, null);
        if (bl && string2 == null) {
            this.getModelDefinition().addDefinitionError("A '" + string + "' cannot be found in the element " + this.printElement() + ", but it is required");
            return null;
        }
        if (string2 == null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        return string2;
    }

    protected StringTemplate parseTemplate(String string, boolean bl) {
        String string2 = this.parseString(string, bl, new String[0]);
        if (string2 == null) {
            return null;
        }
        return new StringTemplate(string2);
    }

    protected String printElement() {
        String string = XMLHelper.printXMLNode(this.element.cloneNode(false));
        string = string.replace("\n", "");
        string = string.replace("\r", "");
        return string;
    }

    public <T> T getExtension(String string, Class<? extends T> clazz, boolean bl) {
        Element element = this.getExtension(string, bl);
        if (element == null) {
            return null;
        }
        String string2 = element.getAttribute("class");
        if (string2.isEmpty()) {
            if (bl) {
                this.getModelDefinition().addDefinitionError("A custom " + string + " tag does not contain the class attribute in " + this.printElement() + ", but it is required");
                return null;
            }
            return null;
        }
        try {
            Class<?> clazz2 = Class.forName(string2);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new RuntimeException("The implementation class " + string2 + " must implement " + clazz.getName() + ", but it does not");
            }
            Object obj = this.instantiateT(element, clazz2);
            return (T)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = "Cannot find class to parse the custom " + string + " - " + string2;
            this.getModelDefinition().fatalError(string3, classNotFoundException);
        }
        catch (SecurityException securityException) {
            String string4 = "The class " + string2 + " cannot be accessed due to a security exception";
            this.getModelDefinition().fatalError(string4, securityException);
        }
        return null;
    }

    public Element getExtension(String string, boolean bl) {
        Element element = XMLHelper.getElement(this.element, EXTENSIONELEMENTS);
        if (element == null) {
            if (bl) {
                this.getModelDefinition().addDefinitionError("'extensionElements' tag is not found in " + this.printElement() + ", but it is required");
                return null;
            }
            return null;
        }
        Element element2 = null;
        if (string != null && !string.isEmpty()) {
            element2 = XMLHelper.getElementNS(element, NAMESPACE_URI, string);
        }
        if (element2 == null && bl) {
            this.getModelDefinition().addDefinitionError("A custom " + string + " tag is not found in " + this.printElement() + "/extensionElements in org.cafienne namespace, but it is required");
        }
        return element2;
    }

    protected String parseAttribute(String string, boolean bl, String ... stringArray) {
        if (this.element != null && this.element.hasAttribute(string)) {
            return this.element.getAttribute(string);
        }
        if (bl) {
            if (this.element == null) {
                this.getModelDefinition().addDefinitionError("The attribute " + string + " cannot be found, because an XML element is missing in " + this.getType());
            } else {
                this.getModelDefinition().addDefinitionError("The attribute " + string + " is missing from the element " + XMLHelper.printXMLNode(this.element));
            }
        }
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    protected boolean sameClass(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public boolean sameName(XMLElementDefinition xMLElementDefinition) {
        return this.same(this.getName(), xMLElementDefinition.getName());
    }

    public boolean sameId(XMLElementDefinition xMLElementDefinition) {
        return this.same(this.getId(), xMLElementDefinition.getId());
    }

    public boolean sameIdentifiers(XMLElementDefinition xMLElementDefinition) {
        return this.sameName(xMLElementDefinition) && this.sameId(xMLElementDefinition);
    }

    @Override
    public boolean differs(Object object) {
        return !this.equalsWith(object);
    }

    protected abstract boolean equalsWith(Object var1);

    protected <E extends XMLElementDefinition> boolean equalsWith(Object object, DefinitionComparer<E> definitionComparer) {
        if (!this.sameClass(object)) {
            return false;
        }
        String string = indent;
        indent = indent + "  ";
        boolean bl = definitionComparer.match((XMLElementDefinition)object);
        indent = string;
        return bl;
    }

    public static <T extends Z, Z extends XMLElementDefinition> T findDefinition(T t, Collection<Z> collection) {
        for (XMLElementDefinition xMLElementDefinition : collection) {
            if (!((XMLElementDefinition)t).equalsWith(xMLElementDefinition)) continue;
            return (T)xMLElementDefinition;
        }
        return null;
    }

    protected <X extends XMLElementDefinition> boolean same(Collection<X> collection, Collection<X> collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (XMLElementDefinition xMLElementDefinition : collection) {
            if (XMLElementDefinition.findDefinition(xMLElementDefinition, collection2) != null) continue;
            return false;
        }
        return true;
    }

    protected <X extends XMLElementDefinition> boolean same(X x, X x2) {
        return x == null && x2 == null || x != null && x2 != null && x.equalsWith(x2);
    }

    protected boolean same(String string, String string2) {
        return Objects.equals(string, string2);
    }

    protected <E extends Enum<?>> boolean same(E e, E e2) {
        return Objects.equals(e, e2);
    }

    protected boolean same(boolean bl, boolean bl2) {
        return Objects.equals(bl, bl2);
    }

    protected boolean same(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    protected boolean notYetImplemented() {
        logger.error("Definition comparison is not yet implemented on definition elements of type " + this.getClass().getName());
        return false;
    }

    @FunctionalInterface
    protected static interface DefinitionComparer<X extends XMLElementDefinition> {
        public boolean match(X var1);
    }
}

