/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.casefile;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.w3c.dom.Element;

public class PropertyDefinition
extends CMMNElementDefinition {
    private final PropertyType type;
    private final boolean isBusinessIdentifier;

    public PropertyDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        String string = this.parseAttribute("type", false, "");
        this.type = PropertyType.getEnum(string);
        if (this.type == null) {
            this.getModelDefinition().addDefinitionError(((XMLElementDefinition)this.getParentElement()).getType() + " " + ((XMLElementDefinition)this.getParentElement()).getName() + " is invalid, because property " + this.getName() + " has unrecognized type " + string);
        }
        this.isBusinessIdentifier = this.readBusinessIdentifiership();
    }

    private boolean readBusinessIdentifiership() {
        Element element = this.getExtension("implementation", false);
        if (element == null) {
            return false;
        }
        String string = element.getAttribute("isBusinessIdentifier");
        return string.equalsIgnoreCase("true");
    }

    public boolean isBusinessIdentifier() {
        return this.isBusinessIdentifier;
    }

    public PropertyType getPropertyType() {
        return this.type;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::samePropertyDefinition);
    }

    public boolean samePropertyDefinition(PropertyDefinition propertyDefinition) {
        return this.sameName(propertyDefinition) && this.same(this.type, propertyDefinition.type) && this.same(this.isBusinessIdentifier, propertyDefinition.isBusinessIdentifier);
    }

    public static enum PropertyType {
        String("http://www.omg.org/spec/CMMN/PropertyType/string"),
        Boolean("http://www.omg.org/spec/CMMN/PropertyType/boolean"),
        Integer("http://www.omg.org/spec/CMMN/PropertyType/integer"),
        Float("http://www.omg.org/spec/CMMN/PropertyType/float"),
        Double("http://www.omg.org/spec/CMMN/PropertyType/double"),
        Duration("http://www.omg.org/spec/CMMN/PropertyType/duration"),
        DateTime("http://www.omg.org/spec/CMMN/PropertyType/dateTime"),
        Time("http://www.omg.org/spec/CMMN/PropertyType/time"),
        Date("http://www.omg.org/spec/CMMN/PropertyType/date"),
        GYearMonth("http://www.omg.org/spec/CMMN/PropertyType/gYearMonth"),
        GYear("http://www.omg.org/spec/CMMN/PropertyType/gYear"),
        GMonthDay("http://www.omg.org/spec/CMMN/PropertyType/gMonthDay"),
        GDay("http://www.omg.org/spec/CMMN/PropertyType/gDay"),
        GMonth("http://www.omg.org/spec/CMMN/PropertyType/gMonth"),
        HexBinary("http://www.omg.org/spec/CMMN/PropertyType/hexBinary"),
        Base64Binary("http://www.omg.org/spec/CMMN/PropertyType/base64Binary"),
        AnyURI("http://www.omg.org/spec/CMMN/PropertyType/anyURI"),
        QName("http://www.omg.org/spec/CMMN/PropertyType/QName"),
        Decimal("http://www.omg.org/spec/CMMN/PropertyType/decimal"),
        Unspecified("http://www.omg.org/spec/CMMN/PropertyType/Unspecified");

        private final String uri;

        private PropertyType(String string2) {
            this.uri = string2;
        }

        public String toString() {
            return this.uri;
        }

        public static PropertyType getEnum(String string) {
            if (string == null) {
                return null;
            }
            for (PropertyType propertyType : PropertyType.values()) {
                if (!propertyType.toString().equals(string)) continue;
                return propertyType;
            }
            return null;
        }
    }
}

