/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.parameter;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.parameter.OutputParameterDefinition;
import org.w3c.dom.Element;

public class TaskOutputParameterDefinition
extends OutputParameterDefinition {
    private final boolean isMandatory = this.getMandatoryValue();

    public TaskOutputParameterDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
    }

    private boolean getMandatoryValue() {
        Element element = this.getExtension("implementation", false);
        if (element == null) {
            return false;
        }
        String string = element.getAttribute("required");
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.isEmpty() || string.equalsIgnoreCase("false")) {
            return false;
        }
        TaskDefinition taskDefinition = (TaskDefinition)this.getParentElement();
        this.getModelDefinition().addDefinitionError("Output parameter " + this.getName() + " in task " + taskDefinition.getName() + " has an invalid value for the required attribute: '" + string + "'");
        return false;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameTaskParameter);
    }

    public boolean sameTaskParameter(TaskOutputParameterDefinition taskOutputParameterDefinition) {
        return this.sameParameter(taskOutputParameterDefinition) && this.same(this.isMandatory, taskOutputParameterDefinition.isMandatory);
    }
}

