/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel.api.cmmn.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.CaseAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.MilestoneAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.PlanItemAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.TaskAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.TimerEventAPI;
import org.cafienne.cmmn.instance.Milestone;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.TimerEvent;

public class StageAPI
extends PlanItemAPI<Stage<?>> {
    protected StageAPI(CaseAPI caseAPI, Stage<?> stage, StageAPI stageAPI) {
        super(caseAPI, stage, stageAPI);
        Collection<PlanItem<?>> collection = stage.getPlanItems();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (PlanItem<?> planItem : collection) {
            PlanItemAPI<?> planItemAPI = this.createPlanItemContext(planItem);
            ItemDefinition itemDefinition = planItem.getItemDefinition();
            if (itemDefinition.getPlanItemControl().getRepetitionRule().isDefault()) {
                hashMap.put(itemDefinition.getName(), planItemAPI);
                continue;
            }
            List list = hashMap.getOrDefault(itemDefinition.getName(), new ArrayList());
            list.add(planItemAPI);
            hashMap.put(itemDefinition.getName(), list);
        }
        hashMap.forEach((string, object) -> this.addPropertyReader((String)string, () -> object));
        this.addPropertyReader("items", hashMap::values);
        this.addDeprecatedReader("planItems", "items", hashMap::values);
    }

    private PlanItemAPI<?> createPlanItemContext(PlanItem<?> planItem) {
        if (planItem instanceof Stage) {
            return new StageAPI(this.caseAPI, (Stage)planItem, this);
        }
        if (planItem instanceof Task) {
            return new TaskAPI(this.caseAPI, (Task)planItem, this);
        }
        if (planItem instanceof Milestone) {
            return new MilestoneAPI(this.caseAPI, (Milestone)planItem, this);
        }
        if (planItem instanceof TimerEvent) {
            return new TimerEventAPI(this.caseAPI, (TimerEvent)planItem, this);
        }
        return new PlanItemAPI(this.caseAPI, planItem, this);
    }

    @Override
    public String getName() {
        return "stage";
    }
}

